/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oceanbase;

import java.sql.SQLException;
import java.util.List;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oceanbase.OceanBaseOracleCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle.OracleCatalog;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class OceanBaseOracleCatalog
extends OracleCatalog {
    public OceanBaseOracleCatalog(String catalogName, String username, String pwd, JdbcUrlUtil.UrlInfo urlInfo, String defaultSchema, String driverClass) {
        super(catalogName, username, pwd, urlInfo, defaultSchema, driverClass);
    }

    @Override
    protected String getListDatabaseSql() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getDatabaseWithConditionSql(String databaseName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tableExists(TablePath tablePath) throws CatalogException {
        try {
            return this.querySQLResultExists(this.getUrlFromDatabaseName(tablePath.getDatabaseName()), this.getTableWithConditionSql(tablePath));
        }
        catch (SQLException e) {
            throw new SeaTunnelException("Failed to querySQLResult", (Throwable)e);
        }
    }

    @Override
    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        String dbUrl = this.getUrlFromDatabaseName(databaseName);
        try {
            return this.queryString(dbUrl, this.getListTableSql(databaseName), this::getTableName);
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    @Override
    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists, boolean createIndex) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"Table path cannot be null");
        if (this.defaultSchema.isPresent()) {
            tablePath = new TablePath(tablePath.getDatabaseName(), (String)this.defaultSchema.get(), tablePath.getTableName());
        }
        if (this.tableExists(tablePath)) {
            if (ignoreIfExists) {
                return;
            }
            throw new TableAlreadyExistException(this.catalogName, tablePath);
        }
        this.createTableInternal(tablePath, table, createIndex);
    }

    @Override
    protected List<String> getCreateTableSqls(TablePath tablePath, CatalogTable table, boolean createIndex) {
        return new OceanBaseOracleCreateTableSqlBuilder(table, createIndex).build(tablePath);
    }
}

