/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source.offset;

import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.time.Conversions;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;

public class LsnOffset
extends Offset {
    private static final long serialVersionUID = 1L;
    public static final LsnOffset INITIAL_OFFSET = new LsnOffset(Lsn.INVALID_LSN.asLong(), null, Instant.MIN);
    public static final LsnOffset NO_STOPPING_OFFSET = new LsnOffset(Lsn.valueOf("FFFFFFFF/FFFFFFFF").asLong(), null, Instant.MAX);
    private Lsn lsn;
    private Long txId;
    private Long xmin;

    public LsnOffset(Map<String, String> offset) {
        this.offset = offset;
    }

    public LsnOffset(Long lsn, Long txId, Instant lastCommitTs) {
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put("lsn", lsn.toString());
        if (txId != null) {
            offsetMap.put("txId", txId.toString());
        }
        if (lastCommitTs != null) {
            offsetMap.put("ts_usec", String.valueOf(Conversions.toEpochMicros((Instant)lastCommitTs)));
        }
        this.offset = offsetMap;
    }

    public static LsnOffset of(Map<String, ?> offsetMap) {
        HashMap<String, String> offsetStrMap = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : offsetMap.entrySet()) {
            offsetStrMap.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
        }
        return new LsnOffset(offsetStrMap);
    }

    public Lsn getLsn() {
        return Lsn.valueOf(Long.valueOf((String)this.offset.get("lsn")));
    }

    public Long getTxId() {
        return Long.parseLong((String)this.offset.get("txId"));
    }

    public Long getXmin() {
        return Long.parseLong((String)this.offset.get("xmin"));
    }

    public int compareTo(Offset o) {
        LsnOffset that = (LsnOffset)o;
        if (NO_STOPPING_OFFSET.equals((Object)that) && NO_STOPPING_OFFSET.equals((Object)this)) {
            return 0;
        }
        if (NO_STOPPING_OFFSET.equals((Object)this)) {
            return 1;
        }
        if (NO_STOPPING_OFFSET.equals((Object)that)) {
            return -1;
        }
        Lsn thisLsn = this.getLsn();
        Lsn thatLsn = that.getLsn();
        if (thatLsn.isValid()) {
            if (thisLsn.isValid()) {
                return thisLsn.compareTo(thatLsn);
            }
            return -1;
        }
        if (thisLsn.isValid()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LsnOffset)) {
            return false;
        }
        LsnOffset that = (LsnOffset)((Object)o);
        return this.offset.equals(that.offset);
    }
}

