/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption;

import java.security.AccessController;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class XMLCipherUtil {
    private static final System.Logger LOG = System.getLogger(XMLCipherUtil.class.getName());
    private static final boolean gcmUseIvParameterSpec = AccessController.doPrivileged(() -> Boolean.getBoolean("org.apache.xml.security.cipher.gcm.useIvParameterSpec"));

    public static AlgorithmParameterSpec constructBlockCipherParameters(String algorithm, byte[] iv) {
        if ("http://www.w3.org/2009/xmlenc11#aes128-gcm".equals(algorithm) || "http://www.w3.org/2009/xmlenc11#aes192-gcm".equals(algorithm) || "http://www.w3.org/2009/xmlenc11#aes256-gcm".equals(algorithm)) {
            return XMLCipherUtil.constructBlockCipherParametersForGCMAlgorithm(algorithm, iv);
        }
        LOG.log(System.Logger.Level.DEBUG, "Saw non-AES-GCM mode block cipher, returning IvParameterSpec: {0}", algorithm);
        return new IvParameterSpec(iv);
    }

    public static AlgorithmParameterSpec constructBlockCipherParameters(boolean gcmAlgorithm, byte[] iv) {
        if (gcmAlgorithm) {
            return XMLCipherUtil.constructBlockCipherParametersForGCMAlgorithm("AES/GCM/NoPadding", iv);
        }
        LOG.log(System.Logger.Level.DEBUG, "Saw non-AES-GCM mode block cipher, returning IvParameterSpec");
        return new IvParameterSpec(iv);
    }

    private static AlgorithmParameterSpec constructBlockCipherParametersForGCMAlgorithm(String algorithm, byte[] iv) {
        if (gcmUseIvParameterSpec) {
            LOG.log(System.Logger.Level.DEBUG, "Saw AES-GCM block cipher, using IvParameterSpec due to system property override: {0}", algorithm);
            return new IvParameterSpec(iv);
        }
        LOG.log(System.Logger.Level.DEBUG, "Saw AES-GCM block cipher, attempting to create GCMParameterSpec: {0}", algorithm);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
        LOG.log(System.Logger.Level.DEBUG, "Successfully created GCMParameterSpec");
        return gcmSpec;
    }
}

