/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.math.BigInteger;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.apache.jcp.xml.dsig.internal.dom.BaseStructure;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Element;

public final class DOMX509IssuerSerial
extends BaseStructure
implements X509IssuerSerial {
    private final String issuerName;
    private final BigInteger serialNumber;

    public DOMX509IssuerSerial(String issuerName, BigInteger serialNumber) {
        if (issuerName == null) {
            throw new NullPointerException("issuerName cannot be null");
        }
        if (serialNumber == null) {
            throw new NullPointerException("serialNumber cannot be null");
        }
        new X500Principal(issuerName);
        this.issuerName = issuerName;
        this.serialNumber = serialNumber;
    }

    public DOMX509IssuerSerial(Element isElem) throws MarshalException {
        Element iNElem = DOMUtils.getFirstChildElement(isElem, "X509IssuerName");
        Element sNElem = DOMUtils.getNextSiblingElement(iNElem, "X509SerialNumber");
        this.issuerName = iNElem.getFirstChild().getNodeValue();
        this.serialNumber = new BigInteger(sNElem.getFirstChild().getNodeValue());
    }

    @Override
    public String getIssuerName() {
        return this.issuerName;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof X509IssuerSerial)) {
            return false;
        }
        X509IssuerSerial ois = (X509IssuerSerial)obj;
        return this.issuerName.equals(ois.getIssuerName()) && this.serialNumber.equals(ois.getSerialNumber());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.issuerName.hashCode();
        result = 31 * result + this.serialNumber.hashCode();
        return result;
    }
}

