/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.ElementChecker;
import org.apache.xml.security.utils.ElementProxy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ElementCheckerImpl
implements ElementChecker {
    public boolean isNamespaceElement(Node el, String type, String ns) {
        return el != null && ns == el.getNamespaceURI() && el.getLocalName().equals(type);
    }

    public static class EmptyChecker
    extends ElementCheckerImpl {
        public void guaranteeThatElementInCorrectSpace(ElementProxy expected, Element actual) throws XMLSecurityException {
        }
    }

    public static class FullChecker
    extends ElementCheckerImpl {
        public void guaranteeThatElementInCorrectSpace(ElementProxy expected, Element actual) throws XMLSecurityException {
            String localnameSHOULDBE = expected.getBaseLocalName();
            String namespaceSHOULDBE = expected.getBaseNamespace();
            String localnameIS = actual.getLocalName();
            String namespaceIS = actual.getNamespaceURI();
            if (!namespaceSHOULDBE.equals(namespaceIS) || !localnameSHOULDBE.equals(localnameIS)) {
                Object[] exArgs = new Object[]{namespaceIS + ":" + localnameIS, namespaceSHOULDBE + ":" + localnameSHOULDBE};
                throw new XMLSecurityException("xml.WrongElement", exArgs);
            }
        }
    }

    public static class InternedNsChecker
    extends ElementCheckerImpl {
        public void guaranteeThatElementInCorrectSpace(ElementProxy expected, Element actual) throws XMLSecurityException {
            String localnameSHOULDBE = expected.getBaseLocalName();
            String namespaceSHOULDBE = expected.getBaseNamespace();
            String localnameIS = actual.getLocalName();
            String namespaceIS = actual.getNamespaceURI();
            if (namespaceSHOULDBE != namespaceIS || !localnameSHOULDBE.equals(localnameIS)) {
                Object[] exArgs = new Object[]{namespaceIS + ":" + localnameIS, namespaceSHOULDBE + ":" + localnameSHOULDBE};
                throw new XMLSecurityException("xml.WrongElement", exArgs);
            }
        }
    }
}

