/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XPath2NodeFilter
implements NodeFilter {
    boolean hasUnionFilter;
    boolean hasSubtractFilter;
    boolean hasIntersectFilter;
    Set unionNodes;
    Set subtractNodes;
    Set intersectNodes;
    int inSubtract = -1;
    int inIntersect = -1;
    int inUnion = -1;

    XPath2NodeFilter(List unionNodes, List subtractNodes, List intersectNodes) {
        this.hasUnionFilter = !unionNodes.isEmpty();
        this.unionNodes = XPath2NodeFilter.convertNodeListToSet(unionNodes);
        this.hasSubtractFilter = !subtractNodes.isEmpty();
        this.subtractNodes = XPath2NodeFilter.convertNodeListToSet(subtractNodes);
        this.hasIntersectFilter = !intersectNodes.isEmpty();
        this.intersectNodes = XPath2NodeFilter.convertNodeListToSet(intersectNodes);
    }

    public int isNodeInclude(Node currentNode) {
        int result = 1;
        if (this.hasSubtractFilter && XPath2NodeFilter.rooted(currentNode, this.subtractNodes)) {
            result = -1;
        } else if (this.hasIntersectFilter && !XPath2NodeFilter.rooted(currentNode, this.intersectNodes)) {
            result = 0;
        }
        if (result == 1) {
            return 1;
        }
        if (this.hasUnionFilter) {
            if (XPath2NodeFilter.rooted(currentNode, this.unionNodes)) {
                return 1;
            }
            result = 0;
        }
        return result;
    }

    public int isNodeIncludeDO(Node n, int level) {
        int result = 1;
        if (this.hasSubtractFilter) {
            if (this.inSubtract == -1 || level <= this.inSubtract) {
                this.inSubtract = XPath2NodeFilter.inList(n, this.subtractNodes) ? level : -1;
            }
            if (this.inSubtract != -1) {
                result = -1;
            }
        }
        if (result != -1 && this.hasIntersectFilter && (this.inIntersect == -1 || level <= this.inIntersect)) {
            if (!XPath2NodeFilter.inList(n, this.intersectNodes)) {
                this.inIntersect = -1;
                result = 0;
            } else {
                this.inIntersect = level;
            }
        }
        if (level <= this.inUnion) {
            this.inUnion = -1;
        }
        if (result == 1) {
            return 1;
        }
        if (this.hasUnionFilter) {
            if (this.inUnion == -1 && XPath2NodeFilter.inList(n, this.unionNodes)) {
                this.inUnion = level;
            }
            if (this.inUnion != -1) {
                return 1;
            }
            result = 0;
        }
        return result;
    }

    static boolean rooted(Node currentNode, Set nodeList) {
        if (nodeList.isEmpty()) {
            return false;
        }
        if (nodeList.contains(currentNode)) {
            return true;
        }
        Iterator it = nodeList.iterator();
        while (it.hasNext()) {
            Node rootNode = (Node)it.next();
            if (!XMLUtils.isDescendantOrSelf(rootNode, currentNode)) continue;
            return true;
        }
        return false;
    }

    static boolean inList(Node currentNode, Set nodeList) {
        return nodeList.contains(currentNode);
    }

    private static Set convertNodeListToSet(List l) {
        HashSet<Node> result = new HashSet<Node>();
        for (int j = 0; j < l.size(); ++j) {
            NodeList rootNodes = (NodeList)l.get(j);
            int length = rootNodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node rootNode = rootNodes.item(i);
                result.add(rootNode);
            }
        }
        return result;
    }
}

