/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms;

import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.Algorithm;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.algorithms.implementations.IntegrityHmac;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAlgorithm
extends Algorithm {
    static Log log = LogFactory.getLog((String)SignatureAlgorithm.class.getName());
    static boolean _alreadyInitialized = false;
    static HashMap _algorithmHash = null;
    protected SignatureAlgorithmSpi _signatureAlgorithm;
    private final String algorithmURI;

    public SignatureAlgorithm(Document doc, String algorithmURI) throws XMLSecurityException {
        super(doc, algorithmURI);
        this.algorithmURI = algorithmURI;
    }

    public SignatureAlgorithm(Document doc, String algorithmURI, int HMACOutputLength) throws XMLSecurityException {
        super(doc, algorithmURI);
        this.algorithmURI = algorithmURI;
        this.initializeAlgorithm();
        this._signatureAlgorithm.engineSetHMACOutputLength(HMACOutputLength);
        ((IntegrityHmac)this._signatureAlgorithm).engineAddContextToElement(this._constructionElement);
    }

    private static SignatureAlgorithmSpi getSignatureAlgorithmSpi(String algorithmURI) throws XMLSignatureException {
        try {
            Class implementingClass = (Class)_algorithmHash.get(algorithmURI);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create URI \"" + algorithmURI + "\" class \"" + implementingClass + "\""));
            }
            return (SignatureAlgorithmSpi)implementingClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
        catch (InstantiationException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
        catch (NullPointerException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
    }

    private void initializeAlgorithm() throws XMLSignatureException {
        this._signatureAlgorithm = SignatureAlgorithm.getSignatureAlgorithmSpi(this.algorithmURI);
        this._signatureAlgorithm.engineGetContextFromElement(this._constructionElement);
    }

    public SignatureAlgorithm(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
        this.algorithmURI = this.getURI();
    }

    public byte[] sign() throws XMLSignatureException {
        return this._signatureAlgorithm.engineSign();
    }

    public String getJCEAlgorithmString() {
        try {
            SignatureAlgorithmSpi signatureAlgorithmSpi = SignatureAlgorithm.getSignatureAlgorithmSpi(this.algorithmURI);
            return signatureAlgorithmSpi.engineGetJCEAlgorithmString();
        }
        catch (XMLSignatureException e) {
            return null;
        }
    }

    public String getJCEProviderName() {
        try {
            SignatureAlgorithmSpi signatureAlgorithmSpi = SignatureAlgorithm.getSignatureAlgorithmSpi(this.algorithmURI);
            return signatureAlgorithmSpi.engineGetJCEProviderName();
        }
        catch (XMLSignatureException e) {
            return null;
        }
    }

    public void update(byte[] input) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(input);
    }

    public void update(byte input) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(input);
    }

    public void update(byte[] buf, int offset, int len) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(buf, offset, len);
    }

    public void initSign(Key signingKey) throws XMLSignatureException {
        this.initializeAlgorithm();
        this._signatureAlgorithm.engineInitSign(signingKey);
    }

    public void initSign(Key signingKey, SecureRandom secureRandom) throws XMLSignatureException {
        this.initializeAlgorithm();
        this._signatureAlgorithm.engineInitSign(signingKey, secureRandom);
    }

    public void initSign(Key signingKey, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this.initializeAlgorithm();
        this._signatureAlgorithm.engineInitSign(signingKey, algorithmParameterSpec);
    }

    public void setParameter(AlgorithmParameterSpec params) throws XMLSignatureException {
        this._signatureAlgorithm.engineSetParameter(params);
    }

    public void initVerify(Key verificationKey) throws XMLSignatureException {
        this.initializeAlgorithm();
        this._signatureAlgorithm.engineInitVerify(verificationKey);
    }

    public void clearVerificationCache() {
    }

    public void clearSignatureCache() {
    }

    public boolean verify(byte[] signature) throws XMLSignatureException {
        return this._signatureAlgorithm.engineVerify(signature);
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public static void providerInit() {
        if (log == null) {
            log = LogFactory.getLog((String)SignatureAlgorithm.class.getName());
        }
        log.debug((Object)"Init() called");
        if (!_alreadyInitialized) {
            _algorithmHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String algorithmURI, String implementingClass) throws AlgorithmAlreadyRegisteredException, XMLSignatureException {
        String registeredClass;
        Class registeredClassClass;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Try to register " + algorithmURI + " " + implementingClass));
        }
        if ((registeredClassClass = SignatureAlgorithm.getImplementingClass(algorithmURI)) != null && (registeredClass = registeredClassClass.getName()) != null && registeredClass.length() != 0) {
            Object[] exArgs = new Object[]{algorithmURI, registeredClass};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", exArgs);
        }
        try {
            _algorithmHash.put(algorithmURI, Class.forName(implementingClass));
        }
        catch (ClassNotFoundException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
        catch (NullPointerException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
    }

    private static Class getImplementingClass(String URI2) {
        if (_algorithmHash == null) {
            return null;
        }
        return (Class)_algorithmHash.get(URI2);
    }

    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getBaseLocalName() {
        return "SignatureMethod";
    }
}

