/**
 * Generated by Apache Royale Compiler from org/apache/royale/reflection/AccessorDefinition.as
 * org.apache.royale.reflection.AccessorDefinition
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.reflection.AccessorDefinition');
goog.provide('org.apache.royale.reflection.AccessorDefinition.invalidGetter');
goog.provide('org.apache.royale.reflection.AccessorDefinition.invalidSetter');

goog.require('QName');
goog.require('org.apache.royale.reflection.TypeDefinition');
goog.require('org.apache.royale.reflection.VariableDefinition');
goog.require('org.apache.royale.reflection.getDefinitionByName');
goog.require('org.apache.royale.utils.Language');



/**
 * @constructor
 * @extends {org.apache.royale.reflection.VariableDefinition}
 * @param {string} name
 * @param {boolean} isStatic
 * @param {org.apache.royale.reflection.TypeDefinition} owner
 * @param {Object=} rawData
 */
org.apache.royale.reflection.AccessorDefinition = function(name, isStatic, owner, rawData) {
  rawData = typeof rawData !== 'undefined' ? rawData : null;
  org.apache.royale.reflection.AccessorDefinition.base(this, 'constructor', name, isStatic, owner, rawData);
};
goog.inherits(org.apache.royale.reflection.AccessorDefinition, org.apache.royale.reflection.VariableDefinition);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.reflection.AccessorDefinition', org.apache.royale.reflection.AccessorDefinition);


/**
 * @private
 * @type {string}
 */
org.apache.royale.reflection.AccessorDefinition.prototype.org_apache_royale_reflection_AccessorDefinition__access;


/**
 * A string representation of this accessor definition
 * @export
 * @override
 */
org.apache.royale.reflection.AccessorDefinition.prototype.toString = function() {
  var /** @type {number} */ i = 0;
  var /** @type {string} */ uriNS = this.uri;
  if (uriNS)
    uriNS = ', uri=\'' + uriNS + '\'';
  var /** @type {string} */ s = "accessor: '" + this.name + "'" + uriNS + " access:" + this.access + ", type:" + this.type.qualifiedName + ", declaredBy:" + this.declaredBy.qualifiedName;
  var /** @type {Array} */ meta = this.metadata;
  //var /** @type {number} */ i = 0;
  var /** @type {number} */ l = (meta.length) >>> 0;
  if (l) {
    s += "\n\tmetadata:";
    for (i = 0; i < l; i++) {
      s += "\n\t\t" + meta[i].toString().split("\n").join("\n\t\t");
    }
  }
  return s;
};


org.apache.royale.reflection.AccessorDefinition.prototype.get__declaredBy = function() {
  
  var /** @type {string} */ declareBy = org.apache.royale.utils.Language.string(this._rawData.declaredBy);
  return org.apache.royale.reflection.TypeDefinition.internalGetDefinition(declareBy);
};


org.apache.royale.reflection.AccessorDefinition.prototype.get__access = function() {
  if (this.org_apache_royale_reflection_AccessorDefinition__access)
    return this.org_apache_royale_reflection_AccessorDefinition__access;
  
  this.org_apache_royale_reflection_AccessorDefinition__access = org.apache.royale.utils.Language.string(this.rawData.access);
  return this.org_apache_royale_reflection_AccessorDefinition__access;
};


org.apache.royale.reflection.AccessorDefinition.prototype.get__getValue = function() {
  var self = this;
  if (this._getter != null)
    return this._getter;
  if (this.access.indexOf('read') == -1)
    return (this._getter = org.apache.royale.reflection.AccessorDefinition.invalidGetter);
  if (this.isStatic || goog.DEBUG) {
    var /** @type {Object} */ cl = org.apache.royale.utils.Language.as(org.apache.royale.reflection.getDefinitionByName(this.owner.qualifiedName), org.apache.royale.utils.Language.synthType('Class'));
  }
  var /** @type {string} */ fieldName = this.name;
  if (this.uri)
    fieldName = QName.getAsObjectAccessFormat(this.uri, fieldName);
  if (this.isStatic) {
    this._getter = function() {
      return cl[fieldName];
    };
  } else {
    this._getter = function(instance) {
      if (goog.DEBUG) {
        if (arguments.length != 1 || (!org.apache.royale.utils.Language.is(instance, cl)))
          throw 'invalid getValue parameters';
      }
      return instance[fieldName];
    };
  }
  return this._getter;
};


org.apache.royale.reflection.AccessorDefinition.prototype.get__setValue = function() {
  var self = this;
  if (this._setter != null)
    return this._setter;
  if (this.access.indexOf('write') == -1)
    return (this._setter = org.apache.royale.reflection.AccessorDefinition.invalidSetter);
  if (this.isStatic || goog.DEBUG) {
    var /** @type {Object} */ cl = org.apache.royale.utils.Language.as(org.apache.royale.reflection.getDefinitionByName(this.owner.qualifiedName), org.apache.royale.utils.Language.synthType('Class'));
  }
  var /** @type {string} */ fieldName = this.name;
  if (this.uri)
    fieldName = QName.getAsObjectAccessFormat(this.uri, fieldName);
  var /** @type {Object} */ valueClass;
  var /** @type {string} */ type = org.apache.royale.utils.Language.string(this._rawData.type);
  if (type && type != '*') {
    valueClass = org.apache.royale.reflection.getDefinitionByName(type);
  }
  if (this.isStatic) {
    this._setter = function(value) {
      if (valueClass)
        value = org.apache.royale.utils.Language.as(value, valueClass, true);
      cl[fieldName] = value;
    };
  } else {
    this._setter = function(instance, value) {
      if (goog.DEBUG) {
        if (arguments.length != 2 || (!org.apache.royale.utils.Language.is(instance, cl)))
          throw 'invalid setValue parameters';
      }
      if (valueClass)
        value = org.apache.royale.utils.Language.as(value, valueClass, true);
      instance[fieldName] = value;
    };
  }
  return this._setter;
};


Object.defineProperties(org.apache.royale.reflection.AccessorDefinition.prototype, /** @lends {org.apache.royale.reflection.AccessorDefinition.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.reflection.TypeDefinition} */
declaredBy: {
get: org.apache.royale.reflection.AccessorDefinition.prototype.get__declaredBy},
/**
  * @export
  * @type {string} */
access: {
get: org.apache.royale.reflection.AccessorDefinition.prototype.get__access},
/**
  * @export
  * @type {Function} */
getValue: {
get: org.apache.royale.reflection.AccessorDefinition.prototype.get__getValue},
/**
  * @export
  * @type {Function} */
setValue: {
get: org.apache.royale.reflection.AccessorDefinition.prototype.get__setValue}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.reflection.AccessorDefinition.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'AccessorDefinition', qName: 'org.apache.royale.reflection.AccessorDefinition', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.reflection.AccessorDefinition.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'declaredBy': { type: 'org.apache.royale.reflection.TypeDefinition', access: 'readonly', declaredBy: 'org.apache.royale.reflection.AccessorDefinition'},
        'access': { type: 'String', access: 'readonly', declaredBy: 'org.apache.royale.reflection.AccessorDefinition'},
        'getValue': { type: 'Function', access: 'readonly', declaredBy: 'org.apache.royale.reflection.AccessorDefinition'},
        'setValue': { type: 'Function', access: 'readonly', declaredBy: 'org.apache.royale.reflection.AccessorDefinition'}
      };
    },
    methods: function () {
      return {
        'AccessorDefinition': { type: '', declaredBy: 'org.apache.royale.reflection.AccessorDefinition', parameters: function () { return [ 'String', false ,'Boolean', false ,'org.apache.royale.reflection.TypeDefinition', false ,'Object', true ]; }},
        'toString': { type: 'String', declaredBy: 'org.apache.royale.reflection.AccessorDefinition'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.reflection.AccessorDefinition.prototype.ROYALE_COMPILE_FLAGS = 10;



/**
 * @export
 * @param {Object=} inst
 * @param {*=} val
 */
org.apache.royale.reflection.AccessorDefinition.invalidSetter = function(inst, val) {
  inst = typeof inst !== 'undefined' ? inst : null;
  val = typeof val !== 'undefined' ? val : undefined;
  throw new Error('write not possible for readOnly accessor');
}


/**
 * @export
 * @param {Object=} inst
 * @return {*}
 */
org.apache.royale.reflection.AccessorDefinition.invalidGetter = function(inst) {
  inst = typeof inst !== 'undefined' ? inst : null;
  throw new Error('read not possible for writeOnly accessor');
}