/**
 * Generated by Apache Royale Compiler from org/apache/royale/svg/LinearGradient.as
 * org.apache.royale.svg.LinearGradient
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.svg.LinearGradient');

goog.require('org.apache.royale.graphics.GradientBase');
goog.require('org.apache.royale.graphics.GradientEntry');
goog.require('org.apache.royale.graphics.IGraphicShape');
goog.require('org.apache.royale.utils.CSSUtils');
goog.require('org.apache.royale.graphics.IFill');



/**
 * @constructor
 * @extends {org.apache.royale.graphics.GradientBase}
 * @implements {org.apache.royale.graphics.IFill}
 */
org.apache.royale.svg.LinearGradient = function() {
  org.apache.royale.svg.LinearGradient.base(this, 'constructor');
};
goog.inherits(org.apache.royale.svg.LinearGradient, org.apache.royale.graphics.GradientBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.svg.LinearGradient', org.apache.royale.svg.LinearGradient);


/**
 * @private
 * @type {number}
 */
org.apache.royale.svg.LinearGradient.prototype.org_apache_royale_svg_LinearGradient__scaleX;


/**
 * addFillAttrib()
 *
 * @asparam value The IGraphicShape object on which the fill must be added.
 * @asreturn {string}
 * @royaleignorecoercion Node
 * @royaleignorecoercion HTMLElement
 * @export
 * @param {org.apache.royale.graphics.IGraphicShape} value
 * @return {string}
 */
org.apache.royale.svg.LinearGradient.prototype.addFillAttrib = function(value) {
  var /** @type {HTMLElement} */ valueElement = value.element;
  var /** @type {string} */ svgNS = valueElement.namespaceURI;
  var /** @type {HTMLElement} */ grad = document.createElementNS(svgNS, 'linearGradient');
  var /** @type {string} */ gradientId = this.newId;
  grad.setAttribute('id', gradientId);
  grad.setAttribute('x1', '0%');
  grad.setAttribute('y1', '0%');
  grad.setAttribute('x2', '100%');
  grad.setAttribute('y2', '0%');
  if (this.rotation) {
    grad.setAttribute('gradientTransform', 'rotate(' + this.rotation + ' 0.5 0.5)');
  }
  var /** @type {Array} */ entries = this.entries;
  for (var /** @type {number} */ i = 0; i < entries.length; i++) {
    var /** @type {org.apache.royale.graphics.GradientEntry} */ gradientEntry = entries[i];
    var /** @type {HTMLElement} */ stop = document.createElementNS(svgNS, 'stop');
    stop.setAttribute('offset', "" + (gradientEntry.ratio * 100) + '%');
    org.apache.royale.utils.CSSUtils.attributeFromColor(gradientEntry.color);
    stop.setAttribute('stop-color', org.apache.royale.utils.CSSUtils.attributeFromColor(gradientEntry.color));
    stop.setAttribute('stop-opacity', gradientEntry.alpha);
    grad.appendChild(stop);
  }
  var /** @type {Node} */ defs = valueElement.querySelector('defs') || valueElement.insertBefore(document.createElementNS(svgNS, 'defs'), valueElement.firstChild);
  defs.appendChild(grad);
  return 'fill:url(#' + gradientId + ')';
};


org.apache.royale.svg.LinearGradient.prototype.get__scaleX = function() {
  return this.org_apache_royale_svg_LinearGradient__scaleX;
};


org.apache.royale.svg.LinearGradient.prototype.set__scaleX = function(value) {
  this.org_apache_royale_svg_LinearGradient__scaleX = value;
};


Object.defineProperties(org.apache.royale.svg.LinearGradient.prototype, /** @lends {org.apache.royale.svg.LinearGradient.prototype} */ {
/**
  * @export
  * @type {number} */
scaleX: {
get: org.apache.royale.svg.LinearGradient.prototype.get__scaleX,
set: org.apache.royale.svg.LinearGradient.prototype.set__scaleX}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.svg.LinearGradient.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'LinearGradient', qName: 'org.apache.royale.svg.LinearGradient', kind: 'class' }], interfaces: [org.apache.royale.graphics.IFill] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.svg.LinearGradient.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'scaleX': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.svg.LinearGradient'}
      };
    },
    methods: function () {
      return {
        'addFillAttrib': { type: 'String', declaredBy: 'org.apache.royale.svg.LinearGradient', parameters: function () { return [ 'org.apache.royale.graphics.IGraphicShape', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.svg.LinearGradient.prototype.ROYALE_COMPILE_FLAGS = 10;