/**
 * Generated by Apache Royale Compiler from org/apache/royale/display/GraphicsGradientFill.as
 * org.apache.royale.display.GraphicsGradientFill
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.display.GraphicsGradientFill');

goog.require('org.apache.royale.display.Graphics');
goog.require('org.apache.royale.display.InterpolationMethod');
goog.require('org.apache.royale.geom.Matrix');
goog.require('org.apache.royale.display.IGraphicsData');
goog.require('org.apache.royale.display.IGraphicsFill');
goog.require('org.apache.royale.utils.Language');



/**
 * @constructor
 * @implements {org.apache.royale.display.IGraphicsFill}
 * @implements {org.apache.royale.display.IGraphicsData}
 * @param {string=} type
 * @param {Array=} colors
 * @param {Array=} alphas
 * @param {Array=} ratios
 * @param {*=} matrix
 * @param {*=} spreadMethod
 * @param {string=} interpolationMethod
 * @param {number=} focalPointRatio
 */
org.apache.royale.display.GraphicsGradientFill = function(type, colors, alphas, ratios, matrix, spreadMethod, interpolationMethod, focalPointRatio) {
  type = typeof type !== 'undefined' ? type : "linear";
  colors = typeof colors !== 'undefined' ? colors : null;
  alphas = typeof alphas !== 'undefined' ? alphas : null;
  ratios = typeof ratios !== 'undefined' ? ratios : null;
  matrix = typeof matrix !== 'undefined' ? matrix : null;
  spreadMethod = typeof spreadMethod !== 'undefined' ? spreadMethod : 'pad';
  interpolationMethod = typeof interpolationMethod !== 'undefined' ? interpolationMethod : "rgb";
  focalPointRatio = typeof focalPointRatio !== 'undefined' ? focalPointRatio : 0.0;
  this.type = type;
  this.colors = colors;
  this.alphas = alphas;
  this.ratios = ratios;
  this.matrix = matrix;
  this.spreadMethod = org.apache.royale.utils.Language.string(spreadMethod);
  this.interpolationMethod = interpolationMethod;
  this.focalPointRatio = focalPointRatio;
};


/**
 * @private
 * @type {org.apache.royale.geom.Matrix}
 */
org.apache.royale.display.GraphicsGradientFill._defaultMatrix;


/**
 * @type {Array}
 */
org.apache.royale.display.GraphicsGradientFill.prototype.alphas;


/**
 * @type {Array}
 */
org.apache.royale.display.GraphicsGradientFill.prototype.colors;


/**
 * @type {Array}
 */
org.apache.royale.display.GraphicsGradientFill.prototype.ratios;


/**
 * @type {org.apache.royale.geom.Matrix}
 */
org.apache.royale.display.GraphicsGradientFill.prototype.matrix;


/**
 * @type {string}
 */
org.apache.royale.display.GraphicsGradientFill.prototype.spreadMethod;


/**
 * @type {string}
 */
org.apache.royale.display.GraphicsGradientFill.prototype.type;


/**
 * @type {string}
 */
org.apache.royale.display.GraphicsGradientFill.prototype.interpolationMethod;


/**
 * @type {number}
 */
org.apache.royale.display.GraphicsGradientFill.prototype.focalPointRatio;


/**
 * @param {org.apache.royale.display.Graphics} graphics
 * @param {SVGPathElement} element
 */
org.apache.royale.display.GraphicsGradientFill.prototype.apply = function(graphics, element) {
  var /** @type {SVGGradientElement} */ fillElement = this.org_apache_royale_display_GraphicsGradientFill_configureGradientElement(graphics, graphics.makeGradient(this.type == 'linear' ? 'linearGradient' : 'radialGradient'));
  element.setAttributeNS(null, 'fill', 'url(#' + fillElement.getAttribute('id') + ')');
  if (this.interpolationMethod == org.apache.royale.display.InterpolationMethod.LINEAR_RGB) {
    element.setAttributeNS(null, 'filter', graphics.getLinearRGBfilter());
  }
};


/**
 * @param {org.apache.royale.display.Graphics} graphics
 * @param {SVGPathElement} element
 * @return {SVGPathElement}
 */
org.apache.royale.display.GraphicsGradientFill.prototype.applyStroke = function(graphics, element) {
  if (element.getAttributeNS(null, 'stroke-opacity') != null) {
    element.setAttributeNS(null, 'stroke-opacity', null);
  }
  var /** @type {boolean} */ linearRGB = this.interpolationMethod == org.apache.royale.display.InterpolationMethod.LINEAR_RGB;
  if (element.getAttributeNS(null, 'fill') !== 'none') {
    var /** @type {string} */ filterCheck = element.getAttributeNS(null, 'filter');
    if ((linearRGB && filterCheck != graphics.getLinearRGBfilter()) || (!linearRGB && filterCheck != null)) {
      element = graphics.spawnStroke(true);
      return element;
    }
  }
  var /** @type {SVGGradientElement} */ strokeElement = this.org_apache_royale_display_GraphicsGradientFill_configureGradientElement(graphics, graphics.makeGradient(this.type == 'linear' ? 'linearGradient' : 'radialGradient'));
  element.setAttributeNS(null, 'stroke', 'url(#' + strokeElement.getAttribute('id') + ')');
  if (linearRGB) {
    element.setAttributeNS(null, 'filter', graphics.getLinearRGBfilter());
  }
  return element;
};


/**
 * @private
 * @type {org.apache.royale.geom.Matrix}
 */
org.apache.royale.display.GraphicsGradientFill._utilMatrix;


/**
 * @private
 * @param {org.apache.royale.geom.Matrix} copyFrom
 * @return {org.apache.royale.geom.Matrix}
 */
org.apache.royale.display.GraphicsGradientFill.getUtilMatrix = function(copyFrom) {
  var /** @type {org.apache.royale.geom.Matrix} */ ret = org.apache.royale.display.GraphicsGradientFill._utilMatrix;
  if (!ret) {
    ret = org.apache.royale.display.GraphicsGradientFill._utilMatrix = new org.apache.royale.geom.Matrix();
  }
  ret.copyFrom(copyFrom);
  return ret;
};


/**
 * @private
 * @param {org.apache.royale.display.Graphics} graphics
 * @param {SVGGradientElement} gradientElement
 * @return {SVGGradientElement}
 */
org.apache.royale.display.GraphicsGradientFill.prototype.org_apache_royale_display_GraphicsGradientFill_configureGradientElement = function(graphics, gradientElement) {
  var /** @type {number} */ l = (this.colors.length) >>> 0;
  for (var /** @type {number} */ i = 0; i < l; i++) {
    var /** @type {string} */ hexColor = '#' + ('00000' + org.apache.royale.utils.Language.uint(this.colors[i]).toString(16)).substr(-6);
    var /** @type {SVGStopElement} */ stopElement = graphics.makeGradientStop();
    var /** @type {number} */ alpha = Number(this.alphas[i]);
    var /** @type {number} */ ratio = this.ratios[i] / 255;
    stopElement.setAttributeNS(null, 'stop-color', hexColor);
    if (alpha != 1)
      stopElement.setAttributeNS(null, 'stop-opacity', alpha.toString());
    stopElement.setAttributeNS(null, 'offset', ratio.toString());
    gradientElement.appendChild(stopElement);
  }
  var /** @type {org.apache.royale.geom.Matrix} */ matrix = this.matrix;
  if (!matrix) {
    if (org.apache.royale.display.GraphicsGradientFill._defaultMatrix)
      matrix = org.apache.royale.display.GraphicsGradientFill._defaultMatrix; else {
      matrix = org.apache.royale.display.GraphicsGradientFill._defaultMatrix = new org.apache.royale.geom.Matrix(0.1220703125, 0, 0, 0.1220703125);
    }
  }
  var /** @type {org.apache.royale.geom.Matrix} */ utilMatrix = matrix;
  var /** @type {number} */ h_len = 819.2;
  var /** @type {boolean} */ isRadial = this.type == 'radial';
  var /** @type {boolean} */ isLinear = this.type == 'linear';
  var /** @type {boolean} */ gTransform = false;
  if (Math.abs(utilMatrix.c) > 0.000001 || Math.abs(utilMatrix.b) > 0.000001) {
    if (-1.0 * (Math.round(utilMatrix.a * utilMatrix.c * 1000000) / 1000000) !== Math.round(utilMatrix.d * utilMatrix.b * 1000000) / 1000000) {
      utilMatrix = org.apache.royale.display.GraphicsGradientFill.getUtilMatrix(matrix);
      utilMatrix.translate(-matrix.tx, -matrix.ty);
      var /** @type {number} */ skewY = Math.atan2(utilMatrix.b, utilMatrix.a);
      var /** @type {number} */ skewX = -1 * Math.atan2(-utilMatrix.c, utilMatrix.d);
      var /** @type {number} */ diff = (Math["PI"] / 2) - (Math.abs(skewX) + Math.abs(skewY));
      if (skewX > 0)
        diff = -diff;
      var /** @type {number} */ axis_rot = skewY + diff;
      utilMatrix.rotate(axis_rot);
      skewX = Math.tan(skewX + skewY);
      utilMatrix.a += utilMatrix.b * skewX;
      utilMatrix.c += utilMatrix.d * skewX;
      utilMatrix.tx += utilMatrix.ty * skewX;
      if (isRadial) {
        gTransform = org.apache.royale.display.GraphicsGradientFill.uniformScaleAdjusted(utilMatrix);
      }
      utilMatrix.rotate(-axis_rot);
      utilMatrix.translate(matrix.tx, matrix.ty);
    } else {
      if (isRadial) {
        utilMatrix = org.apache.royale.display.GraphicsGradientFill.getUtilMatrix(matrix);
        utilMatrix.translate(-matrix.tx, -matrix.ty);
        axis_rot = Math.atan2(utilMatrix.b, utilMatrix.a);
        if (axis_rot)
          utilMatrix.rotate(-axis_rot);
        gTransform = org.apache.royale.display.GraphicsGradientFill.uniformScaleAdjusted(utilMatrix);
        if (gTransform) {
          if (axis_rot)
            utilMatrix.rotate(axis_rot);
          utilMatrix.translate(matrix.tx, matrix.ty);
        }
        else
          utilMatrix = matrix;
      }
    }
  } else {
    if (isRadial) {
      utilMatrix = org.apache.royale.display.GraphicsGradientFill.getUtilMatrix(matrix);
      utilMatrix.b = utilMatrix.c = 0;
      utilMatrix.translate(-matrix.tx, -matrix.ty);
      gTransform = org.apache.royale.display.GraphicsGradientFill.uniformScaleAdjusted(utilMatrix);
      utilMatrix.translate(matrix.tx, matrix.ty);
    }
  }
  if (isLinear) {
    gradientElement.setAttributeNS(null, 'x1', (utilMatrix.a * -h_len + utilMatrix.tx).toString());
    gradientElement.setAttributeNS(null, 'y1', (utilMatrix.b * -h_len + utilMatrix.ty).toString());
    gradientElement.setAttributeNS(null, 'x2', (utilMatrix.a * h_len + utilMatrix.tx).toString());
    gradientElement.setAttributeNS(null, 'y2', (utilMatrix.b * h_len + utilMatrix.ty).toString());
  } else if (isRadial) {
    var /** @type {number} */ fr = this.focalPointRatio;
    if (isNaN(fr))
      fr = -1;
    if (Math.abs(fr) > 1) {
      fr = fr < 0 ? -1 : 1;
    }
    if (fr) {
      fr *= h_len;
      gradientElement.setAttributeNS(null, 'fx', (utilMatrix.a * fr + utilMatrix.tx).toString());
      gradientElement.setAttributeNS(null, 'fy', (utilMatrix.b * fr + utilMatrix.ty).toString());
    }
    h_len *= h_len;
    gradientElement.setAttributeNS(null, 'r', Math.sqrt(utilMatrix.a * utilMatrix.a * h_len + utilMatrix.b * utilMatrix.b * h_len).toString());
    gradientElement.setAttributeNS(null, 'cx', matrix.tx.toString());
    gradientElement.setAttributeNS(null, 'cy', matrix.ty.toString());
    if (gTransform) {
      utilMatrix.invert();
      utilMatrix.concat(matrix);
      gradientElement.setAttributeNS(null, 'gradientTransform', 'matrix( ' + utilMatrix.a + ',' + utilMatrix.b + ',' + utilMatrix.c + ',' + utilMatrix.d + ',' + utilMatrix.tx + ',' + utilMatrix.ty + ')');
    }
  }
  gradientElement.setAttributeNS(null, 'spreadMethod', this.spreadMethod);
  return gradientElement;
};


/**
 * @private
 * @param {org.apache.royale.geom.Matrix} matrix
 * @return {boolean}
 */
org.apache.royale.display.GraphicsGradientFill.uniformScaleAdjusted = function(matrix) {
  var /** @type {number} */ x_s = matrix.a * matrix.a + matrix.b * matrix.b;
  var /** @type {number} */ y_s = matrix.c * matrix.c + matrix.d * matrix.d;
  if (y_s != x_s) {
    if (y_s < x_s) {
      matrix.b = matrix.c = 0;
      matrix.a = matrix.d = Math.sqrt(x_s);
    } else {
      matrix.b = matrix.c = 0;
      matrix.a = matrix.d = Math.sqrt(y_s);
    }
    return true;
  }
  return false;
};