/**
 * Generated by Apache Royale Compiler from org\apache\royale\graphics\SolidColorStroke.as
 * org.apache.royale.graphics.SolidColorStroke
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.graphics.SolidColorStroke');

goog.require('org.apache.royale.graphics.IGraphicShape');
goog.require('org.apache.royale.utils.CSSUtils');
goog.require('org.apache.royale.graphics.IStroke');



/**
 * @constructor
 * @implements {org.apache.royale.graphics.IStroke}
 * @param {number=} color
 * @param {number=} weight
 * @param {number=} alpha
 */
org.apache.royale.graphics.SolidColorStroke = function(color, weight, alpha) {
  color = typeof color !== 'undefined' ? color : 0x000000;
  weight = typeof weight !== 'undefined' ? weight : 1;
  alpha = typeof alpha !== 'undefined' ? alpha : 1.0;
  this.org_apache_royale_graphics_SolidColorStroke__color = Number(isNaN(color) ? 0 : color);
  this.org_apache_royale_graphics_SolidColorStroke__weight = isNaN(weight) ? 1 : weight;
  this.org_apache_royale_graphics_SolidColorStroke__alpha = isNaN(alpha) ? 1 : alpha;
  
  this.org_apache_royale_graphics_SolidColorStroke__lineCap = "butt";
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.graphics.SolidColorStroke', org.apache.royale.graphics.SolidColorStroke);


/**
 * @private
 * @type {number}
 */
org.apache.royale.graphics.SolidColorStroke.prototype.org_apache_royale_graphics_SolidColorStroke__alpha = 1.0;


/**
 * @private
 * @type {number}
 */
org.apache.royale.graphics.SolidColorStroke.prototype.org_apache_royale_graphics_SolidColorStroke__color = 0x000000;


/**
 * @private
 * @type {number}
 */
org.apache.royale.graphics.SolidColorStroke.prototype.org_apache_royale_graphics_SolidColorStroke__weight = 1;


/**
 * addStrokeAttrib()
 * 
 * @asparam value The IGraphicShape object on which the stroke must be added.
 * @asreturn {string}
 * @export
 * @param {org.apache.royale.graphics.IGraphicShape} value
 * @return {string}
 */
org.apache.royale.graphics.SolidColorStroke.prototype.addStrokeAttrib = function(value) {
  var /** @type {Array} */ att = ['stroke:' + org.apache.royale.utils.CSSUtils.attributeFromColor(this.color), 'stroke-width:' + this.weight, 'stroke-opacity:' + this.alpha, 'stroke-linecap:' + this.lineCap, 'stroke-linejoin:' + this.lineJoin, 'stroke-miterlimit:' + this.miterLimit];
  if (this.lineDash && this.lineDash.length)
    att.push('stroke-dasharray:' + this.lineDash.join(","));
  return att.join(";");
};


/**
 * @private
 * @type {string}
 */
org.apache.royale.graphics.SolidColorStroke.prototype.org_apache_royale_graphics_SolidColorStroke__lineCap;


/**
 * @private
 * @type {string}
 */
org.apache.royale.graphics.SolidColorStroke.prototype.org_apache_royale_graphics_SolidColorStroke__lineJoin = "miter";


/**
 * @private
 * @type {number}
 */
org.apache.royale.graphics.SolidColorStroke.prototype.org_apache_royale_graphics_SolidColorStroke__miterLimit = 4;


/**
 * @private
 * @type {Array}
 */
org.apache.royale.graphics.SolidColorStroke.prototype.org_apache_royale_graphics_SolidColorStroke__lineDash;


/**
 * @export
 * @param {number=} weight
 * @param {number=} color
 * @param {number=} alpha
 * @param {string=} caps
 * @param {string=} joints
 * @param {number=} miterLimit
 */
org.apache.royale.graphics.SolidColorStroke.prototype.setLineStyle = function(weight, color, alpha, caps, joints, miterLimit) {
  weight = typeof weight !== 'undefined' ? weight : NaN;
  color = typeof color !== 'undefined' ? color : 0;
  alpha = typeof alpha !== 'undefined' ? alpha : NaN;
  caps = typeof caps !== 'undefined' ? caps : null;
  joints = typeof joints !== 'undefined' ? joints : null;
  miterLimit = typeof miterLimit !== 'undefined' ? miterLimit : NaN;
  if (!isNaN(weight))
    this.org_apache_royale_graphics_SolidColorStroke__weight = weight;
  this.org_apache_royale_graphics_SolidColorStroke__color = color;
  if (!isNaN(alpha))
    this.org_apache_royale_graphics_SolidColorStroke__alpha = alpha;
  if (caps)
    this.org_apache_royale_graphics_SolidColorStroke__lineCap = caps;
  if (joints)
    this.org_apache_royale_graphics_SolidColorStroke__lineJoin = joints;
  if (!isNaN(miterLimit))
    this.org_apache_royale_graphics_SolidColorStroke__miterLimit = miterLimit;
};


org.apache.royale.graphics.SolidColorStroke.prototype.get__alpha = function() {
  return this.org_apache_royale_graphics_SolidColorStroke__alpha;
};


org.apache.royale.graphics.SolidColorStroke.prototype.set__alpha = function(value) {
  var /** @type {number} */ oldValue = this.org_apache_royale_graphics_SolidColorStroke__alpha;
  if (value != oldValue) {
    this.org_apache_royale_graphics_SolidColorStroke__alpha = value;
  }
};


org.apache.royale.graphics.SolidColorStroke.prototype.get__color = function() {
  return this.org_apache_royale_graphics_SolidColorStroke__color;
};


org.apache.royale.graphics.SolidColorStroke.prototype.set__color = function(value) {
  if (value < 0 || value > 0xffffff)
    throw new Error("Color values must be between 0 and 0xFFFFFF");
  var /** @type {number} */ oldValue = this.org_apache_royale_graphics_SolidColorStroke__color;
  if (value != oldValue) {
    this.org_apache_royale_graphics_SolidColorStroke__color = value;
  }
};


org.apache.royale.graphics.SolidColorStroke.prototype.get__weight = function() {
  return this.org_apache_royale_graphics_SolidColorStroke__weight;
};


org.apache.royale.graphics.SolidColorStroke.prototype.set__weight = function(value) {
  this.org_apache_royale_graphics_SolidColorStroke__weight = value;
};


org.apache.royale.graphics.SolidColorStroke.prototype.get__lineCap = function() {
  return this.org_apache_royale_graphics_SolidColorStroke__lineCap;
};


org.apache.royale.graphics.SolidColorStroke.prototype.set__lineCap = function(val) {
  
  this.org_apache_royale_graphics_SolidColorStroke__lineCap = val;
};


org.apache.royale.graphics.SolidColorStroke.prototype.get__lineJoin = function() {
  return this.org_apache_royale_graphics_SolidColorStroke__lineJoin;
};


org.apache.royale.graphics.SolidColorStroke.prototype.set__lineJoin = function(val) {
  this.org_apache_royale_graphics_SolidColorStroke__lineJoin = val;
};


org.apache.royale.graphics.SolidColorStroke.prototype.get__miterLimit = function() {
  return this.org_apache_royale_graphics_SolidColorStroke__miterLimit;
};


org.apache.royale.graphics.SolidColorStroke.prototype.set__miterLimit = function(val) {
  this.org_apache_royale_graphics_SolidColorStroke__miterLimit = val;
};


org.apache.royale.graphics.SolidColorStroke.prototype.get__lineDash = function() {
  return this.org_apache_royale_graphics_SolidColorStroke__lineDash;
};


org.apache.royale.graphics.SolidColorStroke.prototype.set__lineDash = function(val) {
  this.org_apache_royale_graphics_SolidColorStroke__lineDash = val;
};


Object.defineProperties(org.apache.royale.graphics.SolidColorStroke.prototype, /** @lends {org.apache.royale.graphics.SolidColorStroke.prototype} */ {
/**
  * @export
  * @type {number} */
alpha: {
get: org.apache.royale.graphics.SolidColorStroke.prototype.get__alpha,
set: org.apache.royale.graphics.SolidColorStroke.prototype.set__alpha},
/**
  * @export
  * @type {number} */
color: {
get: org.apache.royale.graphics.SolidColorStroke.prototype.get__color,
set: org.apache.royale.graphics.SolidColorStroke.prototype.set__color},
/**
  * @export
  * @type {number} */
weight: {
get: org.apache.royale.graphics.SolidColorStroke.prototype.get__weight,
set: org.apache.royale.graphics.SolidColorStroke.prototype.set__weight},
/**
  * @export
  * @type {string} */
lineCap: {
get: org.apache.royale.graphics.SolidColorStroke.prototype.get__lineCap,
set: org.apache.royale.graphics.SolidColorStroke.prototype.set__lineCap},
/**
  * @export
  * @type {string} */
lineJoin: {
get: org.apache.royale.graphics.SolidColorStroke.prototype.get__lineJoin,
set: org.apache.royale.graphics.SolidColorStroke.prototype.set__lineJoin},
/**
  * @export
  * @type {number} */
miterLimit: {
get: org.apache.royale.graphics.SolidColorStroke.prototype.get__miterLimit,
set: org.apache.royale.graphics.SolidColorStroke.prototype.set__miterLimit},
/**
  * @export
  * @type {Array} */
lineDash: {
get: org.apache.royale.graphics.SolidColorStroke.prototype.get__lineDash,
set: org.apache.royale.graphics.SolidColorStroke.prototype.set__lineDash}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.graphics.SolidColorStroke.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'SolidColorStroke', qName: 'org.apache.royale.graphics.SolidColorStroke', kind: 'class' }], interfaces: [org.apache.royale.graphics.IStroke] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.graphics.SolidColorStroke.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'alpha': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.graphics.SolidColorStroke'},
        'color': { type: 'uint', access: 'readwrite', declaredBy: 'org.apache.royale.graphics.SolidColorStroke'},
        'weight': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.graphics.SolidColorStroke'},
        'lineCap': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.graphics.SolidColorStroke'},
        'lineJoin': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.graphics.SolidColorStroke'},
        'miterLimit': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.graphics.SolidColorStroke'},
        'lineDash': { type: 'Array', access: 'readwrite', declaredBy: 'org.apache.royale.graphics.SolidColorStroke'}
      };
    },
    methods: function () {
      return {
        'SolidColorStroke': { type: '', declaredBy: 'org.apache.royale.graphics.SolidColorStroke', parameters: function () { return [  { index: 1, type: 'uint', optional: true },{ index: 2, type: 'Number', optional: true },{ index: 3, type: 'Number', optional: true } ]; }},
        'addStrokeAttrib': { type: 'String', declaredBy: 'org.apache.royale.graphics.SolidColorStroke', parameters: function () { return [  { index: 1, type: 'org.apache.royale.graphics.IGraphicShape', optional: false } ]; }},
        'setLineStyle': { type: 'void', declaredBy: 'org.apache.royale.graphics.SolidColorStroke', parameters: function () { return [  { index: 1, type: 'Number', optional: true },{ index: 2, type: 'uint', optional: true },{ index: 3, type: 'Number', optional: true },{ index: 4, type: 'String', optional: true },{ index: 5, type: 'String', optional: true },{ index: 6, type: 'Number', optional: true } ]; }}
      };
    }
  };
};