/**
 * Generated by Apache Royale Compiler from org/apache/royale/events/DragEvent.as
 * org.apache.royale.events.DragEvent
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.events.DragEvent');

goog.require('org.apache.royale.core.IDragInitiator');
goog.require('org.apache.royale.events.DragEventBase');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.events.MouseEvent');



/**
 *  Constructor.  Do not call 'new DragEvent', use the
 *  createDragEvent method instead.
 *  
 *  @asparam type The name of the event.
 *  @asparam bubbles Whether the event bubbles.
 *  @asparam cancelable Whether the event can be canceled.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @extends {org.apache.royale.events.DragEventBase}
 * @param {string} type
 * @param {boolean=} bubbles
 * @param {boolean=} cancelable
 */
org.apache.royale.events.DragEvent = function(type, bubbles, cancelable) {
  org.apache.royale.events.DragEvent.base(this, 'constructor');
  bubbles = typeof bubbles !== 'undefined' ? bubbles : false;
  cancelable = typeof cancelable !== 'undefined' ? cancelable : false;
  
  this.type = type;
  this.bubbles = bubbles;
};
goog.inherits(org.apache.royale.events.DragEvent, org.apache.royale.events.DragEventBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.events.DragEvent', org.apache.royale.events.DragEvent);


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_START = "dragStart";


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_MOVE = "dragMove";


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_END = "dragEnd";


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_ENTER = "dragEnter";


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_OVER = "dragOver";


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_EXIT = "dragExit";


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.events.DragEvent.DRAG_DROP = "dragDrop";


/**
 * @export
 * @nocollapse
 * @type {org.apache.royale.core.IDragInitiator}
 */
org.apache.royale.events.DragEvent.dragInitiator;


/**
 * @export
 * @nocollapse
 * @type {Object}
 */
org.apache.royale.events.DragEvent.dragSource;


/**
 * @private
 * @type {Object}
 */
org.apache.royale.events.DragEvent.prototype.org_apache_royale_events_DragEvent__relatedObject;


/**
 *  Factory for DragEvents.
 *  
 *  @asparam type The name of the event.
 *  @asparam event The MouseEvent properties to copy into the DragEvent.
 *  @asreturn The new DragEvent.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.events.DragEvent
 *  @royaleignorecoercion window.Event
 *  @royaleignorecoercion Event
 * @export
 * @param {string} type
 * @param {org.apache.royale.events.MouseEvent} event
 * @return {Object}
 */
org.apache.royale.events.DragEvent.createDragEvent = function(type, event) {
  
  var /** @type {Object} */ de = new org.apache.royale.events.DragEvent(type, true, true);
  de.altKey = event.altKey;
  de.ctrlKey = event.ctrlKey;
  de.shiftKey = event.shiftKey;
  de.relatedObject = event.target;
  de.clientX = event.clientX;
  de.clientY = event.clientY;
  return de;
};


/**
 *  Dispatch a DragEvent
 *  
 *  @asparam event The DragEvent to dispatch.
 *  @asparam target The target to dispatch the event from.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.core.IUIBase
 *  @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 *  @royaleignorecoercion window.Event
 * @export
 * @param {org.apache.royale.events.DragEvent} event
 * @param {Object} target
 */
org.apache.royale.events.DragEvent.dispatchDragEvent = function(event, target) {
  
  target.dispatchEvent(event);
};


/**
 * @private
 * @return {boolean}
 */
org.apache.royale.events.DragEvent.installDragEventMixin = function() {
  return true;
};


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.events.DragEvent.dragEventMixin;


org.apache.royale.events.DragEvent.prototype.get__relatedObject = function() {
  return this.org_apache_royale_events_DragEvent__relatedObject;
};


org.apache.royale.events.DragEvent.prototype.set__relatedObject = function(value) {
  this.org_apache_royale_events_DragEvent__relatedObject = value;
};


Object.defineProperties(org.apache.royale.events.DragEvent.prototype, /** @lends {org.apache.royale.events.DragEvent.prototype} */ {
/**
  * @export
  * @type {Object} */
relatedObject: {
get: org.apache.royale.events.DragEvent.prototype.get__relatedObject,
set: org.apache.royale.events.DragEvent.prototype.set__relatedObject}}
);

org.apache.royale.events.DragEvent.dragEventMixin = org.apache.royale.events.DragEvent.installDragEventMixin();




/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.events.DragEvent.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'DragEvent', qName: 'org.apache.royale.events.DragEvent', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.events.DragEvent.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        '|dragInitiator': { type: 'org.apache.royale.core.IDragInitiator', get_set: function (/** * */ v) {return v !== undefined ? org.apache.royale.events.DragEvent.dragInitiator = v : org.apache.royale.events.DragEvent.dragInitiator;}},
        '|dragSource': { type: 'Object', get_set: function (/** * */ v) {return v !== undefined ? org.apache.royale.events.DragEvent.dragSource = v : org.apache.royale.events.DragEvent.dragSource;}}
      };
    },
    accessors: function () {
      return {
        'relatedObject': { type: 'Object', access: 'readwrite', declaredBy: 'org.apache.royale.events.DragEvent'}
      };
    },
    methods: function () {
      return {
        'DragEvent': { type: '', declaredBy: 'org.apache.royale.events.DragEvent', parameters: function () { return [ 'String', false ,'Boolean', true ,'Boolean', true ]; }},
        '|createDragEvent': { type: 'org.apache.royale.events.DragEvent', declaredBy: 'org.apache.royale.events.DragEvent', parameters: function () { return [ 'String', false ,'org.apache.royale.events.MouseEvent', false ]; }},
        '|dispatchDragEvent': { type: 'void', declaredBy: 'org.apache.royale.events.DragEvent', parameters: function () { return [ 'org.apache.royale.events.DragEvent', false ,'Object', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.events.DragEvent.prototype.ROYALE_COMPILE_FLAGS = 10;