/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/SingleSelectionDragSourceBead.as
 * org.apache.royale.html.beads.SingleSelectionDragSourceBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.SingleSelectionDragSourceBead');

goog.require('org.apache.royale.collections.ArrayList');
goog.require('org.apache.royale.core.IChild');
goog.require('org.apache.royale.core.IDataProviderModel');
goog.require('org.apache.royale.core.IItemRenderer');
goog.require('org.apache.royale.core.ISelectionModel');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.events.DragEvent');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.html.beads.controllers.DragMouseController');
goog.require('org.apache.royale.utils.getParentOrSelfByType');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.core.IDragInitiator');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.core.IBead}
 * @implements {org.apache.royale.core.IDragInitiator}
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead = function() {
  org.apache.royale.html.beads.SingleSelectionDragSourceBead.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.SingleSelectionDragSourceBead, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.SingleSelectionDragSourceBead', org.apache.royale.html.beads.SingleSelectionDragSourceBead);


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype._strand;


/**
 * @private
 * @type {org.apache.royale.html.beads.controllers.DragMouseController}
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype._dragController;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.continueDragOperation = true;


/**
 * @private
 * @type {string}
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype._dragType = "move";


/**
 * @private
 * @type {number}
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype._dragSourceIndex = -1;


/**
 * @asprivate
 * @private
 * @param {org.apache.royale.events.DragEvent} event
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.handleDragStart = function(event) {
  org.apache.royale.events.DragEvent.dragInitiator = this;
  org.apache.royale.html.beads.controllers.DragMouseController.dragImageOffsetX = 0;
  org.apache.royale.html.beads.controllers.DragMouseController.dragImageOffsetY = -30;
  var /** @type {Object} */ relatedObject = event.relatedObject;
  var /** @type {org.apache.royale.core.IItemRenderer} */ itemRenderer = org.apache.royale.utils.Language.as(org.apache.royale.utils.getParentOrSelfByType(org.apache.royale.utils.Language.as(relatedObject, org.apache.royale.core.IChild), org.apache.royale.core.IItemRenderer), org.apache.royale.core.IItemRenderer);
  if (itemRenderer) {
    var /** @type {org.apache.royale.core.UIBase} */ p = org.apache.royale.utils.Language.as(itemRenderer.itemRendererParent, org.apache.royale.core.UIBase);
    this._dragSourceIndex = p.getElementIndex(org.apache.royale.utils.Language.as(itemRenderer, org.apache.royale.core.IChild));
    org.apache.royale.events.DragEvent.dragSource = org.apache.royale.utils.Language.as(itemRenderer, org.apache.royale.core.IItemRenderer).data;
  }
  var /** @type {org.apache.royale.events.Event} */ newEvent = new org.apache.royale.events.Event("start", false, true);
  this.dispatchEvent(newEvent);
  if (newEvent.defaultPrevented) {
    this.continueDragOperation = false;
  }
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.royale.events.DragEvent} event
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.handleDragMove = function(event) {
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.royale.events.DragEvent} event
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.handleDragEnd = function(event) {
};


/**
 * Handles pre-drop actions.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 * @export
 * @param {Object} dropTarget
 * @param {string} type
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.acceptingDrop = function(dropTarget, type) {
  if (!this.continueDragOperation)
    return;
  var /** @type {org.apache.royale.events.Event} */ newEvent = new org.apache.royale.events.Event("accept", false, true);
  this.dispatchEvent(newEvent);
  if (newEvent.defaultPrevented)
    return;
  var /** @type {org.apache.royale.core.IDataProviderModel} */ dataProviderModel = org.apache.royale.utils.Language.as(this._strand.getBeadByType(org.apache.royale.core.IDataProviderModel), org.apache.royale.core.IDataProviderModel);
  if (org.apache.royale.utils.Language.is(dataProviderModel, org.apache.royale.core.ISelectionModel)) {
    org.apache.royale.utils.Language.as(dataProviderModel, org.apache.royale.core.ISelectionModel).selectedIndex = -1;
  }
  if (this.dragType == "copy")
    return;
  if (org.apache.royale.utils.Language.is(dataProviderModel.dataProvider, Array)) {
    var /** @type {Array} */ dataArray = org.apache.royale.utils.Language.as(dataProviderModel.dataProvider, Array);
    org.apache.royale.events.DragEvent.dragSource = dataArray.splice(this._dragSourceIndex, 1)[0];
    var /** @type {Array} */ newArray = dataArray.slice();
    dataProviderModel.dataProvider = newArray;
  } else if (org.apache.royale.utils.Language.is(dataProviderModel.dataProvider, org.apache.royale.collections.ArrayList)) {
    var /** @type {org.apache.royale.collections.ArrayList} */ dataList = org.apache.royale.utils.Language.as(dataProviderModel.dataProvider, org.apache.royale.collections.ArrayList);
    org.apache.royale.events.DragEvent.dragSource = dataList.removeItemAt(this._dragSourceIndex);
  }
};


/**
 * Handles post-drop actions.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 * @export
 * @param {Object} dropTarget
 * @param {string} type
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.acceptedDrop = function(dropTarget, type) {
  var /** @type {Object} */ value = org.apache.royale.events.DragEvent.dragSource;
  this._dragSourceIndex = -1;
  this.dispatchEvent(new org.apache.royale.events.Event("complete"));
};


org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.get__dragType = function() {
  return this._dragType;
};


org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.set__dragType = function(value) {
  this._dragType = value;
};


org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.set__strand = function(value) {
  this._strand = value;
  this._dragController = new org.apache.royale.html.beads.controllers.DragMouseController();
  this._strand.addBead(this._dragController);
  org.apache.royale.utils.Language.as(this._strand, org.apache.royale.events.IEventDispatcher, true).addEventListener(org.apache.royale.events.DragEvent.DRAG_START, org.apache.royale.utils.Language.closure(this.handleDragStart, this, 'handleDragStart'));
  org.apache.royale.utils.Language.as(this._strand, org.apache.royale.events.IEventDispatcher, true).addEventListener(org.apache.royale.events.DragEvent.DRAG_MOVE, org.apache.royale.utils.Language.closure(this.handleDragMove, this, 'handleDragMove'));
  org.apache.royale.utils.Language.as(this._strand, org.apache.royale.events.IEventDispatcher, true).addEventListener(org.apache.royale.events.DragEvent.DRAG_END, org.apache.royale.utils.Language.closure(this.handleDragEnd, this, 'handleDragEnd'));
};


org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.get__dragSourceIndex = function() {
  return this._dragSourceIndex;
};


Object.defineProperties(org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype, /** @lends {org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype} */ {
/**
  * @export
  * @type {string} */
dragType: {
get: org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.get__dragType,
set: org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.set__dragType},
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.set__strand},
/**
  * @export
  * @type {number} */
dragSourceIndex: {
get: org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.get__dragSourceIndex}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'SingleSelectionDragSourceBead', qName: 'org.apache.royale.html.beads.SingleSelectionDragSourceBead', kind: 'class' }], interfaces: [org.apache.royale.core.IBead, org.apache.royale.core.IDragInitiator] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.SingleSelectionDragSourceBead.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'dragType': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.html.beads.SingleSelectionDragSourceBead'},
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.SingleSelectionDragSourceBead'},
        'dragSourceIndex': { type: 'int', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.SingleSelectionDragSourceBead'}
      };
    },
    methods: function () {
      return {
        'SingleSelectionDragSourceBead': { type: '', declaredBy: 'org.apache.royale.html.beads.SingleSelectionDragSourceBead'},
        'acceptingDrop': { type: 'void', declaredBy: 'org.apache.royale.html.beads.SingleSelectionDragSourceBead', parameters: function () { return [  { index: 1, type: 'Object', optional: false },{ index: 2, type: 'String', optional: false } ]; }},
        'acceptedDrop': { type: 'void', declaredBy: 'org.apache.royale.html.beads.SingleSelectionDragSourceBead', parameters: function () { return [  { index: 1, type: 'Object', optional: false },{ index: 2, type: 'String', optional: false } ]; }}
      };
    },
    metadata: function () { return [  ]; }
  };
};