/**
 * Generated by Apache Royale Compiler from org/apache/royale/collections/Sort.as
 * org.apache.royale.collections.Sort
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.collections.Sort');

goog.require('org.apache.royale.collections.ISortField');
goog.require('org.apache.royale.collections.SortField');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.collections.ISort');
goog.require('org.apache.royale.utils.Language');



/**
 *  Constructor.
 *
 *  <p>Creates a new Sort with no fields set and no custom comparator.</p>
 *
 *  @asparam fields An <code>Array</code> of <code>ISortField</code> objects that
 *  specifies the fields to compare.
 *  @asparam customCompareFunction Use a custom function to compare the
 *  objects in the collection to which this sort will be applied.
 *  @asparam unique Indicates if the sort should be unique.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.collections.ISort}
 * @param {Array=} fields
 * @param {Function=} customCompareFunction
 * @param {boolean=} unique
 */
org.apache.royale.collections.Sort = function(fields, customCompareFunction, unique) {
  fields = typeof fields !== 'undefined' ? fields : null;
  customCompareFunction = typeof customCompareFunction !== 'undefined' ? customCompareFunction : null;
  unique = typeof unique !== 'undefined' ? unique : false;
  org.apache.royale.collections.Sort.base(this, 'constructor');
  this.fields = fields;
  this.compareFunction = customCompareFunction;
  this.unique = unique;
};
goog.inherits(org.apache.royale.collections.Sort, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.collections.Sort', org.apache.royale.collections.Sort);


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.collections.Sort.ANY_INDEX_MODE = "any";


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.collections.Sort.FIRST_INDEX_MODE = "first";


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.collections.Sort.LAST_INDEX_MODE = "last";


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.collections.Sort.prototype.org_apache_royale_collections_Sort__useSortOn = true;


/**
 * @private
 * @type {Function}
 */
org.apache.royale.collections.Sort.prototype.org_apache_royale_collections_Sort__compareFunction;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.collections.Sort.prototype.org_apache_royale_collections_Sort_usingCustomCompareFunction;


/**
 * @private
 * @type {Array}
 */
org.apache.royale.collections.Sort.prototype.org_apache_royale_collections_Sort__fields;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.collections.Sort.prototype.org_apache_royale_collections_Sort__unique;


/**
 *  @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Array} items
 * @param {Object} values
 * @param {string} mode
 * @param {boolean=} returnInsertionIndex
 * @param {Function=} compareFunction
 * @return {number}
 */
org.apache.royale.collections.Sort.prototype.findItem = function(items, values, mode, returnInsertionIndex, compareFunction) {
  returnInsertionIndex = typeof returnInsertionIndex !== 'undefined' ? returnInsertionIndex : false;
  compareFunction = typeof compareFunction !== 'undefined' ? compareFunction : null;
  var /** @type {Function} */ compareForFind;
  var /** @type {Array} */ fieldsForCompare;
  var /** @type {string} */ message;
  if (!items) {
    throw new Error('no items for findItem');
  } else if (items.length == 0) {
    return (returnInsertionIndex ? 1 : -1) >> 0;
  }
  if (compareFunction == null) {
    compareForFind = this.compareFunction;
    if (values && this.fields && this.fields.length > 0) {
      fieldsForCompare = [];
      var /** @type {org.apache.royale.collections.ISortField} */ field;
      var /** @type {boolean} */ hadPreviousFieldName = true;
      for (var /** @type {number} */ i = 0; i < this.fields.length; i++) {
        field = org.apache.royale.utils.Language.as(this.fields[i], org.apache.royale.collections.ISortField);
        if (field.name) {
          if (field.objectHasSortField(values)) {
            if (!hadPreviousFieldName) {
              throw new Error("findCondition error with field name ", field.name);
            } else {
              fieldsForCompare.push(field.name);
            }
          } else {
            hadPreviousFieldName = false;
          }
        } else {
          fieldsForCompare.push(null);
        }
      }
      if (fieldsForCompare.length == 0) {
        throw new Error("findRestriction error in Sort");
      } else {
        try {
          this.org_apache_royale_collections_Sort_initSortFields(items[0]);
        } catch (initError) {
        }
      }
    }
  } else {
    compareForFind = compareFunction;
  }
  var /** @type {boolean} */ found = false;
  var /** @type {boolean} */ objFound = false;
  var /** @type {number} */ index = 0;
  var /** @type {number} */ lowerBound = 0;
  var /** @type {number} */ upperBound = (items.length - 1) >> 0;
  var /** @type {Object} */ obj = null;
  var /** @type {number} */ direction = 1;
  while (!objFound && (lowerBound <= upperBound)) {
    index = (Math.round((lowerBound + upperBound) / 2)) >> 0;
    obj = items[index];
    direction = (fieldsForCompare ? compareForFind(values, obj, fieldsForCompare) : compareForFind(values, obj)) >> 0;
    switch (direction) {
      case -1:
        upperBound = (index - 1) >> 0;
        break;
      case 0:
        objFound = true;
        switch (mode) {
          case org.apache.royale.collections.Sort.ANY_INDEX_MODE:
            found = true;
            break;
          case org.apache.royale.collections.Sort.FIRST_INDEX_MODE:
            found = (index == lowerBound);
            var /** @type {number} */ objIndex = (index - 1) >> 0;
            var /** @type {boolean} */ match = true;
            while (match && !found && (objIndex >= lowerBound)) {
              obj = items[objIndex];
              var /** @type {number} */ prevCompare = (fieldsForCompare ? compareForFind(values, obj, fieldsForCompare) : compareForFind(values, obj)) >> 0;
              match = (prevCompare == 0);
              if (!match || (match && (objIndex == lowerBound))) {
                found = true;
                index = (objIndex + (match ? 0 : 1)) >> 0;
              }
              objIndex--;
            }
            break;
          case org.apache.royale.collections.Sort.LAST_INDEX_MODE:
            found = (index == upperBound);
            objIndex = (index + 1) >> 0;
            match = true;
            while (match && !found && (objIndex <= upperBound)) {
              obj = items[objIndex];
              var /** @type {number} */ nextCompare = (fieldsForCompare ? compareForFind(values, obj, fieldsForCompare) : compareForFind(values, obj)) >> 0;
              match = (nextCompare == 0);
              if (!match || (match && (objIndex == upperBound))) {
                found = true;
                index = (objIndex - (match ? 0 : 1)) >> 0;
              }
              objIndex++;
            }
            break;
          default:
            throw new Error("unknown sort mode in Sort:" + mode);
        }
        break;
      case 1:
        lowerBound = (index + 1) >> 0;
        break;
    }
  }
  if (!found && !returnInsertionIndex) {
    return -1;
  } else {
    return ((direction > 0) ? index + 1 : index) >> 0;
  }
};


/**
 *  @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {string} property
 * @return {boolean}
 */
org.apache.royale.collections.Sort.prototype.propertyAffectsSort = function(property) {
  if (this.org_apache_royale_collections_Sort_usingCustomCompareFunction || !this.fields)
    return true;
  for (var /** @type {number} */ i = 0; i < this.fields.length; i++) {
    var /** @type {org.apache.royale.collections.ISortField} */ field = this.fields[i];
    if (field.name == property || field.usingCustomCompareFunction) {
      return true;
    }
  }
  return false;
};


/**
 *  @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 */
org.apache.royale.collections.Sort.prototype.reverse = function() {
  if (this.fields) {
    for (var /** @type {number} */ i = 0; i < this.fields.length; i++) {
      org.apache.royale.utils.Language.as(this.fields[i], org.apache.royale.collections.ISortField, true).reverse();
    }
  }
  this.org_apache_royale_collections_Sort_noFieldsDescending = !this.org_apache_royale_collections_Sort_noFieldsDescending;
};


/**
 *  @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Array} items
 */
org.apache.royale.collections.Sort.prototype.sort = function(items) {
  var self = this;
  if (!items || items.length <= 1) {
    return;
  }
  if (this.org_apache_royale_collections_Sort_usingCustomCompareFunction) {
    
/**
 * @const
 * @type {Function}
 */
var fixedCompareFunction = function(a, b) {
      return (self.compareFunction(a, b, self.org_apache_royale_collections_Sort__fields)) >> 0;
    };
    if (this.unique) {
      var /** @type {Object} */ uniqueRet1;
      
      uniqueRet1 = items.sort(fixedCompareFunction);
      if (uniqueRet1 == 0) {
        throw new Error("non-unique sort error");
      }
    } else {
      items.sort(fixedCompareFunction);
    }
  } else {
    if (this.fields && this.fields.length > 0) {
      var /** @type {Object} */ sortArgs = this.org_apache_royale_collections_Sort_initSortFields(items[0], true);
      if (this.unique) {
        var /** @type {Object} */ uniqueRet2;
        if (this.useSortOn && sortArgs && this.fields.length == 1) {
          uniqueRet2 = org.apache.royale.utils.Language.sortOn(items, sortArgs.fields[0], sortArgs.options[0] | 4);
        } else {
          
          uniqueRet2 = items.sort(org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_Sort_internalCompare, this, 'org_apache_royale_collections_Sort_internalCompare'));
        }
        if (uniqueRet2 == 0) {
          throw new Error("non-unique sort error");
        }
      } else {
        if (this.useSortOn && sortArgs) {
          org.apache.royale.utils.Language.sortOn(items, sortArgs.fields, sortArgs.options);
        } else {
          items.sort(org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_Sort_internalCompare, this, 'org_apache_royale_collections_Sort_internalCompare'));
        }
      }
    } else {
      items.sort(org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_Sort_internalCompare, this, 'org_apache_royale_collections_Sort_internalCompare'));
    }
  }
};


/**
 *  @asprivate
 *  Make sure all SortFields are ready to execute their comparators.
 * @private
 * @param {Object} item
 * @param {boolean=} buildArraySortArgs
 * @return {Object}
 */
org.apache.royale.collections.Sort.prototype.org_apache_royale_collections_Sort_initSortFields = function(item, buildArraySortArgs) {
  buildArraySortArgs = typeof buildArraySortArgs !== 'undefined' ? buildArraySortArgs : false;
  var /** @type {number} */ i = 0;
  var /** @type {Object} */ arraySortArgs = null;
  //var /** @type {number} */ i = 0;
  for (i = 0; i < this.fields.length; i++) {
    org.apache.royale.utils.Language.as(this.fields[i], org.apache.royale.collections.ISortField, true).initializeDefaultCompareFunction(item);
  }
  if (buildArraySortArgs) {
    arraySortArgs = {fields:[], options:[]};
    for (i = 0; i < this.fields.length; i++) {
      var /** @type {org.apache.royale.collections.ISortField} */ field = this.fields[i];
      var /** @type {number} */ options = field.arraySortOnOptions;
      if (options == -1) {
        return null;
      } else {
        arraySortArgs.fields.push(field.name);
        arraySortArgs.options.push(options);
      }
    }
  }
  return arraySortArgs;
};


/**
 *  @asprivate
 *  Compares the values specified based on the sort field options specified
 *  for this sort.  The fields parameter is really just used to get the
 *  number of fields to check.  We don't look at the actual values
 *  to see if they match the actual sort.
 * @private
 * @param {Object} a
 * @param {Object} b
 * @param {Array=} fields
 * @return {number}
 */
org.apache.royale.collections.Sort.prototype.org_apache_royale_collections_Sort_internalCompare = function(a, b, fields) {
  fields = typeof fields !== 'undefined' ? fields : null;
  var /** @type {number} */ result = 0;
  if (!this.org_apache_royale_collections_Sort__fields) {
    result = this.org_apache_royale_collections_Sort_noFieldsCompare(a, b);
  } else {
    var /** @type {number} */ i = 0;
    var /** @type {number} */ len = (fields ? fields.length : this.org_apache_royale_collections_Sort__fields.length) >> 0;
    while (result == 0 && (i < len)) {
      var /** @type {org.apache.royale.collections.ISortField} */ sf = org.apache.royale.utils.Language.as(this.org_apache_royale_collections_Sort__fields[i], org.apache.royale.collections.ISortField, true);
      result = (sf.compareFunction(a, b)) >> 0;
      if (sf.descending)
        result *= -1;
      i++;
    }
  }
  return result;
};


/**
 * @private
 * @type {org.apache.royale.collections.ISortField}
 */
org.apache.royale.collections.Sort.prototype.org_apache_royale_collections_Sort_defaultEmptyField;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.collections.Sort.prototype.org_apache_royale_collections_Sort_noFieldsDescending = false;


/**
 *  If the sort does not have any sort fields nor a custom comparator
 *  just use an empty SortField object and have it use its default
 *  logic.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @private
 * @param {Object} a
 * @param {Object} b
 * @param {Array=} fields
 * @return {number}
 */
org.apache.royale.collections.Sort.prototype.org_apache_royale_collections_Sort_noFieldsCompare = function(a, b, fields) {
  fields = typeof fields !== 'undefined' ? fields : null;
  if (!this.org_apache_royale_collections_Sort_defaultEmptyField) {
    this.org_apache_royale_collections_Sort_defaultEmptyField = this.createEmptySortField();
    try {
      this.org_apache_royale_collections_Sort_defaultEmptyField.initializeDefaultCompareFunction(a);
    } catch (e) {
      throw new Error("no comparator Sort error");
    }
  }
  var /** @type {number} */ result = (this.org_apache_royale_collections_Sort_defaultEmptyField.compareFunction(a, b)) >> 0;
  if (this.org_apache_royale_collections_Sort_noFieldsDescending) {
    result *= -1;
  }
  return result;
};


/**
 * @protected
 * @return {org.apache.royale.collections.ISortField}
 */
org.apache.royale.collections.Sort.prototype.createEmptySortField = function() {
  return new org.apache.royale.collections.SortField();
};


org.apache.royale.collections.Sort.prototype.get__useSortOn = function() {
  return this.org_apache_royale_collections_Sort__useSortOn;
};


org.apache.royale.collections.Sort.prototype.set__useSortOn = function(value) {
  this.org_apache_royale_collections_Sort__useSortOn = value;
};


org.apache.royale.collections.Sort.prototype.get__compareFunction = function() {
  return this.org_apache_royale_collections_Sort_usingCustomCompareFunction ? this.org_apache_royale_collections_Sort__compareFunction : org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_Sort_internalCompare, this, 'org_apache_royale_collections_Sort_internalCompare');
};


org.apache.royale.collections.Sort.prototype.set__compareFunction = function(value) {
  this.org_apache_royale_collections_Sort__compareFunction = value;
  this.org_apache_royale_collections_Sort_usingCustomCompareFunction = this.org_apache_royale_collections_Sort__compareFunction != null;
};


org.apache.royale.collections.Sort.prototype.get__fields = function() {
  return this.org_apache_royale_collections_Sort__fields;
};


org.apache.royale.collections.Sort.prototype.set__fields = function(value) {
  this.org_apache_royale_collections_Sort__fields = value;
  this.dispatchEvent(new org.apache.royale.events.Event("fieldsChanged"));
};


org.apache.royale.collections.Sort.prototype.get__unique = function() {
  return this.org_apache_royale_collections_Sort__unique;
};


org.apache.royale.collections.Sort.prototype.set__unique = function(value) {
  this.org_apache_royale_collections_Sort__unique = value;
};


Object.defineProperties(org.apache.royale.collections.Sort.prototype, /** @lends {org.apache.royale.collections.Sort.prototype} */ {
/**
  * @type {boolean} */
useSortOn: {
get: org.apache.royale.collections.Sort.prototype.get__useSortOn,
set: org.apache.royale.collections.Sort.prototype.set__useSortOn},
/**
  * @export
  * @type {Function} */
compareFunction: {
get: org.apache.royale.collections.Sort.prototype.get__compareFunction,
set: org.apache.royale.collections.Sort.prototype.set__compareFunction},
/**
  * @export
  * @type {Array} */
fields: {
get: org.apache.royale.collections.Sort.prototype.get__fields,
set: org.apache.royale.collections.Sort.prototype.set__fields},
/**
  * @export
  * @type {boolean} */
unique: {
get: org.apache.royale.collections.Sort.prototype.get__unique,
set: org.apache.royale.collections.Sort.prototype.set__unique}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.collections.Sort.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'Sort', qName: 'org.apache.royale.collections.Sort', kind: 'class' }], interfaces: [org.apache.royale.collections.ISort] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.collections.Sort.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'compareFunction': { type: 'Function', access: 'readwrite', declaredBy: 'org.apache.royale.collections.Sort'},
        'fields': { type: 'Array', access: 'readwrite', declaredBy: 'org.apache.royale.collections.Sort', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'fieldsChanged' } ] } ]; }},
        'unique': { type: 'Boolean', access: 'readwrite', declaredBy: 'org.apache.royale.collections.Sort'}
      };
    },
    methods: function () {
      return {
        'Sort': { type: '', declaredBy: 'org.apache.royale.collections.Sort', parameters: function () { return [ 'Array', true ,'Function', true ,'Boolean', true ]; }},
        'findItem': { type: 'int', declaredBy: 'org.apache.royale.collections.Sort', parameters: function () { return [ 'Array', false ,'Object', false ,'String', false ,'Boolean', true ,'Function', true ]; }},
        'propertyAffectsSort': { type: 'Boolean', declaredBy: 'org.apache.royale.collections.Sort', parameters: function () { return [ 'String', false ]; }},
        'reverse': { type: 'void', declaredBy: 'org.apache.royale.collections.Sort'},
        'sort': { type: 'void', declaredBy: 'org.apache.royale.collections.Sort', parameters: function () { return [ 'Array', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.collections.Sort.prototype.ROYALE_COMPILE_FLAGS = 10;