/**
 * Generated by Apache Royale Compiler from org/apache/royale/svg/Rect.as
 * org.apache.royale.svg.Rect
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.svg.Rect');

goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.html.util.createSVG');
goog.require('org.apache.royale.svg.GraphicShape');
goog.require('org.apache.royale.core.ITransformHost');
goog.require('org.apache.royale.graphics.IDrawable');
goog.require('org.apache.royale.graphics.IRect');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.7
 * @constructor
 * @extends {org.apache.royale.svg.GraphicShape}
 * @implements {org.apache.royale.graphics.IRect}
 * @implements {org.apache.royale.graphics.IDrawable}
 * @implements {org.apache.royale.core.ITransformHost}
 * @param {number=} x
 * @param {number=} y
 * @param {number=} width
 * @param {number=} height
 * @param {number=} rx
 * @param {number=} ry
 */
org.apache.royale.svg.Rect = function(x, y, width, height, rx, ry) {
  org.apache.royale.svg.Rect.base(this, 'constructor');
  x = typeof x !== 'undefined' ? x : 0;
  y = typeof y !== 'undefined' ? y : 0;
  width = typeof width !== 'undefined' ? width : 0;
  height = typeof height !== 'undefined' ? height : 0;
  rx = typeof rx !== 'undefined' ? rx : NaN;
  ry = typeof ry !== 'undefined' ? ry : NaN;
  this.x = x;
  this.y = y;
  this.width = width;
  this.height = height;
  this.rx = rx;
  this.ry = ry;
};
goog.inherits(org.apache.royale.svg.Rect, org.apache.royale.svg.GraphicShape);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.svg.Rect', org.apache.royale.svg.Rect);


/**
 * @private
 * @type {org.apache.royale.core.WrappedHTMLElement}
 */
org.apache.royale.svg.Rect.prototype.org_apache_royale_svg_Rect__rect;


/**
 * @private
 * @type {number}
 */
org.apache.royale.svg.Rect.prototype.org_apache_royale_svg_Rect__rx;


/**
 * @private
 * @type {number}
 */
org.apache.royale.svg.Rect.prototype.org_apache_royale_svg_Rect__ry;


/**
 *  Draw the rectangle.
 *  @asparam xp The x position of the top-left corner of the rectangle.
 *  @asparam yp The y position of the top-left corner.
 *  @asparam width The width of the rectangle.
 *  @asparam height The height of the rectangle.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @export
 * @param {number} xp
 * @param {number} yp
 * @param {number} width
 * @param {number} height
 */
org.apache.royale.svg.Rect.prototype.drawRect = function(xp, yp, width, height) {
  
  var /** @type {string} */ style = this.getStyleStr();
  if (this.org_apache_royale_svg_Rect__rect == null) {
    this.org_apache_royale_svg_Rect__rect = org.apache.royale.html.util.createSVG('rect');
    this.org_apache_royale_svg_Rect__rect.royale_wrapper = this;
    this.element.appendChild(this.org_apache_royale_svg_Rect__rect);
  }
  this.org_apache_royale_svg_Rect__rect.setAttribute('style', style);
  if (this.stroke) {
    this.org_apache_royale_svg_Rect__rect.setAttribute('x', this.stroke.weight / 2);
    this.org_apache_royale_svg_Rect__rect.setAttribute('y', this.stroke.weight / 2);
  } else {
    this.org_apache_royale_svg_Rect__rect.setAttribute('x', 0);
    this.org_apache_royale_svg_Rect__rect.setAttribute('y', 0);
  }
  if (width)
    this.org_apache_royale_svg_Rect__rect.setAttribute('width', width);
  if (height)
    this.org_apache_royale_svg_Rect__rect.setAttribute('height', height);
  if (!isNaN(this.org_apache_royale_svg_Rect__rx)) {
    this.org_apache_royale_svg_Rect__rect.setAttribute('rx', this.org_apache_royale_svg_Rect__rx);
  }
  if (!isNaN(this.org_apache_royale_svg_Rect__ry)) {
    this.org_apache_royale_svg_Rect__rect.setAttribute('ry', this.org_apache_royale_svg_Rect__ry);
  }
  this.resize(this.x, this.y);
};


/**
 * @protected
 * @override
 */
org.apache.royale.svg.Rect.prototype.drawImpl = function() {
  this.drawRect(0, 0, this.width, this.height);
};


/**
 * @export
 */
org.apache.royale.svg.Rect.prototype.draw = function() {
  this.drawImpl();
};


org.apache.royale.svg.Rect.prototype.get__rx = function() {
  return this.org_apache_royale_svg_Rect__rx;
};


org.apache.royale.svg.Rect.prototype.set__rx = function(value) {
  this.org_apache_royale_svg_Rect__rx = value;
  this.updateView();
};


org.apache.royale.svg.Rect.prototype.get__ry = function() {
  return this.org_apache_royale_svg_Rect__ry;
};


org.apache.royale.svg.Rect.prototype.set__ry = function(value) {
  this.org_apache_royale_svg_Rect__ry = value;
  this.updateView();
};


org.apache.royale.svg.Rect.prototype.get__transformElement = function() {
  return this.org_apache_royale_svg_Rect__rect;
};


Object.defineProperties(org.apache.royale.svg.Rect.prototype, /** @lends {org.apache.royale.svg.Rect.prototype} */ {
/**
  * @export
  * @type {number} */
rx: {
get: org.apache.royale.svg.Rect.prototype.get__rx,
set: org.apache.royale.svg.Rect.prototype.set__rx},
/**
  * @export
  * @type {number} */
ry: {
get: org.apache.royale.svg.Rect.prototype.get__ry,
set: org.apache.royale.svg.Rect.prototype.set__ry},
/**
  * @export
  * @type {org.apache.royale.core.WrappedHTMLElement} */
transformElement: {
get: org.apache.royale.svg.Rect.prototype.get__transformElement}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.svg.Rect.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'Rect', qName: 'org.apache.royale.svg.Rect', kind: 'class' }], interfaces: [org.apache.royale.graphics.IRect, org.apache.royale.graphics.IDrawable, org.apache.royale.core.ITransformHost] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.svg.Rect.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'rx': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.svg.Rect'},
        'ry': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.svg.Rect'},
        'transformElement': { type: 'org.apache.royale.core.WrappedHTMLElement', access: 'readonly', declaredBy: 'org.apache.royale.svg.Rect'}
      };
    },
    methods: function () {
      return {
        'Rect': { type: '', declaredBy: 'org.apache.royale.svg.Rect', parameters: function () { return [ 'Number', true ,'Number', true ,'Number', true ,'Number', true ,'Number', true ,'Number', true ]; }},
        'drawRect': { type: 'void', declaredBy: 'org.apache.royale.svg.Rect', parameters: function () { return [ 'Number', false ,'Number', false ,'Number', false ,'Number', false ]; }},
        'draw': { type: 'void', declaredBy: 'org.apache.royale.svg.Rect'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.svg.Rect.prototype.ROYALE_COMPILE_FLAGS = 10;