/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/models/RangeModel.as
 * org.apache.royale.html.beads.models.RangeModel
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.models.RangeModel');

goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.events.ValueChangeEvent');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.core.IRangeModel');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.core.IBead}
 * @implements {org.apache.royale.core.IRangeModel}
 */
org.apache.royale.html.beads.models.RangeModel = function() {
  org.apache.royale.html.beads.models.RangeModel.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.models.RangeModel, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.models.RangeModel', org.apache.royale.html.beads.models.RangeModel);


/**
 * @protected
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.models.RangeModel.prototype._strand;


/**
 * @private
 * @type {number}
 */
org.apache.royale.html.beads.models.RangeModel.prototype.org_apache_royale_html_beads_models_RangeModel__maximum = 100;


/**
 * @private
 * @type {number}
 */
org.apache.royale.html.beads.models.RangeModel.prototype.org_apache_royale_html_beads_models_RangeModel__minimum = 0;


/**
 * @private
 * @type {number}
 */
org.apache.royale.html.beads.models.RangeModel.prototype.org_apache_royale_html_beads_models_RangeModel__snapInterval = 1;


/**
 * @private
 * @type {number}
 */
org.apache.royale.html.beads.models.RangeModel.prototype.org_apache_royale_html_beads_models_RangeModel__decimals = 0;


/**
 * @private
 * @type {number}
 */
org.apache.royale.html.beads.models.RangeModel.prototype.org_apache_royale_html_beads_models_RangeModel__stepSize = 1;


/**
 * @private
 * @type {number}
 */
org.apache.royale.html.beads.models.RangeModel.prototype.org_apache_royale_html_beads_models_RangeModel__value = 0;


/**
 * @asprivate
 * @protected
 * @param {number} value
 * @return {number}
 */
org.apache.royale.html.beads.models.RangeModel.prototype.snap = function(value) {
  var /** @type {number} */ si = this.snapInterval;
  var /** @type {number} */ n = Math.round((value - this.minimum) / si) * si + this.minimum;
  if (this.org_apache_royale_html_beads_models_RangeModel__decimals)
    n = Number(n.toFixed(this.org_apache_royale_html_beads_models_RangeModel__decimals));
  if (value > 0) {
    if (value - n < n + si - value)
      return n;
    return n + si;
  }
  if (value - n > n + si - value)
    return n + si;
  return n;
};


org.apache.royale.html.beads.models.RangeModel.prototype.set__strand = function(value) {
  this._strand = value;
};


org.apache.royale.html.beads.models.RangeModel.prototype.get__maximum = function() {
  return this.org_apache_royale_html_beads_models_RangeModel__maximum;
};


org.apache.royale.html.beads.models.RangeModel.prototype.set__maximum = function(value) {
  if (value != this.org_apache_royale_html_beads_models_RangeModel__maximum) {
    this.org_apache_royale_html_beads_models_RangeModel__maximum = value;
    if (this.org_apache_royale_html_beads_models_RangeModel__value > this.org_apache_royale_html_beads_models_RangeModel__maximum)
      this.org_apache_royale_html_beads_models_RangeModel__value = this.org_apache_royale_html_beads_models_RangeModel__maximum;
    this.dispatchEvent(new org.apache.royale.events.Event("maximumChange"));
  }
};


org.apache.royale.html.beads.models.RangeModel.prototype.get__minimum = function() {
  return this.org_apache_royale_html_beads_models_RangeModel__minimum;
};


org.apache.royale.html.beads.models.RangeModel.prototype.set__minimum = function(value) {
  if (value != this.org_apache_royale_html_beads_models_RangeModel__minimum) {
    this.org_apache_royale_html_beads_models_RangeModel__minimum = value;
    if (this.org_apache_royale_html_beads_models_RangeModel__value < this.org_apache_royale_html_beads_models_RangeModel__minimum)
      this.org_apache_royale_html_beads_models_RangeModel__value = this.org_apache_royale_html_beads_models_RangeModel__minimum;
    this.dispatchEvent(new org.apache.royale.events.Event("minimumChange"));
  }
};


org.apache.royale.html.beads.models.RangeModel.prototype.get__snapInterval = function() {
  return this.org_apache_royale_html_beads_models_RangeModel__snapInterval;
};


org.apache.royale.html.beads.models.RangeModel.prototype.set__snapInterval = function(value) {
  if (value != this.org_apache_royale_html_beads_models_RangeModel__snapInterval) {
    this.org_apache_royale_html_beads_models_RangeModel__snapInterval = value;
    this.dispatchEvent(new org.apache.royale.events.Event("snapIntervalChange"));
  }
  if (("" + value).indexOf(".") == -1) {
    this.org_apache_royale_html_beads_models_RangeModel__decimals = 0;
  } else {
    var /** @type {string} */ str = "" + value;
    this.org_apache_royale_html_beads_models_RangeModel__decimals = (str.substr(str.indexOf(".") + 1).length) >> 0;
  }
};


org.apache.royale.html.beads.models.RangeModel.prototype.get__stepSize = function() {
  return this.org_apache_royale_html_beads_models_RangeModel__stepSize;
};


org.apache.royale.html.beads.models.RangeModel.prototype.set__stepSize = function(value) {
  if (value != this.org_apache_royale_html_beads_models_RangeModel__stepSize) {
    this.org_apache_royale_html_beads_models_RangeModel__stepSize = value;
    this.dispatchEvent(new org.apache.royale.events.Event("stepSizeChange"));
  }
};


org.apache.royale.html.beads.models.RangeModel.prototype.get__value = function() {
  return this.org_apache_royale_html_beads_models_RangeModel__value;
};


org.apache.royale.html.beads.models.RangeModel.prototype.set__value = function(newValue) {
  if (newValue != this.org_apache_royale_html_beads_models_RangeModel__value) {
    newValue = Math.max(this.minimum, newValue);
    newValue = Math.min(this.maximum, newValue);
    var /** @type {number} */ oldValue = this.org_apache_royale_html_beads_models_RangeModel__value;
    this.org_apache_royale_html_beads_models_RangeModel__value = this.snap(newValue);
    this.dispatchEvent(org.apache.royale.events.ValueChangeEvent.createUpdateEvent(this._strand, "value", oldValue, this.org_apache_royale_html_beads_models_RangeModel__value));
  }
};


Object.defineProperties(org.apache.royale.html.beads.models.RangeModel.prototype, /** @lends {org.apache.royale.html.beads.models.RangeModel.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.models.RangeModel.prototype.set__strand},
/**
  * @export
  * @type {number} */
maximum: {
get: org.apache.royale.html.beads.models.RangeModel.prototype.get__maximum,
set: org.apache.royale.html.beads.models.RangeModel.prototype.set__maximum},
/**
  * @export
  * @type {number} */
minimum: {
get: org.apache.royale.html.beads.models.RangeModel.prototype.get__minimum,
set: org.apache.royale.html.beads.models.RangeModel.prototype.set__minimum},
/**
  * @export
  * @type {number} */
snapInterval: {
get: org.apache.royale.html.beads.models.RangeModel.prototype.get__snapInterval,
set: org.apache.royale.html.beads.models.RangeModel.prototype.set__snapInterval},
/**
  * @export
  * @type {number} */
stepSize: {
get: org.apache.royale.html.beads.models.RangeModel.prototype.get__stepSize,
set: org.apache.royale.html.beads.models.RangeModel.prototype.set__stepSize},
/**
  * @export
  * @type {number} */
value: {
get: org.apache.royale.html.beads.models.RangeModel.prototype.get__value,
set: org.apache.royale.html.beads.models.RangeModel.prototype.set__value}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.models.RangeModel.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'RangeModel', qName: 'org.apache.royale.html.beads.models.RangeModel', kind: 'class' }], interfaces: [org.apache.royale.core.IBead, org.apache.royale.core.IRangeModel] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.models.RangeModel.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.models.RangeModel'},
        'maximum': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.html.beads.models.RangeModel'},
        'minimum': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.html.beads.models.RangeModel'},
        'snapInterval': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.html.beads.models.RangeModel'},
        'stepSize': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.html.beads.models.RangeModel'},
        'value': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.html.beads.models.RangeModel'}
      };
    },
    methods: function () {
      return {
        'RangeModel': { type: '', declaredBy: 'org.apache.royale.html.beads.models.RangeModel'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.models.RangeModel.prototype.ROYALE_COMPILE_FLAGS = 10;