/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/layouts/VirtualListVerticalLayout.as
 * org.apache.royale.html.beads.layouts.VirtualListVerticalLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.layouts.VirtualListVerticalLayout');

goog.require('org.apache.royale.core.IDataProviderModel');
goog.require('org.apache.royale.core.IDataProviderVirtualItemRendererMapper');
goog.require('org.apache.royale.core.IIndexedItemRenderer');
goog.require('org.apache.royale.core.ILayoutView');
goog.require('org.apache.royale.core.IListPresentationModel');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IStrandWithPresentationModel');
goog.require('org.apache.royale.core.LayoutBase');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.core.IBeadLayout');
goog.require('org.apache.royale.utils.Language');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion HTMLDivElement
 * @constructor
 * @extends {org.apache.royale.core.LayoutBase}
 * @implements {org.apache.royale.core.IBeadLayout}
 */
org.apache.royale.html.beads.layouts.VirtualListVerticalLayout = function() {
  
  this.visibleIndexes = [];
  org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.layouts.VirtualListVerticalLayout, org.apache.royale.core.LayoutBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.layouts.VirtualListVerticalLayout', org.apache.royale.html.beads.layouts.VirtualListVerticalLayout);


/**
 * @protected
 * @type {org.apache.royale.core.IDataProviderModel}
 */
org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.dataProviderModel;


/**
 * @protected
 * @type {HTMLDivElement}
 */
org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.topSpacer;


/**
 * @protected
 * @type {HTMLDivElement}
 */
org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.bottomSpacer;


/**
 * @protected
 * @type {Array}
 */
org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.visibleIndexes;


/**
 * @protected
 * @param {org.apache.royale.events.Event} e
 */
org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.scrollHandler = function(e) {
  this.layout();
};


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.org_apache_royale_html_beads_layouts_VirtualListVerticalLayout_inLayout;


/**
 *  Layout children vertically
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion Array
 *  @royaleignorecoercion org.apache.royale.core.ILayoutHost
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 *  @royaleignorecoercion org.apache.royale.core.IListPresentationModel
 *  @royaleignorecoercion org.apache.royale.core.IStrandWithPresentationModel
 * @export
 * @override
 */
org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.layout = function() {
  var /** @type {number} */ firstIndex = 0;
  var /** @type {number} */ freeIndex = 0;
  var /** @type {number} */ lastIndex = 0;
  if (this.org_apache_royale_html_beads_layouts_VirtualListVerticalLayout_inLayout)
    return true;
  this.org_apache_royale_html_beads_layouts_VirtualListVerticalLayout_inLayout = true;
  
  var /** @type {org.apache.royale.core.ILayoutView} */ contentView = this.layoutView;
  var /** @type {Array} */ dp = this.dataProviderModel.dataProvider;
  if (!dp) {
    this.org_apache_royale_html_beads_layouts_VirtualListVerticalLayout_inLayout = false;
    return true;
  }
  var /** @type {Object} */ presentationModel = this.host.presentationModel;
  var /** @type {number} */ totalHeight = presentationModel.rowHeight * dp.length;
  var /** @type {number} */ viewportTop = Math.max(contentView.element.scrollTop, 0);
  var /** @type {number} */ viewportHeight = contentView.element.clientHeight;
  var /** @type {number} */ startIndex = (Math.floor(viewportTop / presentationModel.rowHeight)) >> 0;
  var /** @type {org.apache.royale.core.IDataProviderVirtualItemRendererMapper} */ factory = org.apache.royale.utils.Language.as(this.host.getBeadByType(org.apache.royale.core.IDataProviderVirtualItemRendererMapper), org.apache.royale.core.IDataProviderVirtualItemRendererMapper);
  var /** @type {number} */ endIndex = (Math.ceil((viewportTop + viewportHeight) / presentationModel.rowHeight)) >> 0;
  //var /** @type {number} */ freeIndex = 0;
  //var /** @type {number} */ firstIndex = 0;
  //var /** @type {number} */ lastIndex = 0;
  if (!this.topSpacer) {
    this.topSpacer = org.apache.royale.utils.Language.as(document.createElement("div"), HTMLDivElement);
    contentView.element.appendChild(this.topSpacer);
  }
  this.topSpacer.style.height = (startIndex * presentationModel.rowHeight).toString() + "px";
  if (this.visibleIndexes.length) {
    if (startIndex < this.visibleIndexes[0]) {
      freeIndex = (this.visibleIndexes.pop()) >> 0;
      while (freeIndex > endIndex) {
        factory.freeItemRendererForIndex(freeIndex);
        if (this.visibleIndexes.length == 0)
          break;
        freeIndex = (this.visibleIndexes.pop()) >> 0;
      }
      if (freeIndex == endIndex)
        this.visibleIndexes.push(freeIndex);
      if (this.visibleIndexes.length) {
        endIndex = (this.visibleIndexes[this.visibleIndexes.length - 1]) >> 0;
      }
    } else if (startIndex > this.visibleIndexes[0]) {
      freeIndex = (this.visibleIndexes.shift()) >> 0;
      while (freeIndex < startIndex) {
        factory.freeItemRendererForIndex(freeIndex);
        if (this.visibleIndexes.length == 0)
          break;
        freeIndex = (this.visibleIndexes.shift()) >> 0;
      }
    } else {
      lastIndex = (this.visibleIndexes[this.visibleIndexes.length - 1]) >> 0;
      if (lastIndex > endIndex) {
        freeIndex = (this.visibleIndexes.pop()) >> 0;
        while (freeIndex > endIndex) {
          factory.freeItemRendererForIndex(freeIndex);
          if (this.visibleIndexes.length == 0)
            break;
          freeIndex = (this.visibleIndexes.pop()) >> 0;
        }
        this.org_apache_royale_html_beads_layouts_VirtualListVerticalLayout_inLayout = false;
        return true;
      }
    }
    firstIndex = (this.visibleIndexes[0]) >> 0;
    lastIndex = (this.visibleIndexes[this.visibleIndexes.length - 1]) >> 0;
  } else {
    firstIndex = (dp.length) >> 0;
    lastIndex = 0;
  }
  for (var /** @type {number} */ i = startIndex; i < endIndex; i++) {
    if (i >= dp.length)
      continue;
    var /** @type {org.apache.royale.core.IIndexedItemRenderer} */ ir;
    if (i < firstIndex) {
      ir = factory.getItemRendererForIndex(i, (i - startIndex + 1) >> 0);
      ir.element.style.display = "block";
      this.visibleIndexes.push(i);
    } else if (i > lastIndex) {
      ir = factory.getItemRendererForIndex(i, (i - startIndex + 1) >> 0);
      ir.element.style.display = "block";
      this.visibleIndexes.push(i);
    }
  }
  this.visibleIndexes = this.visibleIndexes.sort(org.apache.royale.utils.Language.closure(this.numberSort, this, 'numberSort'));
  if (!this.bottomSpacer) {
    this.bottomSpacer = org.apache.royale.utils.Language.as(document.createElement("div"), HTMLDivElement);
    contentView.element.appendChild(this.bottomSpacer);
  } else {
    contentView.element.removeChild(this.bottomSpacer);
    contentView.element.appendChild(this.bottomSpacer);
  }
  var /** @type {number} */ numBottomRows = (dp.length - endIndex) >> 0;
  this.bottomSpacer.style.height = (numBottomRows > 0) ? (numBottomRows * presentationModel.rowHeight).toString() + "px" : "0px";
  this.org_apache_royale_html_beads_layouts_VirtualListVerticalLayout_inLayout = false;
  return true;
};


/**
 * @export
 * @param {number} a
 * @param {number} b
 * @return {number}
 */
org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.numberSort = function(a, b) {
  return (a - b) >> 0;
};


org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.set__strand = function(value) {
  org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.superClass_.set__strand.apply(this, [ value] );
  this.dataProviderModel = org.apache.royale.utils.Language.as(this.host.getBeadByType(org.apache.royale.core.IDataProviderModel), org.apache.royale.core.IDataProviderModel);
  this.host.element.addEventListener("scroll", org.apache.royale.utils.Language.closure(this.scrollHandler, this, 'scrollHandler'));
};


Object.defineProperties(org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype, /** @lends {org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'VirtualListVerticalLayout', qName: 'org.apache.royale.html.beads.layouts.VirtualListVerticalLayout', kind: 'class' }], interfaces: [org.apache.royale.core.IBeadLayout] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.layouts.VirtualListVerticalLayout'}
      };
    },
    methods: function () {
      return {
        'VirtualListVerticalLayout': { type: '', declaredBy: 'org.apache.royale.html.beads.layouts.VirtualListVerticalLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.royale.html.beads.layouts.VirtualListVerticalLayout'},
        'numberSort': { type: 'int', declaredBy: 'org.apache.royale.html.beads.layouts.VirtualListVerticalLayout', parameters: function () { return [ 'int', false ,'int', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.layouts.VirtualListVerticalLayout.prototype.ROYALE_COMPILE_FLAGS = 10;