/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/layouts/VerticalSliderLayout.as
 * org.apache.royale.html.beads.layouts.VerticalSliderLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.layouts.VerticalSliderLayout');

goog.require('org.apache.royale.core.IRangeModel');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.html.beads.ISliderView');
goog.require('org.apache.royale.core.IBeadLayout');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @constructor
 * @implements {org.apache.royale.core.IBeadLayout}
 */
org.apache.royale.html.beads.layouts.VerticalSliderLayout = function() {
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.layouts.VerticalSliderLayout', org.apache.royale.html.beads.layouts.VerticalSliderLayout);


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.layouts.VerticalSliderLayout.prototype.org_apache_royale_html_beads_layouts_VerticalSliderLayout__strand;


/**
 * @asprivate
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.layouts.VerticalSliderLayout.prototype.org_apache_royale_html_beads_layouts_VerticalSliderLayout_performLayout = function(event) {
  this.layout();
};


/**
 * Performs the layout (size and positioning) of the Slide elements.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @export
 * @return {boolean}
 */
org.apache.royale.html.beads.layouts.VerticalSliderLayout.prototype.layout = function() {
  var /** @type {org.apache.royale.html.beads.ISliderView} */ viewBead = org.apache.royale.utils.Language.as(this.host.view, org.apache.royale.html.beads.ISliderView);
  if (viewBead == null) {
    return false;
  }
  var /** @type {number} */ useWidth = this.host.width;
  if (isNaN(useWidth)) {
    useWidth = 25;
  }
  var /** @type {number} */ useHeight = this.host.height;
  if (isNaN(useHeight)) {
    useHeight = 100;
  }
  var /** @type {number} */ square = Math.min(useWidth, useHeight);
  var /** @type {number} */ trackWidth = useWidth / 3;
  var /** @type {org.apache.royale.core.IUIBase} */ thumb = org.apache.royale.utils.Language.as(viewBead.thumb, org.apache.royale.core.IUIBase);
  thumb.width = square;
  thumb.height = square;
  var /** @type {org.apache.royale.core.IUIBase} */ track = org.apache.royale.utils.Language.as(viewBead.track, org.apache.royale.core.IUIBase);
  track.y = square / 2;
  track.x = trackWidth;
  track.height = useHeight - square;
  track.width = trackWidth;
  var /** @type {org.apache.royale.core.IRangeModel} */ model = org.apache.royale.utils.Language.as(this.host.model, org.apache.royale.core.IRangeModel);
  var /** @type {number} */ value = model.value;
  if (value < model.minimum)
    value = model.minimum;
  if (value > model.maximum)
    value = model.maximum;
  var /** @type {number} */ p = (value - model.minimum) / (model.maximum - model.minimum);
  var /** @type {number} */ yloc = p * (useHeight - square);
  thumb.y = yloc;
  thumb.x = 0;
  return true;
};


org.apache.royale.html.beads.layouts.VerticalSliderLayout.prototype.set__strand = function(value) {
  this.org_apache_royale_html_beads_layouts_VerticalSliderLayout__strand = value;
  this.host.addEventListener("layoutNeeded", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_VerticalSliderLayout_performLayout, this, 'org_apache_royale_html_beads_layouts_VerticalSliderLayout_performLayout'));
  this.host.addEventListener("widthChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_VerticalSliderLayout_performLayout, this, 'org_apache_royale_html_beads_layouts_VerticalSliderLayout_performLayout'));
  this.host.addEventListener("heightChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_VerticalSliderLayout_performLayout, this, 'org_apache_royale_html_beads_layouts_VerticalSliderLayout_performLayout'));
};


org.apache.royale.html.beads.layouts.VerticalSliderLayout.prototype.get__host = function() {
  return org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_layouts_VerticalSliderLayout__strand, org.apache.royale.core.UIBase);
};


Object.defineProperties(org.apache.royale.html.beads.layouts.VerticalSliderLayout.prototype, /** @lends {org.apache.royale.html.beads.layouts.VerticalSliderLayout.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.layouts.VerticalSliderLayout.prototype.set__strand},
/**
  * @export
  * @type {org.apache.royale.core.UIBase} */
host: {
get: org.apache.royale.html.beads.layouts.VerticalSliderLayout.prototype.get__host}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.layouts.VerticalSliderLayout.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'VerticalSliderLayout', qName: 'org.apache.royale.html.beads.layouts.VerticalSliderLayout', kind: 'class' }], interfaces: [org.apache.royale.core.IBeadLayout] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.layouts.VerticalSliderLayout.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.layouts.VerticalSliderLayout'},
        'host': { type: 'org.apache.royale.core.UIBase', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.layouts.VerticalSliderLayout'}
      };
    },
    methods: function () {
      return {
        'VerticalSliderLayout': { type: '', declaredBy: 'org.apache.royale.html.beads.layouts.VerticalSliderLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.royale.html.beads.layouts.VerticalSliderLayout'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.layouts.VerticalSliderLayout.prototype.ROYALE_COMPILE_FLAGS = 10;