/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/layouts/TreeGridLayout.as
 * org.apache.royale.html.beads.layouts.TreeGridLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.layouts.TreeGridLayout');

goog.require('org.apache.royale.core.IBorderPaddingMarginValuesImpl');
goog.require('org.apache.royale.core.IRenderedObject');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.core.ValuesManager');
goog.require('org.apache.royale.core.layout.EdgeData');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.html.ButtonBar');
goog.require('org.apache.royale.html.beads.TreeGridView');
goog.require('org.apache.royale.html.beads.models.ButtonBarModel');
goog.require('org.apache.royale.html.beads.models.TreeGridModel');
goog.require('org.apache.royale.html.supportClasses.IDataGridColumn');
goog.require('org.apache.royale.core.IBeadLayout');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @constructor
 * @implements {org.apache.royale.core.IBeadLayout}
 */
org.apache.royale.html.beads.layouts.TreeGridLayout = function() {
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.layouts.TreeGridLayout', org.apache.royale.html.beads.layouts.TreeGridLayout);


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.org_apache_royale_html_beads_layouts_TreeGridLayout__strand;


/**
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.org_apache_royale_html_beads_layouts_TreeGridLayout_handleSizeChanges = function(event) {
  this.layout();
};


/**
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.org_apache_royale_html_beads_layouts_TreeGridLayout_handleLayoutNeeded = function(event) {
  this.layout();
};


/**
 * Performs the layout function, placing the ButtonBar header at the top
 * and spread across the width and the columns below that, laid out horizontally.
 * The size of the columns is taken from the TreeGridColumn definitions stored
 * in the TreeGridModel.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 *  @royaleignorecoercion org.apache.royale.core.IBorderPaddingMarginValuesImpl
 *  @royaleignorecoercion org.apache.royale.core.IUIBase
 *  @royaleignorecoercion org.apache.royale.core.IRenderedObject
 * @export
 * @return {boolean}
 */
org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.layout = function() {
  var /** @type {Object} */ renderedObject = this.org_apache_royale_html_beads_layouts_TreeGridLayout_host;
  if (!renderedObject.element.style.position || renderedObject.element.style.position == 'static') {
    renderedObject.element.style.position = 'relative';
  }
  var /** @type {org.apache.royale.html.beads.models.TreeGridModel} */ model = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_layouts_TreeGridLayout_uiHost.model, org.apache.royale.html.beads.models.TreeGridModel);
  var /** @type {org.apache.royale.html.ButtonBar} */ header = org.apache.royale.utils.Language.as(org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_layouts_TreeGridLayout_uiHost.view, org.apache.royale.html.beads.TreeGridView).header, org.apache.royale.html.ButtonBar);
  var /** @type {org.apache.royale.core.UIBase} */ contentArea = org.apache.royale.utils.Language.as(org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_layouts_TreeGridLayout_uiHost.view, org.apache.royale.html.beads.TreeGridView).listArea, org.apache.royale.core.UIBase);
  var /** @type {Array} */ displayedColumns = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_layouts_TreeGridLayout_uiHost.view, org.apache.royale.html.beads.TreeGridView).columnLists;
  var /** @type {org.apache.royale.core.layout.EdgeData} */ borderMetrics = org.apache.royale.core.ValuesManager["valuesImpl"].getBorderMetrics(this.org_apache_royale_html_beads_layouts_TreeGridLayout__strand);
  var /** @type {number} */ useWidth = this.org_apache_royale_html_beads_layouts_TreeGridLayout_uiHost.width - (borderMetrics.left + borderMetrics.right);
  var /** @type {number} */ useHeight = this.org_apache_royale_html_beads_layouts_TreeGridLayout_uiHost.height - (borderMetrics.top + borderMetrics.bottom);
  header.x = borderMetrics.left;
  header.y = borderMetrics.top;
  
  org.apache.royale.utils.Language.as(header, org.apache.royale.core.UIBase).percentWidth = 100;
  var /** @type {number} */ xpos = 0;
  var /** @type {number} */ defaultColumnWidth = useWidth / model.columns.length;
  var /** @type {Array} */ columnWidths = [];
  contentArea.element.style["position"] = "absolute";
  for (var /** @type {number} */ i = 0; i < displayedColumns.length; i++) {
    var /** @type {org.apache.royale.html.supportClasses.IDataGridColumn} */ columnDef = org.apache.royale.utils.Language.as(model.columns[i], org.apache.royale.html.supportClasses.IDataGridColumn);
    var /** @type {org.apache.royale.core.UIBase} */ columnList = org.apache.royale.utils.Language.as(displayedColumns[i], org.apache.royale.core.UIBase);
    columnList.x = xpos;
    columnList.y = 0;
    var /** @type {number} */ columnWidth = defaultColumnWidth;
    if (!isNaN(columnDef.columnWidth)) {
      columnWidth = (columnDef.columnWidth / this.org_apache_royale_html_beads_layouts_TreeGridLayout_uiHost.width) * useWidth;
    }
    columnList.width = columnWidth;
    columnWidths.push(columnWidth);
    xpos += columnList.width;
  }
  var /** @type {org.apache.royale.html.beads.models.ButtonBarModel} */ bbmodel = org.apache.royale.utils.Language.as(header.getBeadByType(org.apache.royale.html.beads.models.ButtonBarModel), org.apache.royale.html.beads.models.ButtonBarModel);
  bbmodel.buttonWidths = columnWidths;
  header.dispatchEvent(new org.apache.royale.events.Event("layoutNeeded"));
  contentArea.x = borderMetrics.left;
  contentArea.y = header.height + header.y;
  
  org.apache.royale.utils.Language.as(contentArea, org.apache.royale.core.UIBase).percentWidth = 100;
  contentArea.height = useHeight - header.height;
  return true;
};


org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.set__strand = function(value) {
  this.org_apache_royale_html_beads_layouts_TreeGridLayout__strand = value;
  org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_layouts_TreeGridLayout__strand, org.apache.royale.events.IEventDispatcher).addEventListener("widthChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_TreeGridLayout_handleSizeChanges, this, 'org_apache_royale_html_beads_layouts_TreeGridLayout_handleSizeChanges'));
  org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_layouts_TreeGridLayout__strand, org.apache.royale.events.IEventDispatcher).addEventListener("heightChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_TreeGridLayout_handleSizeChanges, this, 'org_apache_royale_html_beads_layouts_TreeGridLayout_handleSizeChanges'));
  org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_layouts_TreeGridLayout__strand, org.apache.royale.events.IEventDispatcher).addEventListener("sizeChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_TreeGridLayout_handleSizeChanges, this, 'org_apache_royale_html_beads_layouts_TreeGridLayout_handleSizeChanges'));
  org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_layouts_TreeGridLayout__strand, org.apache.royale.events.IEventDispatcher).addEventListener("layoutNeeded", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_layouts_TreeGridLayout_handleLayoutNeeded, this, 'org_apache_royale_html_beads_layouts_TreeGridLayout_handleLayoutNeeded'));
};


org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.get__org_apache_royale_html_beads_layouts_TreeGridLayout_host = function() {
  return org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_layouts_TreeGridLayout__strand, org.apache.royale.core.IUIBase);
};


org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.get__org_apache_royale_html_beads_layouts_TreeGridLayout_uiHost = function() {
  return org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_layouts_TreeGridLayout__strand, org.apache.royale.core.UIBase);
};


Object.defineProperties(org.apache.royale.html.beads.layouts.TreeGridLayout.prototype, /** @lends {org.apache.royale.html.beads.layouts.TreeGridLayout.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.set__strand},
/**
  * @type {org.apache.royale.core.IUIBase} */
org_apache_royale_html_beads_layouts_TreeGridLayout_host: {
get: org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.get__org_apache_royale_html_beads_layouts_TreeGridLayout_host},
/**
  * @type {org.apache.royale.core.UIBase} */
org_apache_royale_html_beads_layouts_TreeGridLayout_uiHost: {
get: org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.get__org_apache_royale_html_beads_layouts_TreeGridLayout_uiHost}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'TreeGridLayout', qName: 'org.apache.royale.html.beads.layouts.TreeGridLayout', kind: 'class' }], interfaces: [org.apache.royale.core.IBeadLayout] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.layouts.TreeGridLayout'}
      };
    },
    methods: function () {
      return {
        'TreeGridLayout': { type: '', declaredBy: 'org.apache.royale.html.beads.layouts.TreeGridLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.royale.html.beads.layouts.TreeGridLayout'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.layouts.TreeGridLayout.prototype.ROYALE_COMPILE_FLAGS = 10;