/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/NumericStepperView.as
 * org.apache.royale.html.beads.NumericStepperView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.NumericStepperView');

goog.require('org.apache.royale.core.BeadViewBase');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.core.IParent');
goog.require('org.apache.royale.core.IParentIUIBase');
goog.require('org.apache.royale.core.IRangeModel');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.events.ValueChangeEvent');
goog.require('org.apache.royale.html.Label');
goog.require('org.apache.royale.html.Spinner');
goog.require('org.apache.royale.html.TextInput');
goog.require('org.apache.royale.utils.sendStrandEvent');
goog.require('org.apache.royale.core.IBeadView');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @constructor
 * @extends {org.apache.royale.core.BeadViewBase}
 * @implements {org.apache.royale.core.IBeadView}
 */
org.apache.royale.html.beads.NumericStepperView = function() {
  org.apache.royale.html.beads.NumericStepperView.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.NumericStepperView, org.apache.royale.core.BeadViewBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.NumericStepperView', org.apache.royale.html.beads.NumericStepperView);


/**
 * @protected
 * @type {org.apache.royale.html.Label}
 */
org.apache.royale.html.beads.NumericStepperView.prototype.label;


/**
 * @protected
 * @type {org.apache.royale.html.TextInput}
 */
org.apache.royale.html.beads.NumericStepperView.prototype.input;


/**
 * @protected
 * @type {org.apache.royale.html.Spinner}
 */
org.apache.royale.html.beads.NumericStepperView.prototype.spinner;


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.UIBase
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.NumericStepperView.prototype.org_apache_royale_html_beads_NumericStepperView_sizeChangeHandler = function(event) {
  var /** @type {boolean} */ widthToContent = (event == null) && this._strand.isWidthSizedToContent();
  var /** @type {number} */ inputWidth = this.input.width;
  var /** @type {number} */ inputHeight = this.input.height;
  var /** @type {number} */ strandWidth;
  if (!widthToContent) {
    strandWidth = this._strand.width;
  }
  this.spinner.height = inputHeight;
  this.spinner.width = inputHeight / 2;
  this.input.x = 0;
  this.input.y = 0;
  if (!widthToContent)
    this.input.width = strandWidth - this.spinner.width - 2;
  
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @private
 * @param {org.apache.royale.events.ValueChangeEvent} event
 */
org.apache.royale.html.beads.NumericStepperView.prototype.org_apache_royale_html_beads_NumericStepperView_spinnerValueChanged = function(event) {
  this.input.text = "" + this.spinner.value;
  var /** @type {org.apache.royale.events.ValueChangeEvent} */ newEvent = org.apache.royale.events.ValueChangeEvent.createUpdateEvent(this._strand, "value", event.oldValue, event.newValue);
  org.apache.royale.utils.sendStrandEvent(this._strand, newEvent);
};


/**
 * @asprivate
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.NumericStepperView.prototype.org_apache_royale_html_beads_NumericStepperView_inputChangeHandler = function(event) {
  var /** @type {number} */ newValue = Number(this.input.text);
  if (!isNaN(newValue)) {
    this.spinner.value = newValue;
  } else {
    this.input.text = String(this.spinner.value);
  }
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.UIBase
 * @royaleignorecoercion org.apache.royale.core.IRangeModel
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.NumericStepperView.prototype.org_apache_royale_html_beads_NumericStepperView_modelChangeHandler = function(event) {
  var /** @type {number} */ n = this._strand.model.value;
  this.input.text = String(this._strand.model.value);
};


org.apache.royale.html.beads.NumericStepperView.prototype.set__strand = function(value) {
  org.apache.royale.html.beads.NumericStepperView.superClass_.set__strand.apply(this, [ value] );
  this.input = new org.apache.royale.html.TextInput();
  this.input.className = "NumericStepperInput";
  this.input.typeNames = "NumericStepperInput";
  value.addElement(this.input);
  this.input.positioner.style.display = 'inline-block';
  this.input.positioner.style.width = '100px';
  this.spinner = new org.apache.royale.html.Spinner();
  this.spinner.addBead(value.model);
  value.addElement(this.spinner);
  
  this.spinner.positioner.style.display = 'inline-block';
  this.spinner.positioner.style.position = '';
  this.input.addEventListener("change", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_NumericStepperView_inputChangeHandler, this, 'org_apache_royale_html_beads_NumericStepperView_inputChangeHandler'));
  this.spinner.addEventListener("valueChange", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_NumericStepperView_spinnerValueChanged, this, 'org_apache_royale_html_beads_NumericStepperView_spinnerValueChanged'));
  this.listenOnStrand("widthChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_NumericStepperView_sizeChangeHandler, this, 'org_apache_royale_html_beads_NumericStepperView_sizeChangeHandler'));
  this.listenOnStrand("heightChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_NumericStepperView_sizeChangeHandler, this, 'org_apache_royale_html_beads_NumericStepperView_sizeChangeHandler'));
  this.listenOnStrand("sizeChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_NumericStepperView_sizeChangeHandler, this, 'org_apache_royale_html_beads_NumericStepperView_sizeChangeHandler'));
  value.model.addEventListener("valueChange", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_NumericStepperView_modelChangeHandler, this, 'org_apache_royale_html_beads_NumericStepperView_modelChangeHandler'));
  value.model.addEventListener("minimumChange", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_NumericStepperView_modelChangeHandler, this, 'org_apache_royale_html_beads_NumericStepperView_modelChangeHandler'));
  value.model.addEventListener("maximumChange", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_NumericStepperView_modelChangeHandler, this, 'org_apache_royale_html_beads_NumericStepperView_modelChangeHandler'));
  value.model.addEventListener("stepSizeChange", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_NumericStepperView_modelChangeHandler, this, 'org_apache_royale_html_beads_NumericStepperView_modelChangeHandler'));
  value.model.addEventListener("snapIntervalChange", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_NumericStepperView_modelChangeHandler, this, 'org_apache_royale_html_beads_NumericStepperView_modelChangeHandler'));
  this.input.text = String(this.spinner.value);
  
  this.org_apache_royale_html_beads_NumericStepperView_sizeChangeHandler(null);
};


org.apache.royale.html.beads.NumericStepperView.prototype.get__contentView = function() {
  return this._strand;
};


org.apache.royale.html.beads.NumericStepperView.prototype.get__resizableView = function() {
  return this._strand;
};


Object.defineProperties(org.apache.royale.html.beads.NumericStepperView.prototype, /** @lends {org.apache.royale.html.beads.NumericStepperView.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.NumericStepperView.prototype.set__strand},
/**
  * @export
  * @type {org.apache.royale.core.IParentIUIBase} */
contentView: {
get: org.apache.royale.html.beads.NumericStepperView.prototype.get__contentView},
/**
  * @export
  * @type {org.apache.royale.core.IUIBase} */
resizableView: {
get: org.apache.royale.html.beads.NumericStepperView.prototype.get__resizableView}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.NumericStepperView.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'NumericStepperView', qName: 'org.apache.royale.html.beads.NumericStepperView', kind: 'class' }], interfaces: [org.apache.royale.core.IBeadView] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.NumericStepperView.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.NumericStepperView'},
        'contentView': { type: 'org.apache.royale.core.IParentIUIBase', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.NumericStepperView'},
        'resizableView': { type: 'org.apache.royale.core.IUIBase', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.NumericStepperView'}
      };
    },
    methods: function () {
      return {
        'NumericStepperView': { type: '', declaredBy: 'org.apache.royale.html.beads.NumericStepperView'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.NumericStepperView.prototype.ROYALE_COMPILE_FLAGS = 10;