/**
 * Generated by Apache Royale Compiler from org/apache/royale/core/StyledUIBase.as
 * org.apache.royale.core.StyledUIBase
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.core.StyledUIBase');

goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.html.util.addElementToWrapper');
goog.require('org.apache.royale.utils.ClassSelectorList');
goog.require('org.apache.royale.utils.sendEvent');
goog.require('org.apache.royale.core.IStyledUIBase');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.3
 * @constructor
 * @extends {org.apache.royale.core.UIBase}
 * @implements {org.apache.royale.core.IStyledUIBase}
 */
org.apache.royale.core.StyledUIBase = function() {
  this.classSelectorList = new org.apache.royale.utils.ClassSelectorList(this);
  org.apache.royale.core.StyledUIBase.base(this, 'constructor');
};
goog.inherits(org.apache.royale.core.StyledUIBase, org.apache.royale.core.UIBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.core.StyledUIBase', org.apache.royale.core.StyledUIBase);


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.core.StyledUIBase.PRIMARY = "primary";


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.core.StyledUIBase.SECONDARY = "secondary";


/**
 * @export
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.core.StyledUIBase.EMPHASIZED = "emphasized";


/**
 * @protected
 * @type {org.apache.royale.utils.ClassSelectorList}
 */
org.apache.royale.core.StyledUIBase.prototype.classSelectorList;


/**
 * @protected
 * @override
 */
org.apache.royale.core.StyledUIBase.prototype.setClassName = function(value) {
  this.classSelectorList.addNames(value);
};


/**
 * Add a class selector to the list.
 * 
 * @asparam name Name of selector to add.
 * 
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.3
 * @export
 * @param {string} name
 */
org.apache.royale.core.StyledUIBase.prototype.addClass = function(name) {
  if (name != "" && name != null)
    this.classSelectorList.add(name);
};


/**
 * Removes a class selector from the list.
 * 
 * @asparam name Name of selector to remove.
 *
 * @royaleignorecoercion HTMLElement
 * @royaleignorecoercion DOMTokenList
 * 
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.3
 * @export
 * @param {string} name
 */
org.apache.royale.core.StyledUIBase.prototype.removeClass = function(name) {
  this.classSelectorList.remove(name);
};


/**
 * Add or remove a class selector to/from the list.
 * 
 * @asparam name Name of selector to add or remove.
 * @asparam value True to add, False to remove.
 * 
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.3
 * @export
 * @param {string} name
 * @param {boolean} value
 */
org.apache.royale.core.StyledUIBase.prototype.toggleClass = function(name, value) {
  this.classSelectorList.toggle(name, value);
};


/**
 *  Search for the name in the element class list 
 *
 *  @asparam name Name of selector to find.
 *  @asreturn return true if the name is found or false otherwise.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.3
 * @export
 * @param {string} name
 * @return {boolean}
 */
org.apache.royale.core.StyledUIBase.prototype.containsClass = function(name) {
  return this.classSelectorList.contains(name);
  
};


/**
 * @private
 * @type {string}
 */
org.apache.royale.core.StyledUIBase.prototype.org_apache_royale_core_StyledUIBase__emphasis;


/**
 * @asreturn The actual element to be parented.
 * @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.royale.core.StyledUIBase.prototype.createElement = function() {
  org.apache.royale.html.util.addElementToWrapper(this, 'div');
  return this.element;
};


/**
 *  In Javascript platform for convenience we use NaN value to remove style, since Browsers
 *  use defaults for unset style properties.
 * 
 *  @copy org.apache.royale.core.ILayoutChild#setHeight
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.7
 * @export
 * @override
 */
org.apache.royale.core.StyledUIBase.prototype.setHeight = function(value, noEvent) {
  noEvent = typeof noEvent !== 'undefined' ? noEvent : false;
  if (this._height !== value) {
    this._height = value;
    this.positioner.style.height = isNaN(value) ? null : value.toString() + 'px';
    if (!noEvent)
      org.apache.royale.utils.sendEvent(this, "heightChanged");
  }
};


/**
 *  In Javascript platform for convenience we use NaN value to remove style, since Browsers
 *  use defaults for unset style properties.
 * 
 *  @copy org.apache.royale.core.ILayoutChild#setWidth
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.7
 * @export
 * @override
 */
org.apache.royale.core.StyledUIBase.prototype.setWidth = function(value, noEvent) {
  noEvent = typeof noEvent !== 'undefined' ? noEvent : false;
  if (this._width !== value) {
    this._width = value;
    this.positioner.style.width = isNaN(value) ? null : value.toString() + 'px';
    if (!noEvent)
      org.apache.royale.utils.sendEvent(this, "widthChanged");
  }
};


/**
 *  In Javascript platform for convenience we use NaN value to remove style, since Browsers
 *  use defaults for unset style properties.
 * 
 *  @copy org.apache.royale.core.ILayoutChild#setWidthAndHeight
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.7
 * @export
 * @override
 */
org.apache.royale.core.StyledUIBase.prototype.setWidthAndHeight = function(newWidth, newHeight, noEvent) {
  noEvent = typeof noEvent !== 'undefined' ? noEvent : false;
  var /** @type {boolean} */ widthChanged = this._width !== newWidth;
  var /** @type {boolean} */ heightChanged = this._height !== newHeight;
  if (widthChanged) {
    this._width = newWidth;
    this.positioner.style.width = isNaN(newWidth) ? null : newWidth.toString() + 'px';
    if (!noEvent && !heightChanged)
      org.apache.royale.utils.sendEvent(this, "widthChanged");
  }
  if (heightChanged) {
    this._height = newHeight;
    this.positioner.style.height = isNaN(newHeight) ? null : newHeight.toString() + 'px';
    if (!noEvent && !widthChanged)
      org.apache.royale.utils.sendEvent(this, "heightChanged");
  }
  if (widthChanged && heightChanged)
    org.apache.royale.utils.sendEvent(this, "sizeChanged");
};


/**
 *  In Javascript platform for convenience we use NaN value to remove style, since Browsers
 *  use defaults for unset style properties.
 * 
 *  @copy org.apache.royale.core.ILayoutChild#setX
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion HTMLElement
 * @export
 * @override
 */
org.apache.royale.core.StyledUIBase.prototype.setX = function(value) {
  
  if (!isNaN(value)) {
    if (this.positioner.parentNode != this.positioner.offsetParent)
      value += this.positioner.parentNode.offsetLeft;
    this.positioner.style.left = value.toString() + 'px';
  } else {
    this.positioner.style.left = null;
  }
};


/**
 *  In Javascript platform for convenience we use NaN value to remove style, since Browsers
 *  use defaults for unset style properties.
 *  
 *  @copy org.apache.royale.core.ILayoutChild#setY
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion HTMLElement
 * @export
 * @override
 */
org.apache.royale.core.StyledUIBase.prototype.setY = function(value) {
  
  if (!isNaN(value)) {
    if (this.positioner.parentNode != this.positioner.offsetParent)
      value += this.positioner.parentNode.offsetTop;
    this.positioner.style.top = value.toString() + 'px';
  } else {
    this.positioner.style.top = null;
  }
};


/**
 * @protected
 * @type {number}
 */
org.apache.royale.core.StyledUIBase.prototype._minWidth;


/**
 * @protected
 * @type {number}
 */
org.apache.royale.core.StyledUIBase.prototype._minHeight;


/**
 * @protected
 * @type {number}
 */
org.apache.royale.core.StyledUIBase.prototype._maxWidth;


/**
 * @protected
 * @type {number}
 */
org.apache.royale.core.StyledUIBase.prototype._maxHeight;


org.apache.royale.core.StyledUIBase.prototype.get__emphasis = function() {
  return this.org_apache_royale_core_StyledUIBase__emphasis;
};


org.apache.royale.core.StyledUIBase.prototype.set__emphasis = function(value) {
  if (this.org_apache_royale_core_StyledUIBase__emphasis != value) {
    if (this.org_apache_royale_core_StyledUIBase__emphasis) {
      this.removeClass(this.org_apache_royale_core_StyledUIBase__emphasis);
    }
    this.org_apache_royale_core_StyledUIBase__emphasis = value;
    this.addClass(this.org_apache_royale_core_StyledUIBase__emphasis);
  }
};


org.apache.royale.core.StyledUIBase.prototype.set__percentWidth = function(value) {
  
  this._percentWidth = value;
  this.positioner.style.width = isNaN(value) ? null : value.toString() + '%';
  if (!isNaN(value))
    this._explicitWidth = NaN;
  org.apache.royale.utils.sendEvent(this, "percentWidthChanged");
};


org.apache.royale.core.StyledUIBase.prototype.set__percentHeight = function(value) {
  
  this._percentHeight = value;
  this.positioner.style.height = isNaN(value) ? null : value.toString() + '%';
  if (!isNaN(value))
    this._explicitHeight = NaN;
  org.apache.royale.utils.sendEvent(this, "percentHeightChanged");
};


org.apache.royale.core.StyledUIBase.prototype.get__minWidth = function() {
  return this._minWidth;
};


org.apache.royale.core.StyledUIBase.prototype.set__minWidth = function(value) {
  if (this._minWidth !== value) {
    this._minWidth = value;
    this.positioner.style.minWidth = this._minWidth.toString() + 'px';
  }
};


org.apache.royale.core.StyledUIBase.prototype.get__minHeight = function() {
  return this._minHeight;
};


org.apache.royale.core.StyledUIBase.prototype.set__minHeight = function(value) {
  if (this._minHeight !== value) {
    this._minHeight = value;
    this.positioner.style.minHeight = this._minHeight.toString() + 'px';
  }
};


org.apache.royale.core.StyledUIBase.prototype.get__maxWidth = function() {
  return this._maxWidth;
};


org.apache.royale.core.StyledUIBase.prototype.set__maxWidth = function(value) {
  if (this._maxWidth !== value) {
    this._maxWidth = value;
    this.positioner.style.maxWidth = this._maxWidth.toString() + 'px';
  }
};


org.apache.royale.core.StyledUIBase.prototype.get__maxHeight = function() {
  return this._maxHeight;
};


org.apache.royale.core.StyledUIBase.prototype.set__maxHeight = function(value) {
  if (this._maxHeight !== value) {
    this._maxHeight = value;
    this.positioner.style.maxHeight = this._maxHeight.toString() + 'px';
  }
};


Object.defineProperties(org.apache.royale.core.StyledUIBase.prototype, /** @lends {org.apache.royale.core.StyledUIBase.prototype} */ {
/**
  * @export
  * @type {string} */
emphasis: {
get: org.apache.royale.core.StyledUIBase.prototype.get__emphasis,
set: org.apache.royale.core.StyledUIBase.prototype.set__emphasis},
/**
  * @export
  * @type {number} */
percentWidth: {
get: org.apache.royale.core.UIBase.prototype.get__percentWidth,
set: org.apache.royale.core.StyledUIBase.prototype.set__percentWidth},
/**
  * @export
  * @type {number} */
percentHeight: {
get: org.apache.royale.core.UIBase.prototype.get__percentHeight,
set: org.apache.royale.core.StyledUIBase.prototype.set__percentHeight},
/**
  * @export
  * @type {number} */
minWidth: {
get: org.apache.royale.core.StyledUIBase.prototype.get__minWidth,
set: org.apache.royale.core.StyledUIBase.prototype.set__minWidth},
/**
  * @export
  * @type {number} */
minHeight: {
get: org.apache.royale.core.StyledUIBase.prototype.get__minHeight,
set: org.apache.royale.core.StyledUIBase.prototype.set__minHeight},
/**
  * @export
  * @type {number} */
maxWidth: {
get: org.apache.royale.core.StyledUIBase.prototype.get__maxWidth,
set: org.apache.royale.core.StyledUIBase.prototype.set__maxWidth},
/**
  * @export
  * @type {number} */
maxHeight: {
get: org.apache.royale.core.StyledUIBase.prototype.get__maxHeight,
set: org.apache.royale.core.StyledUIBase.prototype.set__maxHeight}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.core.StyledUIBase.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'StyledUIBase', qName: 'org.apache.royale.core.StyledUIBase', kind: 'class' }], interfaces: [org.apache.royale.core.IStyledUIBase] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.core.StyledUIBase.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'emphasis': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.core.StyledUIBase'},
        'percentWidth': { type: 'Number', access: 'writeonly', declaredBy: 'org.apache.royale.core.StyledUIBase'},
        'percentHeight': { type: 'Number', access: 'writeonly', declaredBy: 'org.apache.royale.core.StyledUIBase'},
        'minWidth': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.core.StyledUIBase'},
        'minHeight': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.core.StyledUIBase'},
        'maxWidth': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.core.StyledUIBase'},
        'maxHeight': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.core.StyledUIBase'}
      };
    },
    methods: function () {
      return {
        'StyledUIBase': { type: '', declaredBy: 'org.apache.royale.core.StyledUIBase'},
        'addClass': { type: 'void', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [ 'String', false ]; }},
        'removeClass': { type: 'void', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [ 'String', false ]; }},
        'toggleClass': { type: 'void', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [ 'String', false ,'Boolean', false ]; }},
        'containsClass': { type: 'Boolean', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [ 'String', false ]; }},
        'setHeight': { type: 'void', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [ 'Number', false ,'Boolean', true ]; }},
        'setWidth': { type: 'void', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [ 'Number', false ,'Boolean', true ]; }},
        'setWidthAndHeight': { type: 'void', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [ 'Number', false ,'Number', false ,'Boolean', true ]; }},
        'setX': { type: 'void', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [ 'Number', false ]; }},
        'setY': { type: 'void', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [ 'Number', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.core.StyledUIBase.prototype.ROYALE_COMPILE_FLAGS = 10;