/**
 * Generated by Apache Royale Compiler from org\apache\royale\html\Menu.as
 * org.apache.royale.html.Menu
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.Menu');

goog.require('org.apache.royale.core.IParent');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.geom.Point');
goog.require('org.apache.royale.html.List');
goog.require('org.apache.royale.utils.PointUtils');
goog.require('org.apache.royale.utils.UIUtils');
goog.require('org.apache.royale.core.IMenu');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @constructor
 * @extends {org.apache.royale.html.List}
 * @implements {org.apache.royale.core.IMenu}
 */
org.apache.royale.html.Menu = function() {
  org.apache.royale.html.Menu.base(this, 'constructor');
  this.typeNames = "Menu";
};
goog.inherits(org.apache.royale.html.Menu, org.apache.royale.html.List);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.Menu', org.apache.royale.html.Menu);


/**
 * @private
 * @type {org.apache.royale.events.IEventDispatcher}
 */
org.apache.royale.html.Menu.prototype.org_apache_royale_html_Menu__parentMenuBar;


/**
 * Creates a new instance of the menu, attaching the data given as the dataProvider
 * to the menu.
 * 
 * @asparam dataProvider Object Either an Array of Strings or an Array of Objects.
 * 
 * @asreturn Menu The Menu created.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @export
 * @param {Object} dataProvider
 * @return {org.apache.royale.html.Menu}
 */
org.apache.royale.html.Menu.createMenu = function(dataProvider) {
  var /** @type {org.apache.royale.html.Menu} */ menu = new org.apache.royale.html.Menu();
  menu.dataProvider = dataProvider;
  return menu;
};


/**
 * Displays the menu at the given location which is an offset from the origin
 * of the component supplied.
 * 
 * @asparam component IUIBase A reference position used to place the Menu.
 * @asparam xoffset Number The horizontal offset from the component's position.
 * @asparam yoffset Number The vertical offset from the component's position.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @export
 * @param {org.apache.royale.core.IUIBase} component
 * @param {number=} xoffset
 * @param {number=} yoffset
 */
org.apache.royale.html.Menu.prototype.show = function(component, xoffset, yoffset) {
  xoffset = typeof xoffset !== 'undefined' ? xoffset : 0;
  yoffset = typeof yoffset !== 'undefined' ? yoffset : 0;
  var /** @type {org.apache.royale.core.IParent} */ host = org.apache.royale.utils.Language.as(org.apache.royale.utils.UIUtils.findPopUpHost(component).popUpParent, org.apache.royale.core.IParent);
  var /** @type {org.apache.royale.geom.Point} */ orgPoint = new org.apache.royale.geom.Point(component.x + xoffset, component.y + yoffset);
  var /** @type {org.apache.royale.geom.Point} */ popupPoint = org.apache.royale.utils.PointUtils.localToGlobal(orgPoint, component.parent);
  this.x = popupPoint.x;
  this.y = popupPoint.y;
  host.addElement(this);
};


/**
 * Hides the menu if displayed.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @export
 */
org.apache.royale.html.Menu.prototype.hide = function() {
  var /** @type {org.apache.royale.core.IParent} */ host = org.apache.royale.utils.Language.as(org.apache.royale.utils.UIUtils.findPopUpHost(this).popUpParent, org.apache.royale.core.IParent);
  org.apache.royale.utils.Language.as(host, org.apache.royale.events.IEventDispatcher).dispatchEvent(new org.apache.royale.events.Event("hideMenus"));
};


org.apache.royale.html.Menu.prototype.get__submenuField = function() {
  return null;
};


org.apache.royale.html.Menu.prototype.set__submenuField = function(value) {
};


org.apache.royale.html.Menu.prototype.get__parentMenuBar = function() {
  return this.org_apache_royale_html_Menu__parentMenuBar;
};


org.apache.royale.html.Menu.prototype.set__parentMenuBar = function(value) {
  this.org_apache_royale_html_Menu__parentMenuBar = value;
};


Object.defineProperties(org.apache.royale.html.Menu.prototype, /** @lends {org.apache.royale.html.Menu.prototype} */ {
/**
  * @export
  * @type {string} */
submenuField: {
get: org.apache.royale.html.Menu.prototype.get__submenuField,
set: org.apache.royale.html.Menu.prototype.set__submenuField},
/**
  * @export
  * @type {org.apache.royale.events.IEventDispatcher} */
parentMenuBar: {
get: org.apache.royale.html.Menu.prototype.get__parentMenuBar,
set: org.apache.royale.html.Menu.prototype.set__parentMenuBar}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.Menu.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'Menu', qName: 'org.apache.royale.html.Menu', kind: 'class' }], interfaces: [org.apache.royale.core.IMenu] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.Menu.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'submenuField': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.html.Menu'},
        'parentMenuBar': { type: 'org.apache.royale.events.IEventDispatcher', access: 'readwrite', declaredBy: 'org.apache.royale.html.Menu'}
      };
    },
    methods: function () {
      return {
        'Menu': { type: '', declaredBy: 'org.apache.royale.html.Menu'},
        '|createMenu': { type: 'org.apache.royale.html.Menu', declaredBy: 'org.apache.royale.html.Menu', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }},
        'show': { type: 'void', declaredBy: 'org.apache.royale.html.Menu', parameters: function () { return [  { index: 1, type: 'org.apache.royale.core.IUIBase', optional: false },{ index: 2, type: 'Number', optional: true },{ index: 3, type: 'Number', optional: true } ]; }},
        'hide': { type: 'void', declaredBy: 'org.apache.royale.html.Menu'}
      };
    }
  };
};