/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.clientinterface;

import java.util.Date;
import java.util.List;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.clientinterface.MQCollector;
import org.apache.rocketmq.test.clientinterface.MQProducer;
import org.apache.rocketmq.test.sendresult.ResultWrapper;
import org.apache.rocketmq.test.util.RandomUtil;
import org.apache.rocketmq.test.util.TestUtil;

public abstract class AbstractMQProducer
extends MQCollector
implements MQProducer {
    protected String topic = null;
    protected ResultWrapper sendResult = new ResultWrapper();
    protected boolean startSuccess = false;
    protected String producerGroupName = RandomUtil.getStringByUUID();
    protected String producerInstanceName = RandomUtil.getStringByUUID();
    protected boolean isDebug = false;

    public AbstractMQProducer(String topic) {
        this.topic = topic;
    }

    public AbstractMQProducer(String topic, String originMsgCollector, String msgBodyCollector) {
        super(originMsgCollector, msgBodyCollector);
        this.topic = topic;
    }

    public boolean isStartSuccess() {
        return this.startSuccess;
    }

    public void setStartSuccess(boolean startSuccess) {
        this.startSuccess = startSuccess;
    }

    public String getProducerInstanceName() {
        return this.producerInstanceName;
    }

    public void setProducerInstanceName(String producerInstanceName) {
        this.producerInstanceName = producerInstanceName;
    }

    public String getProducerGroupName() {
        return this.producerGroupName;
    }

    public void setProducerGroupName(String producerGroupName) {
        this.producerGroupName = producerGroupName;
    }

    @Override
    public void setDebug() {
        this.isDebug = true;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    @Override
    public void setRun() {
        this.isDebug = false;
    }

    public List<MessageQueue> getMessageQueue() {
        return null;
    }

    private Object getMessage() {
        return this.getMessageByTag(null);
    }

    public Object getMessageByTag(String tag) {
        Message objMsg = null;
        if (this instanceof RMQNormalProducer) {
            Message msg;
            objMsg = msg = new Message(this.topic, (RandomUtil.getStringByUUID() + "." + new Date()).getBytes());
            if (tag != null) {
                msg.setTags(tag);
            }
        }
        return objMsg;
    }

    public void send() {
        Object msg = this.getMessage();
        this.send(msg, null);
    }

    public void send(Object msg) {
        this.send(msg, null);
    }

    public void send(long msgNum) {
        int i = 0;
        while ((long)i < msgNum) {
            this.send();
            ++i;
        }
    }

    public void send(long msgNum, int intervalMills) {
        int i = 0;
        while ((long)i < msgNum) {
            this.send();
            TestUtil.waitForMonment(intervalMills);
            ++i;
        }
    }

    public void send(String tag, int msgSize) {
        for (int i = 0; i < msgSize; ++i) {
            Object msg = this.getMessageByTag(tag);
            this.send(msg, null);
        }
    }

    public void send(String tag, int msgSize, int intervalMills) {
        for (int i = 0; i < msgSize; ++i) {
            Object msg = this.getMessageByTag(tag);
            this.send(msg, null);
            TestUtil.waitForMonment(intervalMills);
        }
    }

    public void send(List<Object> msgs) {
        for (Object msg : msgs) {
            this.send(msg, null);
        }
    }
}

