/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.core;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.rocketmq.client.Validators;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.RequestCallback;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.client.producer.selector.SelectMessageQueueByHash;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageBatch;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.core.RocketMQLocalRequestCallback;
import org.apache.rocketmq.spring.support.RocketMQMessageConverter;
import org.apache.rocketmq.spring.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.MimeTypeUtils;

public class RocketMQTemplate
extends AbstractMessageSendingTemplate<String>
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RocketMQTemplate.class);
    private DefaultMQProducer producer;
    private DefaultLitePullConsumer consumer;
    private String charset = "UTF-8";
    private MessageQueueSelector messageQueueSelector = new SelectMessageQueueByHash();
    private RocketMQMessageConverter rocketMQMessageConverter = new RocketMQMessageConverter();

    public DefaultMQProducer getProducer() {
        return this.producer;
    }

    public void setProducer(DefaultMQProducer producer) {
        this.producer = producer;
    }

    public DefaultLitePullConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(DefaultLitePullConsumer consumer) {
        this.consumer = consumer;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public MessageQueueSelector getMessageQueueSelector() {
        return this.messageQueueSelector;
    }

    public void setMessageQueueSelector(MessageQueueSelector messageQueueSelector) {
        this.messageQueueSelector = messageQueueSelector;
    }

    public void setAsyncSenderExecutor(ExecutorService asyncSenderExecutor) {
        this.producer.setAsyncSenderExecutor(asyncSenderExecutor);
    }

    public <T> T sendAndReceive(String destination, org.springframework.messaging.Message<?> message, Type type) {
        return this.sendAndReceive(destination, message, type, (String)null, (long)this.producer.getSendMsgTimeout(), 0);
    }

    public <T> T sendAndReceive(String destination, Object payload, Type type) {
        return this.sendAndReceive(destination, payload, type, null, (long)this.producer.getSendMsgTimeout(), 0);
    }

    public <T> T sendAndReceive(String destination, org.springframework.messaging.Message<?> message, Type type, long timeout) {
        return this.sendAndReceive(destination, message, type, (String)null, timeout, 0);
    }

    public <T> T sendAndReceive(String destination, Object payload, Type type, long timeout) {
        return this.sendAndReceive(destination, payload, type, null, timeout, 0);
    }

    public <T> T sendAndReceive(String destination, org.springframework.messaging.Message<?> message, Type type, long timeout, int delayLevel) {
        return this.sendAndReceive(destination, message, type, (String)null, timeout, delayLevel);
    }

    public <T> T sendAndReceive(String destination, Object payload, Type type, long timeout, int delayLevel) {
        return this.sendAndReceive(destination, payload, type, null, timeout, delayLevel);
    }

    public <T> T sendAndReceive(String destination, org.springframework.messaging.Message<?> message, Type type, String hashKey) {
        return this.sendAndReceive(destination, message, type, hashKey, (long)this.producer.getSendMsgTimeout(), 0);
    }

    public <T> T sendAndReceive(String destination, Object payload, Type type, String hashKey) {
        return this.sendAndReceive(destination, payload, type, hashKey, (long)this.producer.getSendMsgTimeout(), 0);
    }

    public <T> T sendAndReceive(String destination, org.springframework.messaging.Message<?> message, Type type, String hashKey, long timeout) {
        return this.sendAndReceive(destination, message, type, hashKey, timeout, 0);
    }

    public <T> T sendAndReceive(String destination, Object payload, Type type, String hashKey, long timeout) {
        return this.sendAndReceive(destination, payload, type, hashKey, timeout, 0);
    }

    public <T> T sendAndReceive(String destination, org.springframework.messaging.Message<?> message, Type type, String hashKey, long timeout, int delayLevel) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("send request message failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = this.createRocketMqMessage(destination, message);
            if (delayLevel > 0) {
                rocketMsg.setDelayTimeLevel(delayLevel);
            }
            MessageExt replyMessage = Objects.isNull(hashKey) || hashKey.isEmpty() ? (MessageExt)this.producer.request(rocketMsg, timeout) : (MessageExt)this.producer.request(rocketMsg, this.messageQueueSelector, (Object)hashKey, timeout);
            return (T)(replyMessage != null ? this.doConvertMessage(replyMessage, type) : null);
        }
        catch (Exception e) {
            log.error("send request message failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public <T> T sendAndReceive(String destination, Object payload, Type type, String hashKey, long timeout, int delayLevel) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.sendAndReceive(destination, message, type, hashKey, timeout, delayLevel);
    }

    public void sendAndReceive(String destination, org.springframework.messaging.Message<?> message, RocketMQLocalRequestCallback rocketMQLocalRequestCallback) {
        this.sendAndReceive(destination, message, rocketMQLocalRequestCallback, (String)null, (long)this.producer.getSendMsgTimeout(), 0);
    }

    public void sendAndReceive(String destination, Object payload, RocketMQLocalRequestCallback rocketMQLocalRequestCallback) {
        this.sendAndReceive(destination, payload, rocketMQLocalRequestCallback, null, (long)this.producer.getSendMsgTimeout(), 0);
    }

    public void sendAndReceive(String destination, org.springframework.messaging.Message<?> message, RocketMQLocalRequestCallback rocketMQLocalRequestCallback, long timeout) {
        this.sendAndReceive(destination, message, rocketMQLocalRequestCallback, (String)null, timeout, 0);
    }

    public void sendAndReceive(String destination, Object payload, RocketMQLocalRequestCallback rocketMQLocalRequestCallback, long timeout) {
        this.sendAndReceive(destination, payload, rocketMQLocalRequestCallback, null, timeout, 0);
    }

    public void sendAndReceive(String destination, org.springframework.messaging.Message<?> message, RocketMQLocalRequestCallback rocketMQLocalRequestCallback, long timeout, int delayLevel) {
        this.sendAndReceive(destination, message, rocketMQLocalRequestCallback, (String)null, timeout, delayLevel);
    }

    public void sendAndReceive(String destination, Object payload, RocketMQLocalRequestCallback rocketMQLocalRequestCallback, String hashKey) {
        this.sendAndReceive(destination, payload, rocketMQLocalRequestCallback, hashKey, (long)this.producer.getSendMsgTimeout(), 0);
    }

    public void sendAndReceive(String destination, org.springframework.messaging.Message<?> message, RocketMQLocalRequestCallback rocketMQLocalRequestCallback, String hashKey, long timeout) {
        this.sendAndReceive(destination, message, rocketMQLocalRequestCallback, hashKey, timeout, 0);
    }

    public void sendAndReceive(String destination, Object payload, RocketMQLocalRequestCallback rocketMQLocalRequestCallback, String hashKey, long timeout) {
        this.sendAndReceive(destination, payload, rocketMQLocalRequestCallback, hashKey, timeout, 0);
    }

    public void sendAndReceive(String destination, org.springframework.messaging.Message<?> message, RocketMQLocalRequestCallback rocketMQLocalRequestCallback, String hashKey) {
        this.sendAndReceive(destination, message, rocketMQLocalRequestCallback, hashKey, (long)this.producer.getSendMsgTimeout(), 0);
    }

    public void sendAndReceive(String destination, Object payload, RocketMQLocalRequestCallback rocketMQLocalRequestCallback, long timeout, int delayLevel) {
        this.sendAndReceive(destination, payload, rocketMQLocalRequestCallback, null, timeout, delayLevel);
    }

    public void sendAndReceive(String destination, Object payload, RocketMQLocalRequestCallback rocketMQLocalRequestCallback, String hashKey, long timeout, int delayLevel) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        this.sendAndReceive(destination, message, rocketMQLocalRequestCallback, hashKey, timeout, delayLevel);
    }

    public void sendAndReceive(String destination, org.springframework.messaging.Message<?> message, final RocketMQLocalRequestCallback rocketMQLocalRequestCallback, String hashKey, long timeout, int delayLevel) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("send request message failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = this.createRocketMqMessage(destination, message);
            if (delayLevel > 0) {
                rocketMsg.setDelayTimeLevel(delayLevel);
            }
            if (timeout <= 0L) {
                timeout = this.producer.getSendMsgTimeout();
            }
            RequestCallback requestCallback = null;
            if (rocketMQLocalRequestCallback != null) {
                requestCallback = new RequestCallback(){

                    public void onSuccess(Message message) {
                        rocketMQLocalRequestCallback.onSuccess(RocketMQTemplate.this.doConvertMessage((MessageExt)message, RocketMQTemplate.this.getMessageType(rocketMQLocalRequestCallback)));
                    }

                    public void onException(Throwable e) {
                        rocketMQLocalRequestCallback.onException(e);
                    }
                };
            }
            if (Objects.isNull(hashKey) || hashKey.isEmpty()) {
                this.producer.request(rocketMsg, requestCallback, timeout);
            } else {
                this.producer.request(rocketMsg, this.messageQueueSelector, (Object)hashKey, requestCallback, timeout);
            }
        }
        catch (Exception e) {
            log.error("send request message failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public SendResult syncSend(String destination, org.springframework.messaging.Message<?> message) {
        return this.syncSend(destination, message, (long)this.producer.getSendMsgTimeout());
    }

    public SendResult syncSend(String destination, org.springframework.messaging.Message<?> message, long timeout) {
        return this.syncSend(destination, message, timeout, 0);
    }

    public <T extends org.springframework.messaging.Message> SendResult syncSend(String destination, Collection<T> messages) {
        return this.syncSend(destination, messages, (long)this.producer.getSendMsgTimeout());
    }

    public <T extends org.springframework.messaging.Message> SendResult syncSend(String destination, Collection<T> messages, long timeout) {
        if (Objects.isNull(messages) || messages.size() == 0) {
            log.error("syncSend with batch failed. destination:{}, messages is empty ", (Object)destination);
            throw new IllegalArgumentException("`messages` can not be empty");
        }
        try {
            long now = System.currentTimeMillis();
            ArrayList<Message> rmqMsgs = new ArrayList<Message>();
            for (org.springframework.messaging.Message msg : messages) {
                if (Objects.isNull(msg) || Objects.isNull(msg.getPayload())) {
                    log.warn("Found a message empty in the batch, skip it");
                    continue;
                }
                rmqMsgs.add(this.createRocketMqMessage(destination, msg));
            }
            SendResult sendResult = this.producer.send(rmqMsgs, timeout);
            long costTime = System.currentTimeMillis() - now;
            if (log.isDebugEnabled()) {
                log.debug("send messages cost: {} ms, msgId:{}", (Object)costTime, (Object)sendResult.getMsgId());
            }
            return sendResult;
        }
        catch (Exception e) {
            log.error("syncSend with batch failed. destination:{}, messages.size:{} ", (Object)destination, (Object)messages.size());
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public SendResult syncSend(String destination, org.springframework.messaging.Message<?> message, long timeout, int delayLevel) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("syncSend failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            long now = System.currentTimeMillis();
            Message rocketMsg = this.createRocketMqMessage(destination, message);
            if (delayLevel > 0) {
                rocketMsg.setDelayTimeLevel(delayLevel);
            }
            SendResult sendResult = this.producer.send(rocketMsg, timeout);
            long costTime = System.currentTimeMillis() - now;
            if (log.isDebugEnabled()) {
                log.debug("send message cost: {} ms, msgId:{}", (Object)costTime, (Object)sendResult.getMsgId());
            }
            return sendResult;
        }
        catch (Exception e) {
            log.error("syncSend failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public SendResult syncSend(String destination, Object payload) {
        return this.syncSend(destination, payload, (long)this.producer.getSendMsgTimeout());
    }

    public SendResult syncSend(String destination, Object payload, long timeout) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.syncSend(destination, message, timeout);
    }

    public SendResult syncSendOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey) {
        return this.syncSendOrderly(destination, message, hashKey, (long)this.producer.getSendMsgTimeout());
    }

    public SendResult syncSendOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey, long timeout) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("syncSendOrderly failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            long now = System.currentTimeMillis();
            Message rocketMsg = this.createRocketMqMessage(destination, message);
            SendResult sendResult = this.producer.send(rocketMsg, this.messageQueueSelector, (Object)hashKey, timeout);
            long costTime = System.currentTimeMillis() - now;
            if (log.isDebugEnabled()) {
                log.debug("send message cost: {} ms, msgId:{}", (Object)costTime, (Object)sendResult.getMsgId());
            }
            return sendResult;
        }
        catch (Exception e) {
            log.error("syncSendOrderly failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public SendResult syncSendOrderly(String destination, Object payload, String hashKey) {
        return this.syncSendOrderly(destination, payload, hashKey, (long)this.producer.getSendMsgTimeout());
    }

    public SendResult syncSendOrderly(String destination, Object payload, String hashKey, long timeout) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.syncSendOrderly(destination, message, hashKey, timeout);
    }

    public <T extends org.springframework.messaging.Message> SendResult syncSendOrderly(String destination, Collection<T> messages, String hashKey) {
        return this.syncSendOrderly(destination, messages, hashKey, (long)this.producer.getSendMsgTimeout());
    }

    public <T extends org.springframework.messaging.Message> SendResult syncSendOrderly(String destination, Collection<T> messages, String hashKey, long timeout) {
        if (Objects.isNull(messages) || messages.isEmpty()) {
            log.error("syncSendOrderly failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`messages` can not be empty");
        }
        try {
            long now = System.currentTimeMillis();
            ArrayList<Message> rmqMsgs = new ArrayList<Message>();
            for (org.springframework.messaging.Message message : messages) {
                if (Objects.isNull(message)) continue;
                rmqMsgs.add(this.createRocketMqMessage(destination, message));
            }
            MessageBatch messageBatch = this.batch(rmqMsgs);
            SendResult sendResult = this.producer.send((Message)messageBatch, this.messageQueueSelector, (Object)hashKey, timeout);
            long costTime = System.currentTimeMillis() - now;
            if (log.isDebugEnabled()) {
                log.debug("send message cost: {} ms, msgId:{}", (Object)costTime, (Object)sendResult.getMsgId());
            }
            return sendResult;
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void asyncSend(String destination, org.springframework.messaging.Message<?> message, SendCallback sendCallback, long timeout, int delayLevel) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("asyncSend failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = this.createRocketMqMessage(destination, message);
            if (delayLevel > 0) {
                rocketMsg.setDelayTimeLevel(delayLevel);
            }
            this.producer.send(rocketMsg, sendCallback, timeout);
        }
        catch (Exception e) {
            log.info("asyncSend failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void asyncSend(String destination, org.springframework.messaging.Message<?> message, SendCallback sendCallback, long timeout) {
        this.asyncSend(destination, message, sendCallback, timeout, 0);
    }

    public void asyncSend(String destination, org.springframework.messaging.Message<?> message, SendCallback sendCallback) {
        this.asyncSend(destination, message, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSend(String destination, Object payload, SendCallback sendCallback, long timeout) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        this.asyncSend(destination, message, sendCallback, timeout);
    }

    public void asyncSend(String destination, Object payload, SendCallback sendCallback) {
        this.asyncSend(destination, payload, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public <T extends org.springframework.messaging.Message> void asyncSend(String destination, Collection<T> messages, SendCallback sendCallback) {
        this.asyncSend(destination, messages, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public <T extends org.springframework.messaging.Message> void asyncSend(String destination, Collection<T> messages, SendCallback sendCallback, long timeout) {
        if (Objects.isNull(messages) || messages.size() == 0) {
            log.error("asyncSend with batch failed. destination:{}, messages is empty ", (Object)destination);
            throw new IllegalArgumentException("`messages` can not be empty");
        }
        try {
            ArrayList<Message> rmqMsgs = new ArrayList<Message>();
            for (org.springframework.messaging.Message msg : messages) {
                if (Objects.isNull(msg) || Objects.isNull(msg.getPayload())) {
                    log.warn("Found a message empty in the batch, skip it");
                    continue;
                }
                rmqMsgs.add(this.createRocketMqMessage(destination, msg));
            }
            this.producer.send(rmqMsgs, sendCallback, timeout);
        }
        catch (Exception e) {
            log.error("asyncSend with batch failed. destination:{}, messages.size:{} ", (Object)destination, (Object)messages.size());
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void asyncSendOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey, SendCallback sendCallback, long timeout) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("asyncSendOrderly failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = this.createRocketMqMessage(destination, message);
            this.producer.send(rocketMsg, this.messageQueueSelector, (Object)hashKey, sendCallback, timeout);
        }
        catch (Exception e) {
            log.error("asyncSendOrderly failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void asyncSendOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey, SendCallback sendCallback) {
        this.asyncSendOrderly(destination, message, hashKey, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSendOrderly(String destination, Object payload, String hashKey, SendCallback sendCallback) {
        this.asyncSendOrderly(destination, payload, hashKey, sendCallback, (long)this.producer.getSendMsgTimeout());
    }

    public void asyncSendOrderly(String destination, Object payload, String hashKey, SendCallback sendCallback, long timeout) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        this.asyncSendOrderly(destination, message, hashKey, sendCallback, timeout);
    }

    public void sendOneWay(String destination, org.springframework.messaging.Message<?> message) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("sendOneWay failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = this.createRocketMqMessage(destination, message);
            this.producer.sendOneway(rocketMsg);
        }
        catch (Exception e) {
            log.error("sendOneWay failed. destination:{}, message:{} ", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void sendOneWay(String destination, Object payload) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        this.sendOneWay(destination, message);
    }

    public void sendOneWayOrderly(String destination, org.springframework.messaging.Message<?> message, String hashKey) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            log.error("sendOneWayOrderly failed. destination:{}, message is null ", (Object)destination);
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        try {
            Message rocketMsg = this.createRocketMqMessage(destination, message);
            this.producer.sendOneway(rocketMsg, this.messageQueueSelector, (Object)hashKey);
        }
        catch (Exception e) {
            log.error("sendOneWayOrderly failed. destination:{}, message:{}", (Object)destination, message);
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public void sendOneWayOrderly(String destination, Object payload, String hashKey) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        this.sendOneWayOrderly(destination, message, hashKey);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.producer != null) {
            this.producer.start();
        }
        if (Objects.nonNull(this.consumer)) {
            try {
                this.consumer.start();
            }
            catch (Exception e) {
                log.error("Failed to startup PullConsumer for RocketMQTemplate", (Throwable)e);
            }
        }
    }

    protected void doSend(String destination, org.springframework.messaging.Message<?> message) {
        SendResult sendResult = this.syncSend(destination, message);
        if (log.isDebugEnabled()) {
            log.debug("send message to `{}` finished. result:{}", (Object)destination, (Object)sendResult);
        }
    }

    protected org.springframework.messaging.Message<?> doConvert(Object payload, Map<String, Object> headers, MessagePostProcessor postProcessor) {
        org.springframework.messaging.Message message = super.doConvert(payload, headers, postProcessor);
        MessageBuilder builder = MessageBuilder.fromMessage((org.springframework.messaging.Message)message);
        builder.setHeaderIfAbsent("contentType", (Object)MimeTypeUtils.TEXT_PLAIN);
        return builder.build();
    }

    public void destroy() {
        if (Objects.nonNull(this.producer)) {
            this.producer.shutdown();
        }
        if (Objects.nonNull(this.consumer)) {
            this.consumer.shutdown();
        }
    }

    public TransactionSendResult sendMessageInTransaction(String destination, org.springframework.messaging.Message<?> message, Object arg) throws MessagingException {
        try {
            if (((TransactionMQProducer)this.producer).getTransactionListener() == null) {
                throw new IllegalStateException("The rocketMQTemplate does not exist TransactionListener");
            }
            Message rocketMsg = this.createRocketMqMessage(destination, message);
            return this.producer.sendMessageInTransaction(rocketMsg, arg);
        }
        catch (MQClientException e) {
            throw RocketMQUtil.convert(e);
        }
    }

    private Message createRocketMqMessage(String destination, org.springframework.messaging.Message<?> message) {
        org.springframework.messaging.Message<?> msg = this.doConvert(message.getPayload(), (Map<String, Object>)message.getHeaders(), null);
        return RocketMQUtil.convertToRocketMessage(this.getMessageConverter(), this.charset, destination, msg);
    }

    private Object doConvertMessage(MessageExt messageExt, Type type) {
        if (Objects.equals(type, MessageExt.class)) {
            return messageExt;
        }
        if (Objects.equals(type, byte[].class)) {
            return messageExt.getBody();
        }
        String str = new String(messageExt.getBody(), Charset.forName(this.charset));
        if (Objects.equals(type, String.class)) {
            return str;
        }
        try {
            if (type instanceof Class) {
                return this.getMessageConverter().fromMessage(MessageBuilder.withPayload((Object)str).build(), (Class)type);
            }
            return ((SmartMessageConverter)this.getMessageConverter()).fromMessage(MessageBuilder.withPayload((Object)str).build(), (Class)((ParameterizedType)type).getRawType(), null);
        }
        catch (Exception e) {
            log.error("convert failed. str:{}, msgType:{}", (Object)str, (Object)type);
            throw new RuntimeException("cannot convert message to " + type, e);
        }
    }

    private Type getMessageType(RocketMQLocalRequestCallback rocketMQLocalRequestCallback) {
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)rocketMQLocalRequestCallback);
        Type matchedGenericInterface = null;
        while (Objects.nonNull(targetClass)) {
            Type[] interfaces = targetClass.getGenericInterfaces();
            if (Objects.nonNull(interfaces)) {
                for (Type type : interfaces) {
                    if (!(type instanceof ParameterizedType) || !Objects.equals(((ParameterizedType)type).getRawType(), RocketMQLocalRequestCallback.class)) continue;
                    matchedGenericInterface = type;
                    break;
                }
            }
            targetClass = targetClass.getSuperclass();
        }
        if (Objects.isNull(matchedGenericInterface)) {
            return Object.class;
        }
        Type[] actualTypeArguments = ((ParameterizedType)matchedGenericInterface).getActualTypeArguments();
        if (Objects.nonNull(actualTypeArguments) && actualTypeArguments.length > 0) {
            return actualTypeArguments[0];
        }
        return Object.class;
    }

    private MessageBatch batch(Collection<Message> msgs) throws MQClientException {
        MessageBatch msgBatch;
        try {
            msgBatch = MessageBatch.generateFromList(msgs);
            for (Message message : msgBatch) {
                Validators.checkMessage((Message)message, (DefaultMQProducer)this.producer);
                MessageClientIDSetter.setUniqID((Message)message);
                message.setTopic(this.producer.withNamespace(message.getTopic()));
            }
            msgBatch.setBody(msgBatch.encode());
        }
        catch (Exception e) {
            throw new MQClientException("Failed to initiate the MessageBatch", (Throwable)e);
        }
        msgBatch.setTopic(this.producer.withNamespace(msgBatch.getTopic()));
        return msgBatch;
    }

    public <T> List<T> receive(Class<T> clazz) {
        return this.receive(clazz, this.consumer.getPollTimeoutMillis());
    }

    public <T> List<T> receive(Class<T> clazz, long timeout) {
        List messageExts = this.consumer.poll(timeout);
        ArrayList<T> list = new ArrayList<T>(messageExts.size());
        for (MessageExt messageExt : messageExts) {
            list.add(this.doConvertMessage(messageExt, clazz));
        }
        return list;
    }

    private <T> T doConvertMessage(MessageExt messageExt, Class<T> messageType) {
        if (Objects.equals(messageType, MessageExt.class)) {
            return (T)messageExt;
        }
        String str = new String(messageExt.getBody(), Charset.forName(this.charset));
        if (Objects.equals(messageType, String.class)) {
            return (T)str;
        }
        try {
            return (T)this.getMessageConverter().fromMessage(MessageBuilder.withPayload((Object)str).build(), messageType);
        }
        catch (Exception e) {
            log.info("convert failed. str:{}, msgType:{}", (Object)str, messageType);
            throw new RuntimeException("cannot convert message to " + messageType, e);
        }
    }
}

