/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.rocketmq.logging.InnerLoggerFactory;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLoggerFactory
extends InternalLoggerFactory {
    public Slf4jLoggerFactory() {
        LoggerFactory.getILoggerFactory();
        this.doRegister();
    }

    @Override
    protected String getLoggerType() {
        return "slf4j";
    }

    @Override
    protected InternalLogger getLoggerInstance(String name) {
        return new Slf4jLogger(name);
    }

    @Override
    protected void shutdown() {
    }

    public static class Slf4jLogger
    implements InternalLogger {
        private static final Pattern PATTERN = Pattern.compile("#.*#");
        private final String loggerSuffix;
        private final Logger defaultLogger;
        private final Map<String, Logger> loggerMap = new HashMap<String, Logger>();

        public Slf4jLogger(String loggerSuffix) {
            this.loggerSuffix = loggerSuffix;
            this.defaultLogger = LoggerFactory.getLogger((String)loggerSuffix);
        }

        private Logger getLogger() {
            Matcher m;
            if (this.loggerSuffix.equals("RocketmqAccount") || this.loggerSuffix.equals("RocketmqConsumerStats") || this.loggerSuffix.equals("RocketmqCommercial")) {
                return this.defaultLogger;
            }
            String brokerIdentity = (String)InnerLoggerFactory.BROKER_IDENTITY.get();
            if (brokerIdentity == null && (m = PATTERN.matcher(Thread.currentThread().getName())).find()) {
                String match = m.group();
                brokerIdentity = match.substring(1, match.length() - 1);
            }
            if ("BrokerContainer".equals(brokerIdentity)) {
                return this.defaultLogger;
            }
            if (brokerIdentity != null) {
                if (!this.loggerMap.containsKey(brokerIdentity)) {
                    this.loggerMap.put(brokerIdentity, LoggerFactory.getLogger((String)("#" + brokerIdentity + "#" + this.loggerSuffix)));
                }
                return this.loggerMap.get(brokerIdentity);
            }
            return this.defaultLogger;
        }

        @Override
        public String getName() {
            return this.getLogger().getName();
        }

        @Override
        public void debug(String s) {
            this.getLogger().debug(s);
        }

        @Override
        public void debug(String s, Object o) {
            this.getLogger().debug(s, o);
        }

        @Override
        public void debug(String s, Object o, Object o1) {
            this.getLogger().debug(s, o, o1);
        }

        @Override
        public void debug(String s, Object ... objects) {
            this.getLogger().debug(s, objects);
        }

        @Override
        public void debug(String s, Throwable throwable) {
            this.getLogger().debug(s, throwable);
        }

        @Override
        public void info(String s) {
            this.getLogger().info(s);
        }

        @Override
        public void info(String s, Object o) {
            this.getLogger().info(s, o);
        }

        @Override
        public void info(String s, Object o, Object o1) {
            this.getLogger().info(s, o, o1);
        }

        @Override
        public void info(String s, Object ... objects) {
            this.getLogger().info(s, objects);
        }

        @Override
        public void info(String s, Throwable throwable) {
            this.getLogger().info(s, throwable);
        }

        @Override
        public void warn(String s) {
            this.getLogger().warn(s);
        }

        @Override
        public void warn(String s, Object o) {
            this.getLogger().warn(s, o);
        }

        @Override
        public void warn(String s, Object ... objects) {
            this.getLogger().warn(s, objects);
        }

        @Override
        public void warn(String s, Object o, Object o1) {
            this.getLogger().warn(s, o, o1);
        }

        @Override
        public void warn(String s, Throwable throwable) {
            this.getLogger().warn(s, throwable);
        }

        @Override
        public void error(String s) {
            this.getLogger().error(s);
        }

        @Override
        public void error(String s, Object o) {
            this.getLogger().error(s, o);
        }

        @Override
        public void error(String s, Object o, Object o1) {
            this.getLogger().error(s, o, o1);
        }

        @Override
        public void error(String s, Object ... objects) {
            this.getLogger().error(s, objects);
        }

        @Override
        public void error(String s, Throwable throwable) {
            this.getLogger().error(s, throwable);
        }
    }
}

