/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.utils;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.rocketmq.common.TopicAttributes;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.attribute.CQType;

public class QueueTypeUtils {
    public static boolean isBatchCq(Optional<TopicConfig> topicConfig) {
        return Objects.equals((Object)CQType.BatchCQ, (Object)QueueTypeUtils.getCQType(topicConfig));
    }

    public static CQType getCQType(Optional<TopicConfig> topicConfig) {
        if (!topicConfig.isPresent()) {
            return CQType.valueOf(TopicAttributes.QUEUE_TYPE_ATTRIBUTE.getDefaultValue());
        }
        String attributeName = TopicAttributes.QUEUE_TYPE_ATTRIBUTE.getName();
        Map<String, String> attributes = topicConfig.get().getAttributes();
        if (attributes == null || attributes.size() == 0) {
            return CQType.valueOf(TopicAttributes.QUEUE_TYPE_ATTRIBUTE.getDefaultValue());
        }
        if (attributes.containsKey(attributeName)) {
            return CQType.valueOf(attributes.get(attributeName));
        }
        return CQType.valueOf(TopicAttributes.QUEUE_TYPE_ATTRIBUTE.getDefaultValue());
    }
}

