/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerMutableResource;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerAuthContext
implements RangerPolicyEngine {
    private static final Log LOG = LogFactory.getLog(RangerAuthContext.class);
    private final RangerPluginContext rangerPluginContext;
    private RangerPolicyEngine policyEngine;
    private Map<RangerContextEnricher, Object> requestContextEnrichers;

    protected RangerAuthContext() {
        this(null, null, null);
    }

    protected RangerAuthContext(RangerPluginContext rangerPluginContext) {
        this(null, null, rangerPluginContext);
    }

    RangerAuthContext(RangerPolicyEngine policyEngine, Map<RangerContextEnricher, Object> requestContextEnrichers, RangerPluginContext rangerPluginContext) {
        this.policyEngine = policyEngine;
        this.requestContextEnrichers = requestContextEnrichers;
        this.rangerPluginContext = rangerPluginContext;
    }

    RangerAuthContext(RangerAuthContext other) {
        this(other, null);
    }

    RangerAuthContext(RangerAuthContext other, RangerPluginContext rangerPluginContext) {
        if (other != null) {
            this.policyEngine = other.getPolicyEngine();
            Map<RangerContextEnricher, Object> localReference = other.requestContextEnrichers;
            if (MapUtils.isNotEmpty(localReference)) {
                this.requestContextEnrichers = new ConcurrentHashMap<RangerContextEnricher, Object>(localReference);
            }
        }
        this.rangerPluginContext = rangerPluginContext;
    }

    public RangerPolicyEngine getPolicyEngine() {
        return this.policyEngine;
    }

    void setPolicyEngine(RangerPolicyEngine policyEngine) {
        this.policyEngine = policyEngine;
    }

    public Map<RangerContextEnricher, Object> getRequestContextEnrichers() {
        return this.requestContextEnrichers;
    }

    public void addOrReplaceRequestContextEnricher(RangerContextEnricher enricher, Object database) {
        if (this.requestContextEnrichers == null) {
            this.requestContextEnrichers = new ConcurrentHashMap<RangerContextEnricher, Object>();
        }
        this.requestContextEnrichers.put(enricher, database != null ? database : enricher);
    }

    public void cleanupRequestContextEnricher(RangerContextEnricher enricher) {
        if (this.requestContextEnrichers != null) {
            this.requestContextEnrichers.remove(enricher);
        }
    }

    @Override
    public void setUseForwardedIPAddress(boolean useForwardedIPAddress) {
        this.policyEngine.setUseForwardedIPAddress(useForwardedIPAddress);
    }

    @Override
    public void setTrustedProxyAddresses(String[] trustedProxyAddresses) {
        this.policyEngine.setTrustedProxyAddresses(trustedProxyAddresses);
    }

    @Override
    public boolean getUseForwardedIPAddress() {
        return this.policyEngine.getUseForwardedIPAddress();
    }

    @Override
    public String[] getTrustedProxyAddresses() {
        return this.policyEngine.getTrustedProxyAddresses();
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.policyEngine.getServiceDef();
    }

    @Override
    public long getPolicyVersion() {
        return this.policyEngine.getPolicyVersion();
    }

    public Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> requests, RangerAccessResultProcessor resultProcessor) {
        this.preProcess(requests);
        return this.policyEngine.evaluatePolicies(requests, 0, resultProcessor);
    }

    public RangerAccessResult isAccessAllowed(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        this.preProcess(request);
        return this.policyEngine.evaluatePolicies(request, 0, resultProcessor);
    }

    public RangerAccessResult evalDataMaskPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        this.preProcess(request);
        return this.policyEngine.evaluatePolicies(request, 1, resultProcessor);
    }

    public RangerAccessResult evalRowFilterPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        this.preProcess(request);
        return this.policyEngine.evaluatePolicies(request, 2, resultProcessor);
    }

    @Override
    public void preProcess(RangerAccessRequest request) {
        RangerAccessResource resource;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAuthContext.preProcess");
        }
        if ((resource = request.getResource()).getServiceDef() == null && resource instanceof RangerMutableResource) {
            RangerMutableResource mutable = (RangerMutableResource)resource;
            mutable.setServiceDef(this.getServiceDef());
        }
        if (request instanceof RangerAccessRequestImpl) {
            RangerAccessRequestImpl reqImpl = (RangerAccessRequestImpl)request;
            reqImpl.extractAndSetClientIPAddress(this.getUseForwardedIPAddress(), this.getTrustedProxyAddresses());
            if (this.rangerPluginContext != null) {
                reqImpl.setClusterName(this.rangerPluginContext.getClusterName());
                reqImpl.setClusterType(this.rangerPluginContext.getClusterType());
            }
        }
        RangerAccessRequestUtil.setCurrentUserInContext(request.getContext(), request.getUser());
        Set<String> roles = this.getRolesFromUserAndGroups(request.getUser(), request.getUserGroups());
        if (CollectionUtils.isNotEmpty(roles)) {
            RangerAccessRequestUtil.setCurrentUserRolesInContext(request.getContext(), roles);
        }
        if (MapUtils.isNotEmpty(this.requestContextEnrichers)) {
            for (Map.Entry<RangerContextEnricher, Object> entry : this.requestContextEnrichers.entrySet()) {
                if (entry.getValue() instanceof RangerContextEnricher && entry.getKey().equals(entry.getValue())) {
                    entry.getKey().enrich(request, null);
                    continue;
                }
                entry.getKey().enrich(request, entry.getValue());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAuthContext.preProcess");
        }
    }

    @Override
    public void preProcess(Collection<RangerAccessRequest> requests) {
        if (CollectionUtils.isNotEmpty(requests)) {
            for (RangerAccessRequest request : requests) {
                this.preProcess(request);
            }
        }
    }

    @Override
    public RangerAccessResult evaluatePolicies(RangerAccessRequest request, int policyType, RangerAccessResultProcessor resultProcessor) {
        return this.policyEngine.evaluatePolicies(request, policyType, resultProcessor);
    }

    @Override
    public Collection<RangerAccessResult> evaluatePolicies(Collection<RangerAccessRequest> requests, int policyType, RangerAccessResultProcessor resultProcessor) {
        return this.policyEngine.evaluatePolicies(requests, policyType, resultProcessor);
    }

    @Override
    public RangerResourceACLs getResourceACLs(RangerAccessRequest request) {
        this.preProcess(request);
        return this.policyEngine.getResourceACLs(request);
    }

    @Override
    public String getMatchedZoneName(GrantRevokeRequest grantRevokeRequest) {
        return this.policyEngine.getMatchedZoneName(grantRevokeRequest);
    }

    @Override
    public boolean preCleanup() {
        return this.policyEngine.preCleanup();
    }

    @Override
    public void cleanup() {
        this.policyEngine.cleanup();
    }

    @Override
    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest request) {
        this.preProcess(request);
        return this.policyEngine.getResourceAccessInfo(request);
    }

    @Override
    public List<RangerPolicy> getMatchingPolicies(RangerAccessResource resource) {
        RangerAccessRequestImpl request = new RangerAccessRequestImpl(resource, "_any", null, null);
        this.preProcess(request);
        return this.getMatchingPolicies(request);
    }

    @Override
    public List<RangerPolicy> getMatchingPolicies(RangerAccessRequest request) {
        return this.policyEngine.getMatchingPolicies(request);
    }

    @Override
    public void reorderPolicyEvaluators() {
    }

    @Override
    public boolean isAccessAllowed(RangerAccessResource resource, String user, Set<String> userGroups, String accessType) {
        return false;
    }

    @Override
    public boolean isAccessAllowed(RangerPolicy policy, String user, Set<String> userGroups, String accessType) {
        return false;
    }

    @Override
    public boolean isAccessAllowed(RangerPolicy policy, String user, Set<String> userGroups, Set<String> roles, String accessType) {
        return false;
    }

    @Override
    public boolean isAccessAllowed(Map<String, RangerPolicy.RangerPolicyResource> resources, String user, Set<String> userGroups, String accessType) {
        return false;
    }

    @Override
    public List<RangerPolicy> getExactMatchPolicies(RangerPolicy policy, Map<String, Object> evalContext) {
        return null;
    }

    @Override
    public List<RangerPolicy> getExactMatchPolicies(RangerAccessResource resource, Map<String, Object> evalContext) {
        return null;
    }

    @Override
    public List<RangerPolicy> getAllowedPolicies(String user, Set<String> userGroups, String accessType) {
        return null;
    }

    @Override
    public RangerPolicyEngine cloneWithDelta(ServicePolicies servicePolicies) {
        return this.policyEngine.cloneWithDelta(servicePolicies);
    }

    @Override
    public Set<String> getRolesFromUserAndGroups(String user, Set<String> groups) {
        return this.policyEngine.getRolesFromUserAndGroups(user, groups);
    }
}

