/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPolicyDelta;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerZoneResourceMatcher;
import org.apache.ranger.plugin.policyengine.PolicyEvaluatorForTag;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerMutableResource;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerPolicyRepository;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.policyengine.RangerTagAccessRequest;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerPolicyDeltaUtil;
import org.apache.ranger.plugin.util.RangerResourceTrie;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerPolicyEngineImpl
implements RangerPolicyEngine {
    private static final Log LOG = LogFactory.getLog(RangerPolicyEngineImpl.class);
    private static final Log PERF_POLICYENGINE_INIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.init");
    private static final Log PERF_POLICYENGINE_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policyengine.request");
    private static final Log PERF_POLICYENGINE_AUDIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.audit");
    private static final Log PERF_CONTEXTENRICHER_REQUEST_LOG = RangerPerfTracer.getPerfLogger("contextenricher.request");
    private static final Log PERF_POLICYENGINE_REBALANCE_LOG = RangerPerfTracer.getPerfLogger("policyengine.rebalance");
    private static final Log PERF_POLICYENGINE_USAGE_LOG = RangerPerfTracer.getPerfLogger("policyengine.usage");
    private static final Log PERF_POLICYENGINE_GET_ACLS_LOG = RangerPerfTracer.getPerfLogger("policyengine.getResourceACLs");
    private static final int MAX_POLICIES_FOR_CACHE_TYPE_EVALUATOR = 100;
    private final RangerPolicyRepository policyRepository;
    private final RangerPolicyRepository tagPolicyRepository;
    private boolean isPolicyRepositoryShared = false;
    private boolean isTagPolicyRepositoryShared = false;
    private List<RangerContextEnricher> allContextEnrichers;
    private boolean useForwardedIPAddress;
    private String[] trustedProxyAddresses;
    private Map<String, RangerPolicyRepository> policyRepositories = new HashMap<String, RangerPolicyRepository>();
    private Map<String, RangerResourceTrie> trieMap;
    private Map<String, String> zoneTagServiceMap;
    private final Map<String, Set<String>> userRoleMapping;
    private final Map<String, Set<String>> groupRoleMapping;
    private final RangerPluginContext rangerPluginContext;

    public RangerPolicyEngineImpl(RangerPolicyEngineImpl other, ServicePolicies servicePolicies) {
        this(other, servicePolicies, null);
    }

    public RangerPolicyEngineImpl(RangerPolicyEngineImpl other, ServicePolicies servicePolicies, RangerPluginContext rangerPluginContext) {
        List<RangerContextEnricher> tmpList;
        List<RangerPolicyDelta> deltas = servicePolicies.getPolicyDeltas();
        long policyVersion = servicePolicies.getPolicyVersion();
        this.useForwardedIPAddress = other.useForwardedIPAddress;
        this.trustedProxyAddresses = other.trustedProxyAddresses;
        ArrayList<RangerPolicyDelta> defaultZoneDeltas = new ArrayList<RangerPolicyDelta>();
        ArrayList<RangerPolicyDelta> defaultZoneDeltasForTagPolicies = new ArrayList<RangerPolicyDelta>();
        if (MapUtils.isNotEmpty(servicePolicies.getSecurityZones())) {
            List zoneDeltas;
            String zoneName;
            HashMap zoneDeltasMap = new HashMap();
            this.buildZoneTrie(servicePolicies);
            for (Map.Entry<String, ServicePolicies.SecurityZoneInfo> entry : servicePolicies.getSecurityZones().entrySet()) {
                zoneDeltasMap.put(entry.getKey(), new ArrayList());
            }
            for (RangerPolicyDelta rangerPolicyDelta : deltas) {
                zoneName = rangerPolicyDelta.getZoneName();
                if (StringUtils.isNotEmpty((String)zoneName)) {
                    zoneDeltas = (List)zoneDeltasMap.get(zoneName);
                    if (zoneDeltas == null) continue;
                    zoneDeltas.add(rangerPolicyDelta);
                    continue;
                }
                if (servicePolicies.getServiceDef().getName().equals(rangerPolicyDelta.getServiceType())) {
                    defaultZoneDeltas.add(rangerPolicyDelta);
                    continue;
                }
                defaultZoneDeltasForTagPolicies.add(rangerPolicyDelta);
            }
            for (Map.Entry<String, ServicePolicies.SecurityZoneInfo> entry : servicePolicies.getSecurityZones().entrySet()) {
                RangerPolicyRepository policyRepository;
                zoneName = entry.getKey();
                zoneDeltas = (List)zoneDeltasMap.get(zoneName);
                RangerPolicyRepository otherRepository = other.policyRepositories.get(zoneName);
                if (CollectionUtils.isNotEmpty((Collection)zoneDeltas)) {
                    if (otherRepository == null) {
                        ArrayList<RangerPolicy> policies = new ArrayList<RangerPolicy>();
                        for (RangerPolicyDelta delta : zoneDeltas) {
                            if (delta.getChangeType() == 0) {
                                policies.add(delta.getPolicy());
                                continue;
                            }
                            LOG.warn((Object)("Expected changeType:[0], found policy-change-delta:[" + delta + "]"));
                        }
                        servicePolicies.getSecurityZones().get(zoneName).setPolicies(policies);
                        policyRepository = new RangerPolicyRepository(other.policyRepository.getAppId(), servicePolicies, other.policyRepository.getOptions(), zoneName);
                    } else {
                        policyRepository = new RangerPolicyRepository(otherRepository, zoneDeltas, policyVersion);
                    }
                } else {
                    policyRepository = otherRepository;
                }
                this.policyRepositories.put(zoneName, policyRepository);
            }
        } else {
            for (RangerPolicyDelta rangerPolicyDelta : deltas) {
                if (servicePolicies.getServiceDef().getName().equals(rangerPolicyDelta.getServiceType())) {
                    defaultZoneDeltas.add(rangerPolicyDelta);
                    continue;
                }
                defaultZoneDeltasForTagPolicies.add(rangerPolicyDelta);
            }
        }
        if (other.policyRepository != null && CollectionUtils.isNotEmpty(defaultZoneDeltas)) {
            this.policyRepository = new RangerPolicyRepository(other.policyRepository, defaultZoneDeltas, policyVersion);
        } else {
            this.policyRepository = other.policyRepository;
            other.isPolicyRepositoryShared = true;
        }
        if (servicePolicies.getTagPolicies() == null) {
            this.tagPolicyRepository = null;
            if (other.tagPolicyRepository != null) {
                other.isTagPolicyRepositoryShared = false;
            }
        } else if (CollectionUtils.isNotEmpty(defaultZoneDeltasForTagPolicies)) {
            if (other.tagPolicyRepository != null) {
                this.tagPolicyRepository = new RangerPolicyRepository(other.tagPolicyRepository, defaultZoneDeltasForTagPolicies, policyVersion);
            } else {
                ArrayList<RangerPolicy> tagPolicies = new ArrayList<RangerPolicy>();
                for (RangerPolicyDelta rangerPolicyDelta : defaultZoneDeltasForTagPolicies) {
                    if (rangerPolicyDelta.getChangeType() == 0) {
                        tagPolicies.add(rangerPolicyDelta.getPolicy());
                        continue;
                    }
                    LOG.warn((Object)("Expected changeType:[0], found policy-change-delta:[" + rangerPolicyDelta + "]"));
                }
                servicePolicies.getTagPolicies().setPolicies(tagPolicies);
                this.tagPolicyRepository = new RangerPolicyRepository(other.policyRepository.getAppId(), servicePolicies.getTagPolicies(), other.policyRepository.getOptions(), servicePolicies.getServiceDef(), servicePolicies.getServiceName());
            }
        } else {
            this.tagPolicyRepository = other.tagPolicyRepository;
            other.isTagPolicyRepositoryShared = true;
        }
        this.rangerPluginContext = rangerPluginContext != null ? rangerPluginContext : null;
        List<RangerContextEnricher> list = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getContextEnrichers();
        List<RangerContextEnricher> list2 = this.policyRepository.getContextEnrichers();
        if (CollectionUtils.isEmpty(list)) {
            tmpList = list2;
        } else if (CollectionUtils.isEmpty(list2)) {
            tmpList = list;
        } else {
            tmpList = new ArrayList<RangerContextEnricher>(list);
            tmpList.addAll(list2);
        }
        this.allContextEnrichers = tmpList;
        this.userRoleMapping = MapUtils.isNotEmpty(servicePolicies.getUserRoles()) ? servicePolicies.getUserRoles() : null;
        this.groupRoleMapping = MapUtils.isNotEmpty(servicePolicies.getGroupRoles()) ? servicePolicies.getGroupRoles() : null;
        this.reorderPolicyEvaluators();
    }

    public RangerPolicyEngineImpl(String appId, ServicePolicies servicePolicies, RangerPolicyEngineOptions options) {
        this(appId, servicePolicies, options, null);
    }

    public RangerPolicyEngineImpl(String appId, ServicePolicies servicePolicies, RangerPolicyEngineOptions options, RangerPluginContext rangerPluginContext) {
        List<RangerContextEnricher> tmpList;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl(" + appId + ", " + servicePolicies + ", " + options + ", " + rangerPluginContext + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.init(appId=" + appId + ",hashCode=" + Integer.toHexString(System.identityHashCode(this)) + ")");
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug((Object)("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory));
        }
        if (options == null) {
            options = new RangerPolicyEngineOptions();
        }
        RangerPluginContext rangerPluginContext2 = this.rangerPluginContext = rangerPluginContext != null ? rangerPluginContext : null;
        if (StringUtils.isBlank((String)options.evaluatorType) || StringUtils.equalsIgnoreCase((String)options.evaluatorType, (String)"auto")) {
            String serviceType = servicePolicies.getServiceDef().getName();
            String propertyName = "ranger.plugin." + serviceType + ".policyengine.evaluator.auto.maximum.policycount.for.cache.type";
            int thresholdForUsingOptimizedEvaluator = RangerConfiguration.getInstance().getInt(propertyName, 100);
            int servicePoliciesCount = servicePolicies.getPolicies().size() + (servicePolicies.getTagPolicies() != null ? servicePolicies.getTagPolicies().getPolicies().size() : 0);
            options.evaluatorType = servicePoliciesCount > thresholdForUsingOptimizedEvaluator ? "optimized" : "cached";
        } else {
            options.evaluatorType = StringUtils.equalsIgnoreCase((String)options.evaluatorType, (String)"cached") ? "cached" : "optimized";
        }
        this.policyRepository = new RangerPolicyRepository(appId, servicePolicies, options);
        ServicePolicies.TagPolicies tagPolicies = servicePolicies.getTagPolicies();
        if (!(options.disableTagPolicyEvaluation || tagPolicies == null || StringUtils.isEmpty((String)tagPolicies.getServiceName()) || tagPolicies.getServiceDef() == null || CollectionUtils.isEmpty(tagPolicies.getPolicies()))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerPolicyEngineImpl : Building tag-policy-repository for tag-service " + tagPolicies.getServiceName()));
            }
            this.tagPolicyRepository = new RangerPolicyRepository(appId, tagPolicies, options, servicePolicies.getServiceDef(), servicePolicies.getServiceName());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerPolicyEngineImpl : No tag-policy-repository for service " + servicePolicies.getServiceName()));
            }
            this.tagPolicyRepository = null;
        }
        List<RangerContextEnricher> tagContextEnrichers = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getContextEnrichers();
        List<RangerContextEnricher> resourceContextEnrichers = this.policyRepository.getContextEnrichers();
        if (CollectionUtils.isEmpty(tagContextEnrichers)) {
            tmpList = resourceContextEnrichers;
        } else if (CollectionUtils.isEmpty(resourceContextEnrichers)) {
            tmpList = tagContextEnrichers;
        } else {
            tmpList = new ArrayList<RangerContextEnricher>(tagContextEnrichers);
            tmpList.addAll(resourceContextEnrichers);
        }
        this.allContextEnrichers = tmpList;
        if (MapUtils.isNotEmpty(servicePolicies.getSecurityZones())) {
            this.buildZoneTrie(servicePolicies);
            for (Map.Entry<String, ServicePolicies.SecurityZoneInfo> zone : servicePolicies.getSecurityZones().entrySet()) {
                RangerPolicyRepository policyRepository = new RangerPolicyRepository(appId, servicePolicies, options, zone.getKey());
                this.policyRepositories.put(zone.getKey(), policyRepository);
            }
        }
        this.userRoleMapping = MapUtils.isNotEmpty(servicePolicies.getUserRoles()) ? servicePolicies.getUserRoles() : null;
        this.groupRoleMapping = MapUtils.isNotEmpty(servicePolicies.getGroupRoles()) ? servicePolicies.getGroupRoles() : null;
        RangerPerfTracer.log(perf);
        if (PERF_POLICYENGINE_INIT_LOG.isDebugEnabled()) {
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug((Object)("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPolicyEngineImpl()");
        }
    }

    @Override
    public RangerPolicyEngine cloneWithDelta(ServicePolicies servicePolicies) {
        RangerServiceDef serviceDef;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> cloneWithDelta(" + Arrays.toString(servicePolicies.getPolicyDeltas().toArray()) + ", " + servicePolicies.getPolicyVersion() + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.cloneWithDelta()");
        }
        String serviceType = (serviceDef = this.getServiceDef()) != null ? serviceDef.getName() : "";
        RangerPolicyEngineImpl ret = CollectionUtils.isNotEmpty(servicePolicies.getPolicyDeltas()) && RangerPolicyDeltaUtil.isValidDeltas(servicePolicies.getPolicyDeltas(), serviceType) ? new RangerPolicyEngineImpl(this, servicePolicies, this.rangerPluginContext) : null;
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== cloneWithDelta(" + Arrays.toString(servicePolicies.getPolicyDeltas().toArray()) + ", " + servicePolicies.getPolicyVersion() + ")"));
        }
        return ret;
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RangerPolicyEngineImpl={");
        sb.append("serviceName={").append(this.getServiceName()).append("} ");
        sb.append(this.policyRepository);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void setUseForwardedIPAddress(boolean useForwardedIPAddress) {
        this.useForwardedIPAddress = useForwardedIPAddress;
    }

    @Override
    public void setTrustedProxyAddresses(String[] trustedProxyAddresses) {
        this.trustedProxyAddresses = trustedProxyAddresses;
    }

    @Override
    public boolean getUseForwardedIPAddress() {
        return this.useForwardedIPAddress;
    }

    @Override
    public String[] getTrustedProxyAddresses() {
        return this.trustedProxyAddresses;
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.policyRepository.getServiceDef();
    }

    @Override
    public long getPolicyVersion() {
        return this.policyRepository.getPolicyVersion();
    }

    @Override
    public void preProcess(RangerAccessRequest request) {
        List<RangerContextEnricher> enrichers;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.preProcess(" + request + ")"));
        }
        this.setResourceServiceDef(request);
        if (request instanceof RangerAccessRequestImpl) {
            RangerAccessRequestImpl reqImpl = (RangerAccessRequestImpl)request;
            reqImpl.extractAndSetClientIPAddress(this.useForwardedIPAddress, this.trustedProxyAddresses);
            if (this.rangerPluginContext != null) {
                reqImpl.setClusterName(this.rangerPluginContext.getClusterName());
                reqImpl.setClusterType(this.rangerPluginContext.getClusterType());
            }
        }
        RangerAccessRequestUtil.setCurrentUserInContext(request.getContext(), request.getUser());
        Set<String> roles = this.getRolesFromUserAndGroups(request.getUser(), request.getUserGroups());
        if (CollectionUtils.isNotEmpty(roles)) {
            RangerAccessRequestUtil.setCurrentUserRolesInContext(request.getContext(), roles);
        }
        if (!CollectionUtils.isEmpty(enrichers = this.allContextEnrichers)) {
            for (RangerContextEnricher enricher : enrichers) {
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_CONTEXTENRICHER_REQUEST_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_CONTEXTENRICHER_REQUEST_LOG, "RangerContextEnricher.enrich(requestHashCode=" + Integer.toHexString(System.identityHashCode(request)) + ", enricherName=" + enricher.getName() + ")");
                }
                enricher.enrich(request);
                RangerPerfTracer.log(perf);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.preProcess(" + request + ")"));
        }
    }

    @Override
    public void preProcess(Collection<RangerAccessRequest> requests) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.preProcess(" + requests + ")"));
        }
        if (CollectionUtils.isNotEmpty(requests)) {
            for (RangerAccessRequest request : requests) {
                this.preProcess(request);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.preProcess(" + requests + ")"));
        }
    }

    @Override
    public RangerAccessResult evaluatePolicies(RangerAccessRequest request, int policyType, RangerAccessResultProcessor resultProcessor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluatePolicies(" + request + ", policyType=" + policyType + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            String requestHashCode = Integer.toHexString(System.identityHashCode(request)) + "_" + Integer.toString(policyType);
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.evaluatePolicies(requestHashCode=" + requestHashCode + ")");
            LOG.info((Object)("RangerPolicyEngineImpl.evaluatePolicies(" + requestHashCode + ", " + request + ")"));
        }
        RangerAccessResult ret = this.zoneAwareAccessEvaluationWithNoAudit(request, policyType);
        this.updatePolicyUsageCounts(request, ret);
        if (resultProcessor != null) {
            RangerPerfTracer perfAuditTracer = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_AUDIT_LOG)) {
                String requestHashCode = Integer.toHexString(System.identityHashCode(request)) + "_" + Integer.toString(policyType);
                perfAuditTracer = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_AUDIT_LOG, "RangerPolicyEngine.processAudit(requestHashCode=" + requestHashCode + ")");
            }
            resultProcessor.processResult(ret);
            RangerPerfTracer.log(perfAuditTracer);
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluatePolicies(" + request + ", policyType=" + policyType + "): " + ret));
        }
        return ret;
    }

    @Override
    public Collection<RangerAccessResult> evaluatePolicies(Collection<RangerAccessRequest> requests, int policyType, RangerAccessResultProcessor resultProcessor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluatePolicies(" + requests + ", policyType=" + policyType + ")"));
        }
        ArrayList<RangerAccessResult> ret = new ArrayList<RangerAccessResult>();
        if (requests != null) {
            for (RangerAccessRequest request : requests) {
                RangerAccessResult result = this.zoneAwareAccessEvaluationWithNoAudit(request, policyType);
                ret.add(result);
            }
        }
        if (resultProcessor != null) {
            resultProcessor.processResults(ret);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluatePolicies(" + requests + ", policyType=" + policyType + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerResourceACLs getResourceACLs(RangerAccessRequest request) {
        List<PolicyEvaluatorForTag> tagPolicyEvaluators;
        String zoneName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getResourceACLs(request=" + request + ")"));
        }
        RangerResourceACLs ret = new RangerResourceACLs();
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_GET_ACLS_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_GET_ACLS_LOG, "RangerPolicyEngine.getResourceACLs(requestHashCode=" + request.getResource().getAsString() + ")");
        }
        String string = zoneName = this.trieMap == null ? null : this.getMatchedZoneName(request.getResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneName:[" + zoneName + "]"));
        }
        ArrayList<RangerPolicyRepository> matchedRepositories = new ArrayList<RangerPolicyRepository>();
        if (StringUtils.isNotEmpty((String)zoneName)) {
            RangerPolicyRepository policyRepository = this.policyRepositories.get(zoneName);
            if (policyRepository == null) {
                LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "] is null!! ERROR!"));
            } else {
                matchedRepositories.add(policyRepository);
            }
        } else {
            matchedRepositories.add(this.policyRepository);
            matchedRepositories.addAll(this.policyRepositories.values());
        }
        ArrayList<RangerPolicyEvaluator> allEvaluators = new ArrayList<RangerPolicyEvaluator>();
        HashMap<Long, RangerPolicyResourceMatcher.MatchType> tagMatchTypeMap = null;
        HashSet<Long> policyIdForTemporalTags = null;
        Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        List<PolicyEvaluatorForTag> list = tagPolicyEvaluators = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getLikelyMatchPolicyEvaluators(tags, 0, null);
        if (CollectionUtils.isNotEmpty(tagPolicyEvaluators)) {
            tagMatchTypeMap = new HashMap<Long, RangerPolicyResourceMatcher.MatchType>();
            for (PolicyEvaluatorForTag tagEvaluator : tagPolicyEvaluators) {
                RangerPolicyEvaluator evaluator = tagEvaluator.getEvaluator();
                RangerTagForEval tag = tagEvaluator.getTag();
                allEvaluators.add(evaluator);
                tagMatchTypeMap.put(evaluator.getId(), tag.getMatchType());
                if (!CollectionUtils.isNotEmpty(tag.getValidityPeriods())) continue;
                if (policyIdForTemporalTags == null) {
                    policyIdForTemporalTags = new HashSet<Long>();
                }
                policyIdForTemporalTags.add(evaluator.getId());
            }
        }
        for (RangerPolicyRepository policyRepository : matchedRepositories) {
            List<RangerPolicyEvaluator> resourcePolicyEvaluators = policyRepository.getLikelyMatchPolicyEvaluators(request.getResource(), 0);
            allEvaluators.addAll(resourcePolicyEvaluators);
        }
        allEvaluators.sort(RangerPolicyEvaluator.EVAL_ORDER_COMPARATOR);
        if (CollectionUtils.isNotEmpty(allEvaluators)) {
            Integer policyPriority = null;
            for (RangerPolicyEvaluator evaluator : allEvaluators) {
                RangerPolicy policy;
                Integer accessResult;
                RangerPolicyEvaluator.PolicyACLSummary aclSummary;
                boolean isMatched;
                RangerPolicyResourceMatcher.MatchType matchType;
                if (policyPriority == null) {
                    policyPriority = evaluator.getPolicyPriority();
                }
                if (policyPriority.intValue() != evaluator.getPolicyPriority()) {
                    ret.finalizeAcls();
                    policyPriority = evaluator.getPolicyPriority();
                }
                RangerPolicyResourceMatcher.MatchType matchType2 = matchType = tagMatchTypeMap != null ? (RangerPolicyResourceMatcher.MatchType)((Object)tagMatchTypeMap.get(evaluator.getId())) : null;
                if (matchType == null) {
                    matchType = evaluator.getPolicyResourceMatcher().getMatchType(request.getResource(), request.getContext());
                }
                if (request.getResourceMatchingScope() == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS) {
                    isMatched = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
                } else {
                    boolean bl = isMatched = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.ANCESTOR_WITH_WILDCARDS;
                }
                if (!isMatched || (aclSummary = evaluator.getPolicyACLSummary()) == null) continue;
                boolean isConditional = policyIdForTemporalTags != null && policyIdForTemporalTags.contains(evaluator.getId()) || evaluator.getValidityScheduleEvaluatorsCount() != 0;
                for (Map.Entry<String, Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult>> userAccessInfo : aclSummary.getUsersAccessInfo().entrySet()) {
                    String userName = userAccessInfo.getKey();
                    for (Map.Entry<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accessInfo : userAccessInfo.getValue().entrySet()) {
                        if (isConditional) {
                            accessResult = RangerPolicyEvaluator.ACCESS_CONDITIONAL;
                        } else {
                            accessResult = accessInfo.getValue().getResult();
                            if (accessResult.equals(RangerPolicyEvaluator.ACCESS_UNDETERMINED)) {
                                accessResult = RangerPolicyEvaluator.ACCESS_DENIED;
                            }
                        }
                        policy = evaluator.getPolicy();
                        ret.setUserAccessInfo(userName, accessInfo.getKey(), accessResult, policy);
                    }
                }
                for (Map.Entry<String, Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult>> groupAccessInfo : aclSummary.getGroupsAccessInfo().entrySet()) {
                    String groupName = groupAccessInfo.getKey();
                    for (Map.Entry<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accessInfo : groupAccessInfo.getValue().entrySet()) {
                        if (isConditional) {
                            accessResult = RangerPolicyEvaluator.ACCESS_CONDITIONAL;
                        } else {
                            accessResult = accessInfo.getValue().getResult();
                            if (accessResult.equals(RangerPolicyEvaluator.ACCESS_UNDETERMINED)) {
                                accessResult = RangerPolicyEvaluator.ACCESS_DENIED;
                            }
                        }
                        policy = evaluator.getPolicy();
                        ret.setGroupAccessInfo(groupName, accessInfo.getKey(), accessResult, policy);
                    }
                }
                for (Map.Entry<String, Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult>> roleAccessInfo : aclSummary.getRolesAccessInfo().entrySet()) {
                    String roleName = roleAccessInfo.getKey();
                    for (Map.Entry<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accessInfo : roleAccessInfo.getValue().entrySet()) {
                        if (isConditional) {
                            accessResult = RangerPolicyEvaluator.ACCESS_CONDITIONAL;
                        } else {
                            accessResult = accessInfo.getValue().getResult();
                            if (accessResult.equals(RangerPolicyEvaluator.ACCESS_UNDETERMINED)) {
                                accessResult = RangerPolicyEvaluator.ACCESS_DENIED;
                            }
                        }
                        policy = evaluator.getPolicy();
                        ret.setRoleAccessInfo(roleName, accessInfo.getKey(), accessResult, policy);
                    }
                }
            }
            ret.finalizeAcls();
        }
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getResourceACLs(request=" + request + ") : ret=" + ret));
        }
        return ret;
    }

    @Override
    public boolean preCleanup() {
        boolean ret = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPolicyEngineImpl.preCleanup()");
        }
        if (this.policyRepository != null && !this.isPolicyRepositoryShared) {
            this.policyRepository.preCleanup();
        }
        if (this.tagPolicyRepository != null && !this.isTagPolicyRepositoryShared) {
            this.tagPolicyRepository.preCleanup();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.preCleanup() : result=" + ret));
        }
        return ret;
    }

    @Override
    public void cleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPolicyEngineImpl.cleanup()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.cleanUp(hashCode=" + Integer.toHexString(System.identityHashCode(this)) + ")");
        }
        this.preCleanup();
        if (this.policyRepository != null && !this.isPolicyRepositoryShared) {
            this.policyRepository.cleanup();
        }
        if (this.tagPolicyRepository != null && !this.isTagPolicyRepositoryShared) {
            this.tagPolicyRepository.cleanup();
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPolicyEngineImpl.cleanup()");
        }
    }

    @Override
    public void reorderPolicyEvaluators() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> reorderEvaluators()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REBALANCE_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REBALANCE_LOG, "RangerPolicyEngine.reorderEvaluators()");
        }
        if (this.tagPolicyRepository != null && MapUtils.isNotEmpty(this.tagPolicyRepository.getPolicyEvaluatorsMap())) {
            for (Map.Entry<Long, RangerPolicyEvaluator> entry : this.tagPolicyRepository.getPolicyEvaluatorsMap().entrySet()) {
                entry.getValue().setUsageCountImmutable();
            }
        }
        if (this.policyRepository != null && MapUtils.isNotEmpty(this.policyRepository.getPolicyEvaluatorsMap())) {
            for (Map.Entry<Long, RangerPolicyEvaluator> entry : this.policyRepository.getPolicyEvaluatorsMap().entrySet()) {
                entry.getValue().setUsageCountImmutable();
            }
        }
        if (this.tagPolicyRepository != null) {
            this.tagPolicyRepository.reorderPolicyEvaluators();
        }
        if (this.policyRepository != null) {
            this.policyRepository.reorderPolicyEvaluators();
        }
        if (this.tagPolicyRepository != null && MapUtils.isNotEmpty(this.tagPolicyRepository.getPolicyEvaluatorsMap())) {
            for (Map.Entry<Long, RangerPolicyEvaluator> entry : this.tagPolicyRepository.getPolicyEvaluatorsMap().entrySet()) {
                entry.getValue().resetUsageCount();
            }
        }
        if (this.policyRepository != null && MapUtils.isNotEmpty(this.policyRepository.getPolicyEvaluatorsMap())) {
            for (Map.Entry<Long, RangerPolicyEvaluator> entry : this.policyRepository.getPolicyEvaluatorsMap().entrySet()) {
                entry.getValue().resetUsageCount();
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== reorderEvaluators()");
        }
    }

    @Override
    public boolean isAccessAllowed(RangerAccessResource resource, String user, Set<String> userGroups, String accessType) {
        String zoneName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.isAccessAllowed(" + resource + ", " + user + ", " + userGroups + ", " + accessType + ")"));
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.isAccessAllowed(user=" + user + ",accessType=" + accessType + "resource=" + resource.getAsString() + ")");
        }
        String string = zoneName = this.trieMap == null ? null : this.getMatchedZoneName(resource);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneName:[" + zoneName + "]"));
        }
        ArrayList<RangerPolicyRepository> matchedRepositories = new ArrayList<RangerPolicyRepository>();
        if (StringUtils.isNotEmpty((String)zoneName)) {
            RangerPolicyRepository policyRepository = this.policyRepositories.get(zoneName);
            if (policyRepository == null) {
                LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "] is null!! ERROR!"));
            } else {
                matchedRepositories.add(policyRepository);
            }
        } else {
            matchedRepositories.add(this.policyRepository);
        }
        Set<String> roles = this.getRolesFromUserAndGroups(user, userGroups);
        for (RangerPolicyRepository policyRepository : matchedRepositories) {
            RangerPolicyEvaluator evaluator;
            Iterator<RangerPolicyEvaluator> iterator = policyRepository.getLikelyMatchPolicyEvaluators(resource, 0).iterator();
            while (iterator.hasNext() && !(ret = (evaluator = iterator.next()).isAccessAllowed(resource, user, userGroups, roles, accessType))) {
            }
            if (!ret) continue;
            break;
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.isAccessAllowed(" + resource + ", " + user + ", " + userGroups + ", " + accessType + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(RangerPolicy policy, String user, Set<String> userGroups, String accessType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.isAccessAllowed(" + policy.getId() + ", " + user + ", " + userGroups + ", " + accessType + ")"));
        }
        boolean ret = this.isAccessAllowed(policy, user, userGroups, null, accessType);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.isAccessAllowed(" + policy.getId() + ", " + user + ", " + userGroups + ", " + accessType + ") : " + ret));
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(RangerPolicy policy, String user, Set<String> userGroups, Set<String> roles, String accessType) {
        String zoneName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.isAccessAllowed(" + policy.getId() + ", " + user + ", " + userGroups + ", " + roles + ", " + accessType + ")"));
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.isAccessAllowed(user=" + user + "," + userGroups + ", roles=" + roles + ",accessType=" + accessType + ")");
        }
        String string = zoneName = this.trieMap == null ? null : policy.getZoneName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneName:[" + zoneName + "]"));
        }
        ArrayList<RangerPolicyRepository> matchedRepositories = new ArrayList<RangerPolicyRepository>();
        if (StringUtils.isNotEmpty((String)zoneName)) {
            RangerPolicyRepository policyRepository = this.policyRepositories.get(zoneName);
            if (policyRepository == null) {
                LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "] is null!! ERROR!"));
            } else {
                matchedRepositories.add(policyRepository);
            }
        } else {
            matchedRepositories.add(this.policyRepository);
        }
        for (RangerPolicyRepository policyRepository : matchedRepositories) {
            RangerPolicyEvaluator evaluator;
            Iterator<RangerPolicyEvaluator> iterator = policyRepository.getPolicyEvaluators().iterator();
            while (iterator.hasNext() && !(ret = (evaluator = iterator.next()).isAccessAllowed(policy, user, userGroups, roles, accessType))) {
            }
            if (!ret) continue;
            break;
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.isAccessAllowed(" + policy.getId() + ", " + user + ", " + userGroups + ", " + roles + ", " + accessType + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getExactMatchPolicies(RangerAccessResource resource, Map<String, Object> evalContext) {
        String zoneName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getExactMatchPolicies(" + resource + ", " + evalContext + ")"));
        }
        ArrayList<RangerPolicy> ret = null;
        RangerPolicyRepository policyRepository = this.policyRepository;
        String string = zoneName = this.trieMap == null ? null : this.getMatchedZoneName(resource);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneName:[" + zoneName + "]"));
        }
        if (StringUtils.isNotEmpty((String)zoneName) && (policyRepository = this.policyRepositories.get(zoneName)) == null) {
            LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "] is null!! ERROR!"));
        }
        if (policyRepository != null) {
            for (RangerPolicyEvaluator evaluator : policyRepository.getPolicyEvaluators()) {
                if (!evaluator.isCompleteMatch(resource, evalContext)) continue;
                if (ret == null) {
                    ret = new ArrayList<RangerPolicy>();
                }
                ret.add(evaluator.getPolicy());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getExactMatchPolicies(" + resource + ", " + evalContext + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getExactMatchPolicies(RangerPolicy policy, Map<String, Object> evalContext) {
        String zoneName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getExactMatchPolicies(" + policy + ", " + evalContext + ")"));
        }
        ArrayList<RangerPolicy> ret = null;
        RangerPolicyRepository policyRepository = this.policyRepository;
        String string = zoneName = this.trieMap == null ? null : policy.getZoneName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneName:[" + zoneName + "]"));
        }
        if (StringUtils.isNotEmpty((String)zoneName) && (policyRepository = this.policyRepositories.get(zoneName)) == null) {
            LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "] is null!! ERROR!"));
        }
        if (policyRepository != null) {
            Map<String, RangerPolicy.RangerPolicyResource> resources = policy.getResources();
            for (RangerPolicyEvaluator evaluator : policyRepository.getPolicyEvaluators()) {
                if (!evaluator.isCompleteMatch(resources, evalContext)) continue;
                if (ret == null) {
                    ret = new ArrayList<RangerPolicy>();
                }
                ret.add(evaluator.getPolicy());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getExactMatchPolicies(" + policy + ", " + evalContext + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getMatchingPolicies(RangerAccessResource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getMatchingPolicies(" + resource + ")"));
        }
        RangerAccessRequestImpl request = new RangerAccessRequestImpl(resource, "_any", null, null);
        this.preProcess(request);
        List<RangerPolicy> ret = this.getMatchingPolicies(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getMatchingPolicies(" + resource + ") : " + ret.size()));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getMatchingPolicies(RangerAccessRequest request) {
        Set<RangerTagForEval> tags;
        String zoneName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getMatchingPolicies(" + request + ")"));
        }
        ArrayList<RangerPolicy> ret = new ArrayList<RangerPolicy>();
        String string = zoneName = this.trieMap == null ? null : this.getMatchedZoneName(request.getResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneName:[" + zoneName + "]"));
        }
        ArrayList<RangerPolicyRepository> matchedRepositories = new ArrayList<RangerPolicyRepository>();
        if (StringUtils.isNotEmpty((String)zoneName)) {
            RangerPolicyRepository policyRepository = this.policyRepositories.get(zoneName);
            if (policyRepository == null) {
                LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "] is null!! ERROR!"));
            } else {
                matchedRepositories.add(policyRepository);
            }
        } else {
            matchedRepositories.add(this.policyRepository);
            matchedRepositories.addAll(this.policyRepositories.values());
        }
        if (this.hasTagPolicies(this.tagPolicyRepository) && CollectionUtils.isNotEmpty(tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext()))) {
            for (RangerTagForEval tag : tags) {
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, this.tagPolicyRepository.getServiceDef(), request);
                RangerAccessResource tagResource = tagEvalRequest.getResource();
                List<RangerPolicyEvaluator> likelyEvaluators = this.tagPolicyRepository.getLikelyMatchPolicyEvaluators(tagResource);
                for (RangerPolicyEvaluator evaluator : likelyEvaluators) {
                    RangerPolicyResourceMatcher matcher = evaluator.getPolicyResourceMatcher();
                    if (matcher == null || !(request.isAccessTypeAny() ? matcher.isMatch(tagResource, RangerPolicyResourceMatcher.MatchScope.ANY, null) : matcher.isMatch(tagResource, null))) continue;
                    ret.add(evaluator.getPolicy());
                }
            }
        }
        for (RangerPolicyRepository policyRepository : matchedRepositories) {
            if (!this.hasResourcePolicies(policyRepository)) continue;
            List<RangerPolicyEvaluator> likelyEvaluators = policyRepository.getLikelyMatchPolicyEvaluators(request.getResource());
            for (RangerPolicyEvaluator evaluator : likelyEvaluators) {
                RangerPolicyResourceMatcher matcher = evaluator.getPolicyResourceMatcher();
                if (matcher == null || !(request.isAccessTypeAny() ? matcher.isMatch(request.getResource(), RangerPolicyResourceMatcher.MatchScope.ANY, null) : matcher.isMatch(request.getResource(), null))) continue;
                ret.add(evaluator.getPolicy());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getMatchingPolicies(" + request + ") : " + ret.size()));
        }
        return ret;
    }

    @Override
    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest request) {
        Set<RangerTagForEval> tags;
        List<RangerPolicyEvaluator> tagPolicyEvaluators;
        String zoneName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getResourceAccessInfo(" + request + ")"));
        }
        RangerResourceAccessInfo ret = new RangerResourceAccessInfo(request);
        String string = zoneName = this.trieMap == null ? null : this.getMatchedZoneName(request.getResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneName:[" + zoneName + "]"));
        }
        ArrayList<RangerPolicyRepository> matchedRepositories = new ArrayList<RangerPolicyRepository>();
        if (StringUtils.isNotEmpty((String)zoneName)) {
            RangerPolicyRepository policyRepository = this.policyRepositories.get(zoneName);
            if (policyRepository == null) {
                LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "] is null!! ERROR!"));
            } else {
                matchedRepositories.add(policyRepository);
            }
        } else {
            matchedRepositories.add(this.policyRepository);
            matchedRepositories.addAll(this.policyRepositories.values());
        }
        List<RangerPolicyEvaluator> list = tagPolicyEvaluators = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getPolicyEvaluators();
        if (CollectionUtils.isNotEmpty(tagPolicyEvaluators) && CollectionUtils.isNotEmpty(tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext()))) {
            for (RangerTagForEval tag : tags) {
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, this.tagPolicyRepository.getServiceDef(), request);
                List<RangerPolicyEvaluator> evaluators = this.tagPolicyRepository.getLikelyMatchPolicyEvaluators(tagEvalRequest.getResource(), 0);
                for (RangerPolicyEvaluator evaluator : evaluators) {
                    evaluator.getResourceAccessInfo(tagEvalRequest, ret);
                }
            }
        }
        for (RangerPolicyRepository policyRepository : matchedRepositories) {
            List<RangerPolicyEvaluator> resPolicyEvaluators = policyRepository.getLikelyMatchPolicyEvaluators(request.getResource(), 0);
            if (CollectionUtils.isNotEmpty(resPolicyEvaluators)) {
                for (RangerPolicyEvaluator evaluator : resPolicyEvaluators) {
                    evaluator.getResourceAccessInfo(request, ret);
                }
            }
            ret.getAllowedUsers().removeAll(ret.getDeniedUsers());
            ret.getAllowedGroups().removeAll(ret.getDeniedGroups());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getResourceAccessInfo(" + request + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(Map<String, RangerPolicy.RangerPolicyResource> resources, String user, Set<String> userGroups, String accessType) {
        RangerPolicyEvaluator evaluator;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.isAccessAllowed(" + resources + ", " + user + ", " + userGroups + ", " + accessType + ")"));
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.isAccessAllowed(user=" + user + "," + userGroups + ",accessType=" + accessType + ")");
        }
        Iterator<RangerPolicyEvaluator> iterator = this.policyRepository.getPolicyEvaluators().iterator();
        while (iterator.hasNext() && !(ret = (evaluator = iterator.next()).isAccessAllowed(resources, user, userGroups, accessType))) {
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.isAccessAllowed(" + resources + ", " + user + ", " + userGroups + ", " + accessType + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getAllowedPolicies(String user, Set<String> userGroups, String accessType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getAllowedPolicies(" + user + ", " + userGroups + ", " + accessType + ")"));
        }
        ArrayList<RangerPolicy> ret = new ArrayList<RangerPolicy>();
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getPolicyEvaluators()) {
            RangerPolicy policy = evaluator.getPolicy();
            boolean isAccessAllowed = this.isAccessAllowed(policy.getResources(), user, userGroups, accessType);
            if (!isAccessAllowed) continue;
            ret.add(policy);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getAllowedPolicies(" + user + ", " + userGroups + ", " + accessType + "): policyCount=" + ret.size()));
        }
        return ret;
    }

    @Override
    public Set<String> getRolesFromUserAndGroups(String user, Set<String> groups) {
        Object userRoles;
        HashSet<String> allRoles = new HashSet<String>();
        if (MapUtils.isNotEmpty(this.userRoleMapping) && StringUtils.isNotEmpty((String)user) && CollectionUtils.isNotEmpty(userRoles = this.userRoleMapping.get(user))) {
            allRoles.addAll((Collection<String>)userRoles);
        }
        if (MapUtils.isNotEmpty(this.groupRoleMapping)) {
            Set<String> publicGroupRoles;
            if (CollectionUtils.isNotEmpty(groups)) {
                for (String group : groups) {
                    Set<String> groupRoles = this.groupRoleMapping.get(group);
                    if (!CollectionUtils.isNotEmpty(groupRoles)) continue;
                    allRoles.addAll(groupRoles);
                }
            }
            if (CollectionUtils.isNotEmpty(publicGroupRoles = this.groupRoleMapping.get("public"))) {
                allRoles.addAll(publicGroupRoles);
            }
        }
        return allRoles;
    }

    public List<RangerPolicy> getResourcePolicies(String zoneName) {
        RangerPolicyRepository zoneResourceRepository = this.policyRepositories.get(zoneName);
        return zoneResourceRepository == null ? ListUtils.EMPTY_LIST : zoneResourceRepository.getPolicies();
    }

    public List<RangerPolicy> getResourcePolicies() {
        return this.policyRepository == null ? ListUtils.EMPTY_LIST : this.policyRepository.getPolicies();
    }

    public List<RangerPolicy> getTagPolicies() {
        return this.tagPolicyRepository == null ? ListUtils.EMPTY_LIST : this.tagPolicyRepository.getPolicies();
    }

    private RangerAccessResult zoneAwareAccessEvaluationWithNoAudit(RangerAccessRequest request, int policyType) {
        String zoneName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.zoneAwareAccessEvaluationWithNoAudit(" + request + ", policyType =" + policyType + ")"));
        }
        RangerAccessResult ret = null;
        RangerPolicyRepository policyRepository = this.policyRepository;
        RangerPolicyRepository tagPolicyRepository = this.tagPolicyRepository;
        String string = zoneName = this.trieMap == null ? null : this.getMatchedZoneName(request.getResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneName:[" + zoneName + "]"));
        }
        if (StringUtils.isNotEmpty((String)zoneName) && (policyRepository = this.policyRepositories.get(zoneName)) == null) {
            LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "] is null!! ERROR!"));
        }
        if (policyRepository != null) {
            ret = this.evaluatePoliciesNoAudit(request, policyType, zoneName, policyRepository, tagPolicyRepository);
            ret.setZoneName(zoneName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.zoneAwareAccessEvaluationWithNoAudit(" + request + ", policyType =" + policyType + "): " + ret));
        }
        return ret;
    }

    private RangerAccessResult evaluatePoliciesNoAudit(RangerAccessRequest request, int policyType, String zoneName, RangerPolicyRepository policyRepository, RangerPolicyRepository tagPolicyRepository) {
        Date accessTime;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluatePoliciesNoAudit(" + request + ", policyType =" + policyType + ", zoneName=" + zoneName + ")"));
        }
        RangerAccessResult ret = this.createAccessResult(request, policyType);
        Date date = accessTime = request.getAccessTime() != null ? request.getAccessTime() : new Date();
        if (ret != null && request != null) {
            this.evaluateTagPolicies(request, policyType, zoneName, tagPolicyRepository, ret);
            if (LOG.isDebugEnabled() && ret.getIsAccessDetermined() && ret.getIsAuditedDetermined()) {
                if (!ret.getIsAllowed()) {
                    LOG.debug((Object)("RangerPolicyEngineImpl.evaluatePoliciesNoAudit() - audit determined and access denied by a tag policy. Higher priority resource policies will be evaluated to check for allow, request=" + request + ", result=" + ret));
                } else {
                    LOG.debug((Object)("RangerPolicyEngineImpl.evaluatePoliciesNoAudit() - audit determined and access allowed by a tag policy. Same or higher priority resource policies will be evaluated to check for deny, request=" + request + ", result=" + ret));
                }
            }
            boolean isAllowedByTags = ret.getIsAccessDetermined() && ret.getIsAllowed();
            boolean isDeniedByTags = ret.getIsAccessDetermined() && !ret.getIsAllowed();
            boolean evaluateResourcePolicies = this.hasResourcePolicies(policyRepository);
            if (evaluateResourcePolicies) {
                boolean findAuditByResource = !ret.getIsAuditedDetermined();
                boolean foundInCache = findAuditByResource && policyRepository.setAuditEnabledFromCache(request, ret);
                ret.setIsAccessDetermined(false);
                List<RangerPolicyEvaluator> evaluators = policyRepository.getLikelyMatchPolicyEvaluators(request.getResource(), policyType);
                for (RangerPolicyEvaluator evaluator : evaluators) {
                    if (!evaluator.isApplicable(accessTime)) continue;
                    if (isDeniedByTags) {
                        if (ret.getPolicyPriority() >= evaluator.getPolicyPriority()) {
                            ret.setIsAccessDetermined(true);
                        }
                    } else if (isAllowedByTags && ret.getPolicyPriority() > evaluator.getPolicyPriority()) {
                        ret.setIsAccessDetermined(true);
                    }
                    ret.incrementEvaluatedPoliciesCount();
                    evaluator.evaluate(request, ret);
                    if (ret.getIsAllowed() && !evaluator.hasDeny()) {
                        ret.setIsAccessDetermined(true);
                    }
                    if (!ret.getIsAuditedDetermined() || !ret.getIsAccessDetermined()) continue;
                    break;
                }
                if (!ret.getIsAccessDetermined()) {
                    if (isDeniedByTags) {
                        ret.setIsAllowed(false);
                    } else if (isAllowedByTags) {
                        ret.setIsAllowed(true);
                    }
                }
                if (ret.getIsAllowed()) {
                    ret.setIsAccessDetermined(true);
                }
                if (findAuditByResource && !foundInCache) {
                    policyRepository.storeAuditEnabledInCache(request, ret);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluatePoliciesNoAudit(" + request + ", policyType =" + policyType + ", zoneName=" + zoneName + "): " + ret));
        }
        return ret;
    }

    private void evaluateTagPolicies(RangerAccessRequest request, int policyType, String zoneName, RangerPolicyRepository tagPolicyRepository, RangerAccessResult result) {
        List<PolicyEvaluatorForTag> policyEvaluators;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluateTagPolicies(" + request + ", policyType =" + policyType + ", zoneName=" + zoneName + ", " + result + ")"));
        }
        if (StringUtils.isNotEmpty((String)zoneName) && tagPolicyRepository != null && (this.zoneTagServiceMap == null || this.zoneTagServiceMap.get(zoneName) == null)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Accessed resource is in a zone:[" + zoneName + "] which is not associated with the tag-service:[" + tagPolicyRepository.getServiceName() + "]. Evaluating unzoned tag policies of this service"));
            }
            zoneName = null;
        }
        Date accessTime = request.getAccessTime() != null ? request.getAccessTime() : new Date();
        Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        List<PolicyEvaluatorForTag> list = policyEvaluators = tagPolicyRepository == null ? null : tagPolicyRepository.getLikelyMatchPolicyEvaluators(tags, policyType, accessTime);
        if (CollectionUtils.isNotEmpty(policyEvaluators)) {
            for (PolicyEvaluatorForTag policyEvaluator : policyEvaluators) {
                RangerPolicyEvaluator evaluator = policyEvaluator.getEvaluator();
                String policyZoneName = evaluator.getPolicy().getZoneName();
                if (!(StringUtils.isEmpty((String)policyZoneName) && StringUtils.isEmpty((String)zoneName) || StringUtils.equals((String)zoneName, (String)policyZoneName))) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to the zone:[" + zoneName + "] of the accessed resource. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                    continue;
                }
                RangerTagForEval tag = policyEvaluator.getTag();
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, tagPolicyRepository.getServiceDef(), request);
                RangerAccessResult tagEvalResult = this.createAccessResult(tagEvalRequest, policyType);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RangerPolicyEngineImpl.evaluateTagPolicies: Evaluating policies for tag (" + tag.getType() + ")"));
                }
                tagEvalResult.setAccessResultFrom(result);
                tagEvalResult.setAuditResultFrom(result);
                result.incrementEvaluatedPoliciesCount();
                evaluator.evaluate(tagEvalRequest, tagEvalResult);
                if (tagEvalResult.getIsAllowed() && !evaluator.hasDeny()) {
                    tagEvalResult.setIsAccessDetermined(true);
                }
                if (tagEvalResult.getIsAudited()) {
                    result.setAuditResultFrom(tagEvalResult);
                }
                if (!result.getIsAccessDetermined()) {
                    if (tagEvalResult.getIsAccessDetermined()) {
                        result.setAccessResultFrom(tagEvalResult);
                    } else if (!result.getIsAllowed() && tagEvalResult.getIsAllowed()) {
                        result.setAccessResultFrom(tagEvalResult);
                    }
                }
                if (!result.getIsAuditedDetermined() || !result.getIsAccessDetermined()) continue;
                break;
            }
        }
        if (result.getIsAllowed()) {
            result.setIsAccessDetermined(true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluateTagPolicies(" + request + ", policyType =" + policyType + ", zoneName=" + zoneName + ", " + result + ")"));
        }
    }

    private String getServiceName() {
        return this.policyRepository.getServiceName();
    }

    private RangerPolicyEvaluator getPolicyEvaluator(Long id) {
        RangerPolicyEvaluator ret = this.policyRepository.getPolicyEvaluator(id);
        if (ret == null && this.tagPolicyRepository != null) {
            ret = this.tagPolicyRepository.getPolicyEvaluator(id);
        }
        return ret;
    }

    private RangerAccessResult createAccessResult(RangerAccessRequest request, int policyType) {
        RangerAccessResult ret = new RangerAccessResult(policyType, this.getServiceName(), this.policyRepository.getServiceDef(), request);
        switch (this.policyRepository.getAuditModeEnum()) {
            case AUDIT_ALL: {
                ret.setIsAudited(true);
                break;
            }
            case AUDIT_NONE: {
                ret.setIsAudited(false);
                break;
            }
            default: {
                if (!CollectionUtils.isEmpty(this.policyRepository.getPolicies()) || this.tagPolicyRepository != null) break;
                ret.setIsAudited(true);
            }
        }
        return ret;
    }

    private void setResourceServiceDef(RangerAccessRequest request) {
        RangerAccessResource resource = request.getResource();
        if (resource.getServiceDef() == null) {
            if (resource instanceof RangerMutableResource) {
                RangerMutableResource mutable = (RangerMutableResource)resource;
                mutable.setServiceDef(this.getServiceDef());
            } else {
                LOG.debug((Object)"RangerPolicyEngineImpl.setResourceServiceDef(): Cannot set ServiceDef in RangerMutableResource.");
            }
        }
    }

    private boolean hasTagPolicies(RangerPolicyRepository tagPolicyRepository) {
        return tagPolicyRepository != null && CollectionUtils.isNotEmpty(tagPolicyRepository.getPolicies());
    }

    private boolean hasResourcePolicies(RangerPolicyRepository policyRepository) {
        return policyRepository != null && CollectionUtils.isNotEmpty(policyRepository.getPolicies());
    }

    private void updatePolicyUsageCounts(RangerAccessRequest accessRequest, RangerAccessResult accessResult) {
        RangerPolicyEvaluator accessPolicy;
        boolean auditCountUpdated = false;
        if (accessResult.getIsAccessDetermined() && (accessPolicy = this.getPolicyEvaluator(accessResult.getPolicyId())) != null) {
            if (accessPolicy.getPolicy().getIsAuditEnabled().booleanValue()) {
                this.updateUsageCount(accessPolicy, 2);
                accessResult.setAuditPolicyId(accessResult.getPolicyId());
                auditCountUpdated = true;
            } else {
                this.updateUsageCount(accessPolicy, 1);
            }
        }
        if (!auditCountUpdated && accessResult.getIsAuditedDetermined()) {
            long auditPolicyId = accessResult.getAuditPolicyId();
            RangerPolicyEvaluator auditPolicy = auditPolicyId == -1L ? null : this.getPolicyEvaluator(auditPolicyId);
            this.updateUsageCount(auditPolicy, 1);
        }
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_USAGE_LOG)) {
            RangerAccessRequestImpl rangerAccessRequest = (RangerAccessRequestImpl)accessRequest;
            RangerPerfTracer perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_USAGE_LOG, "RangerPolicyEngine.usage(accessingUser=" + rangerAccessRequest.getUser() + ",accessedResource=" + rangerAccessRequest.getResource().getAsString() + ",accessType=" + rangerAccessRequest.getAccessType() + ",evaluatedPoliciesCount=" + accessResult.getEvaluatedPoliciesCount() + ")");
            RangerPerfTracer.logAlways(perf);
        }
    }

    private void updateUsageCount(RangerPolicyEvaluator evaluator, int number) {
        if (evaluator != null) {
            evaluator.incrementUsageCount(number);
        }
    }

    private void buildZoneTrie(ServicePolicies servicePolicies) {
        Map<String, ServicePolicies.SecurityZoneInfo> securityZones;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPolicyEngineImpl.buildZoneTrie()");
        }
        if (MapUtils.isNotEmpty(securityZones = servicePolicies.getSecurityZones())) {
            RangerServiceDef serviceDef = servicePolicies.getServiceDef();
            ArrayList<RangerZoneResourceMatcher> matchers = new ArrayList<RangerZoneResourceMatcher>();
            this.zoneTagServiceMap = new HashMap<String, String>();
            for (Map.Entry<String, ServicePolicies.SecurityZoneInfo> securityZone : securityZones.entrySet()) {
                String zoneName = securityZone.getKey();
                ServicePolicies.SecurityZoneInfo zoneDetails = securityZone.getValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Building matchers for zone:[" + zoneName + "]"));
                }
                for (Map map : zoneDetails.getResources()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Building matcher for resource:[" + map + "] in zone:[" + zoneName + "]"));
                    }
                    HashMap<String, RangerPolicy.RangerPolicyResource> policyResources = new HashMap<String, RangerPolicy.RangerPolicyResource>();
                    for (Map.Entry entry : map.entrySet()) {
                        String resourceDefName = (String)entry.getKey();
                        List resourceValues = (List)entry.getValue();
                        RangerPolicy.RangerPolicyResource policyResource = new RangerPolicy.RangerPolicyResource();
                        policyResource.setIsExcludes(false);
                        policyResource.setIsRecursive(StringUtils.equals((String)serviceDef.getName(), (String)"hdfs"));
                        policyResource.setValues(resourceValues);
                        policyResources.put(resourceDefName, policyResource);
                    }
                    matchers.add(new RangerZoneResourceMatcher(zoneName, policyResources, serviceDef));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Built matcher for resource:[" + map + "] in zone:[" + zoneName + "]"));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Built all matchers for zone:[" + zoneName + "]"));
                }
                if (!zoneDetails.getContainsAssociatedTagService().booleanValue()) continue;
                this.zoneTagServiceMap.put(zoneName, zoneName);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Built matchers for all Zones");
            }
            this.trieMap = new HashMap<String, RangerResourceTrie>();
            for (RangerServiceDef.RangerResourceDef resourceDef : serviceDef.getResources()) {
                this.trieMap.put(resourceDef.getName(), new RangerResourceTrie(resourceDef, matchers));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPolicyEngineImpl.buildZoneTrie()");
        }
    }

    @Override
    public String getMatchedZoneName(GrantRevokeRequest grantRevokeRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getMatchedZoneName(" + grantRevokeRequest + ")"));
        }
        String ret = null;
        if (this.trieMap != null) {
            Map<String, String> resource = grantRevokeRequest.getResource();
            Map<String, List<String>> resourceForZoneMatch = RangerPolicyEngineImpl.convertFromSingleResource(resource);
            RangerAccessResource accessResource = this.convertToAccessResource(resource);
            ret = this.getMatchedZoneName(resourceForZoneMatch, accessResource);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getMatchedZoneName(" + grantRevokeRequest + ") : " + ret));
        }
        return ret;
    }

    private String getMatchedZoneName(RangerAccessResource accessResource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getMatchedZoneName(" + accessResource + ")"));
        }
        String ret = null;
        if (this.trieMap != null) {
            Map<String, List<String>> resource = RangerPolicyEngineImpl.convertFromAccessResource(accessResource);
            ret = this.getMatchedZoneName(resource, accessResource);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getMatchedZoneName(" + accessResource + ") : " + ret));
        }
        return ret;
    }

    private String getMatchedZoneName(Map<String, List<String>> resource, RangerAccessResource accessResource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getMatchedZoneName(" + resource + ", " + accessResource + ")"));
        }
        String ret = null;
        if (this.trieMap != null) {
            ArrayList zoneMatchersList = null;
            List<Object> smallestList = null;
            for (Map.Entry<String, List<String>> entry : resource.entrySet()) {
                String string = entry.getKey();
                List<String> resourceValues = entry.getValue();
                RangerResourceTrie trie = this.trieMap.get(string);
                if (trie == null) continue;
                List matchedZones = trie.getEvaluatorsForResource(resourceValues);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ResourceDefName:[" + string + "], values:[" + resourceValues + "], matched-zones:[" + matchedZones + "]"));
                }
                if (CollectionUtils.isEmpty(matchedZones)) {
                    zoneMatchersList = null;
                    smallestList = null;
                    break;
                }
                if (smallestList == null) {
                    smallestList = matchedZones;
                    continue;
                }
                if (zoneMatchersList == null) {
                    zoneMatchersList = new ArrayList();
                    zoneMatchersList.add(smallestList);
                }
                zoneMatchersList.add(matchedZones);
                if (smallestList.size() <= matchedZones.size()) continue;
                smallestList = matchedZones;
            }
            if (smallestList != null) {
                ArrayList intersection;
                if (zoneMatchersList != null) {
                    intersection = new ArrayList(smallestList);
                    for (List list : zoneMatchersList) {
                        if (list == smallestList) continue;
                        intersection.retainAll(list);
                        if (!CollectionUtils.isEmpty(intersection)) continue;
                        break;
                    }
                } else {
                    intersection = smallestList;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Resource:[" + resource + "], matched-zones:[" + intersection + "]"));
                }
                if (intersection.size() > 0) {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (RangerZoneResourceMatcher zoneMatcher : intersection) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Trying to match resource:[" + accessResource + "] using zoneMatcher:[" + zoneMatcher + "]"));
                        }
                        if (zoneMatcher.getPolicyResourceMatcher().isMatch(accessResource, RangerPolicyResourceMatcher.MatchScope.ANY, null)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Matched resource:[" + accessResource + "] using zoneMatcher:[" + zoneMatcher + "]"));
                            }
                            hashSet.add(zoneMatcher.getSecurityZoneName());
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Did not match resource:[" + accessResource + "] using zoneMatcher:[" + zoneMatcher + "]"));
                    }
                    LOG.info((Object)("The following zone-names matched resource:[" + accessResource + "]: " + hashSet));
                    if (hashSet.size() == 1) {
                        String[] stringArray = new String[1];
                        hashSet.toArray(stringArray);
                        ret = stringArray[0];
                    } else {
                        LOG.error((Object)("Internal error, multiple zone-names are matched. The following zone-names matched resource:[" + resource + "]: " + hashSet));
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getMatchedZoneName(" + resource + ", " + accessResource + ") : " + ret));
        }
        return ret;
    }

    private static Map<String, List<String>> convertFromAccessResource(RangerAccessResource accessResource) {
        return RangerPolicyEngineImpl.convertFromSingleResource(accessResource.getAsMap());
    }

    private static Map<String, List<String>> convertFromSingleResource(Map<String, ? extends Object> resource) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (Map.Entry<String, ? extends Object> entry : resource.entrySet()) {
            ArrayList<String> value;
            if (entry.getValue() instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue()))) {
                value = new ArrayList((Collection)entry.getValue());
            } else if (entry.getValue() instanceof String) {
                value = new ArrayList<String>();
                value.add((String)entry.getValue());
            } else {
                LOG.error((Object)("access-resource contains value of unknown type : [" + entry.getValue().getClass().getCanonicalName() + "]"));
                value = new ArrayList();
            }
            ret.put(entry.getKey(), value);
        }
        return ret;
    }

    private RangerAccessResource convertToAccessResource(Map<String, ? extends Object> resource) {
        RangerAccessResourceImpl ret = new RangerAccessResourceImpl();
        ret.setServiceDef(this.getServiceDef());
        for (Map.Entry<String, ? extends Object> entry : resource.entrySet()) {
            ret.setValue(entry.getKey(), entry.getValue());
        }
        return ret;
    }
}

