/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPolicyDelta;
import org.apache.ranger.plugin.model.RangerSecurityZone;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineImpl;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.store.SecurityZoneStore;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerPolicyEngineCache {
    private static final Log LOG = LogFactory.getLog(RangerPolicyEngineCache.class);
    private final Map<String, RangerPolicyEngine> policyEngineCache = new HashMap<String, RangerPolicyEngine>();

    final synchronized RangerPolicyEngine getPolicyEngine(String serviceName, ServiceStore svcStore, SecurityZoneStore zoneStore, RangerPolicyEngineOptions options) {
        RangerPolicyEngine ret = null;
        if (serviceName != null) {
            long policyVersion;
            ret = this.policyEngineCache.get(serviceName);
            long l = policyVersion = ret != null ? ret.getPolicyVersion() : -1L;
            if (svcStore != null) {
                try {
                    ServicePolicies policies = svcStore.getServicePoliciesIfUpdated(serviceName, policyVersion, false);
                    if (policies != null && policies.getPolicyVersion() != null && !policies.getPolicyVersion().equals(policyVersion)) {
                        Map<String, RangerSecurityZone.RangerSecurityZoneService> securityZones;
                        ServicePolicies updatedServicePolicies = policies;
                        if (zoneStore != null && MapUtils.isNotEmpty(securityZones = zoneStore.getSecurityZonesForService(serviceName))) {
                            updatedServicePolicies = RangerPolicyEngineCache.getUpdatedServicePoliciesForZones(policies, securityZones);
                        }
                        ret = ret == null ? this.addPolicyEngine(updatedServicePolicies, options) : this.updatePolicyEngine(ret, updatedServicePolicies, options);
                    }
                }
                catch (Exception excp) {
                    LOG.error((Object)("getPolicyEngine(" + serviceName + "): failed to get latest policies from service-store"), (Throwable)excp);
                }
            }
        }
        return ret;
    }

    private RangerPolicyEngine addPolicyEngine(ServicePolicies policies, RangerPolicyEngineOptions options) {
        RangerServiceDef serviceDef = policies.getServiceDef();
        String serviceType = serviceDef != null ? serviceDef.getName() : "";
        RangerPluginContext rangerPluginContext = new RangerPluginContext(serviceType);
        RangerPolicyEngineImpl ret = new RangerPolicyEngineImpl("ranger-admin", policies, options, rangerPluginContext);
        this.policyEngineCache.put(policies.getServiceName(), ret);
        return ret;
    }

    private RangerPolicyEngine updatePolicyEngine(RangerPolicyEngine policyEngine, ServicePolicies policies, RangerPolicyEngineOptions options) {
        RangerPolicyEngine ret;
        if (CollectionUtils.isNotEmpty(policies.getPolicyDeltas())) {
            RangerPolicyEngine updatedEngine = policyEngine.cloneWithDelta(policies);
            if (updatedEngine != null) {
                this.policyEngineCache.put(policies.getServiceName(), updatedEngine);
                ret = updatedEngine;
            } else {
                LOG.warn((Object)("Could not cloneWithDelta policyEngine to policyVersion:[" + policies.getPolicyVersion() + "]"));
                LOG.warn((Object)("Retaining old policyEngine with policyVersion:[" + policyEngine.getPolicyVersion() + "]"));
                ret = policyEngine;
            }
        } else {
            ret = this.addPolicyEngine(policies, options);
        }
        return ret;
    }

    public static ServicePolicies getUpdatedServicePoliciesForZones(ServicePolicies servicePolicies, Map<String, RangerSecurityZone.RangerSecurityZoneService> securityZones) {
        ServicePolicies ret;
        if (MapUtils.isNotEmpty(securityZones)) {
            ret = new ServicePolicies();
            ret.setServiceDef(servicePolicies.getServiceDef());
            ret.setServiceId(servicePolicies.getServiceId());
            ret.setServiceName(servicePolicies.getServiceName());
            ret.setAuditMode(servicePolicies.getAuditMode());
            ret.setPolicyVersion(servicePolicies.getPolicyVersion());
            ret.setPolicyUpdateTime(servicePolicies.getPolicyUpdateTime());
            ret.setUserRoles(servicePolicies.getUserRoles());
            ret.setGroupRoles(servicePolicies.getGroupRoles());
            HashMap<String, ServicePolicies.SecurityZoneInfo> securityZonesInfo = new HashMap<String, ServicePolicies.SecurityZoneInfo>();
            if (CollectionUtils.isEmpty(servicePolicies.getPolicyDeltas())) {
                ArrayList<RangerPolicy> allPolicies = new ArrayList<RangerPolicy>(servicePolicies.getPolicies());
                for (Map.Entry<String, RangerSecurityZone.RangerSecurityZoneService> entry : securityZones.entrySet()) {
                    List<RangerPolicy> zonePolicies = RangerPolicyEngineCache.extractZonePolicies(allPolicies, entry.getKey());
                    if (CollectionUtils.isNotEmpty(zonePolicies)) {
                        allPolicies.removeAll(zonePolicies);
                    }
                    ServicePolicies.SecurityZoneInfo securityZoneInfo = new ServicePolicies.SecurityZoneInfo();
                    securityZoneInfo.setZoneName(entry.getKey());
                    securityZoneInfo.setPolicies(zonePolicies);
                    securityZoneInfo.setResources(entry.getValue().getResources());
                    securityZoneInfo.setContainsAssociatedTagService(false);
                    securityZonesInfo.put(entry.getKey(), securityZoneInfo);
                }
                ret.setPolicies(allPolicies);
                ret.setTagPolicies(servicePolicies.getTagPolicies());
            } else {
                ArrayList<RangerPolicyDelta> allPolicyDeltas = new ArrayList<RangerPolicyDelta>(servicePolicies.getPolicyDeltas());
                for (Map.Entry<String, RangerSecurityZone.RangerSecurityZoneService> entry : securityZones.entrySet()) {
                    List<RangerPolicyDelta> zonePolicyDeltas = RangerPolicyEngineCache.extractZonePolicyDeltas(allPolicyDeltas, entry.getKey());
                    if (CollectionUtils.isNotEmpty(zonePolicyDeltas)) {
                        allPolicyDeltas.removeAll(zonePolicyDeltas);
                    }
                    ServicePolicies.SecurityZoneInfo securityZoneInfo = new ServicePolicies.SecurityZoneInfo();
                    securityZoneInfo.setZoneName(entry.getKey());
                    securityZoneInfo.setPolicyDeltas(zonePolicyDeltas);
                    securityZoneInfo.setResources(entry.getValue().getResources());
                    securityZoneInfo.setContainsAssociatedTagService(false);
                    securityZonesInfo.put(entry.getKey(), securityZoneInfo);
                }
                ret.setPolicyDeltas(allPolicyDeltas);
            }
            ret.setSecurityZones(securityZonesInfo);
        } else {
            ret = servicePolicies;
        }
        return ret;
    }

    private static List<RangerPolicy> extractZonePolicies(List<RangerPolicy> allPolicies, String zoneName) {
        ArrayList<RangerPolicy> ret = new ArrayList<RangerPolicy>();
        for (RangerPolicy policy : allPolicies) {
            if (!policy.getIsEnabled().booleanValue() || !StringUtils.equals((String)policy.getZoneName(), (String)zoneName)) continue;
            ret.add(policy);
        }
        return ret;
    }

    private static List<RangerPolicyDelta> extractZonePolicyDeltas(List<RangerPolicyDelta> allPolicyDeltas, String zoneName) {
        ArrayList<RangerPolicyDelta> ret = new ArrayList<RangerPolicyDelta>();
        for (RangerPolicyDelta delta : allPolicyDeltas) {
            if (!StringUtils.equals((String)delta.getZoneName(), (String)zoneName)) continue;
            ret.add(delta);
        }
        return ret;
    }
}

