/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.errors.ValidationErrorCode;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.model.validation.RangerValidator;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetails;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetailsBuilder;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.ServiceDefUtil;

public class RangerServiceDefValidator
extends RangerValidator {
    private static final Log LOG = LogFactory.getLog(RangerServiceDefValidator.class);

    public RangerServiceDefValidator(ServiceStore store) {
        super(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(RangerServiceDef serviceDef, RangerValidator.Action action) throws Exception {
        String message;
        boolean valid;
        RangerServiceDef normalizedServiceDef;
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("==> RangerServiceDefValidator.validate(%s, %s)", new Object[]{serviceDef, action}));
            }
            normalizedServiceDef = ServiceDefUtil.normalize(serviceDef);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Normalized Service Definition being validated: (%s, %s)", new Object[]{serviceDef, action}));
            }
            ArrayList<ValidationFailureDetails> failures = new ArrayList<ValidationFailureDetails>();
            valid = this.isValid(normalizedServiceDef, action, failures);
            message = "";
            try {
                if (valid) break block6;
                message = RangerServiceDefValidator.serializeFailures(failures);
                throw new Exception(message);
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("<== RangerServiceDefValidator.validate(%s, %s): %s, reason[%s]", new Object[]{normalizedServiceDef, action, valid, message}));
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.validate(%s, %s): %s, reason[%s]", new Object[]{normalizedServiceDef, action, valid, message}));
        }
    }

    @Override
    boolean isValid(Long id, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceDefValidator.isValid(" + id + ")"));
        }
        boolean valid = true;
        if (action != RangerValidator.Action.DELETE) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_UNSUPPORTED_ACTION;
            failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().errorCode(error.getErrorCode()).becauseOf(error.getMessage(new Object[]{action})).build());
            valid = false;
        } else if (id == null) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().field("id").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage("id")).build());
            valid = false;
        } else if (this.getServiceDef(id) == null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("No service found for id[" + id + "]! ok!"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceDefValidator.isValid(" + id + "): " + valid));
        }
        return valid;
    }

    boolean isValid(RangerServiceDef serviceDef, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceDefValidator.isValid(" + serviceDef + ")"));
        }
        if (action != RangerValidator.Action.CREATE && action != RangerValidator.Action.UPDATE) {
            throw new IllegalArgumentException("isValid(RangerServiceDef, ...) is only supported for CREATE/UPDATE");
        }
        boolean valid = true;
        if (serviceDef == null) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_NULL_SERVICE_DEF_OBJECT;
            failures.add(new ValidationFailureDetailsBuilder().field("service def").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(new Object[]{action})).build());
            valid = false;
        } else {
            Long id = serviceDef.getId();
            valid = this.isValidServiceDefId(id, action, failures) && valid;
            valid = this.isValidServiceDefName(serviceDef.getName(), id, action, failures) && valid;
            boolean bl = valid = this.isValidAccessTypes(serviceDef.getId(), serviceDef.getAccessTypes(), failures, action) && valid;
            valid = this.isValidResources(serviceDef, failures, action) ? this.isValidResourceGraph(serviceDef, failures) && valid : false;
            List<RangerServiceDef.RangerEnumDef> enumDefs = serviceDef.getEnums();
            valid = this.isValidEnums(enumDefs, failures) ? this.isValidConfigs(serviceDef.getConfigs(), enumDefs, failures) && valid : false;
            valid = this.isValidPolicyConditions(serviceDef.getId(), serviceDef.getPolicyConditions(), failures, action) && valid;
            boolean bl2 = valid = this.isValidDataMaskTypes(serviceDef.getId(), serviceDef.getDataMaskDef().getMaskTypes(), failures, action) && valid;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceDefValidator.isValid(" + serviceDef + "): " + valid));
        }
        return valid;
    }

    boolean isValidServiceDefId(Long id, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerServiceDefValidator.isValidServiceDefId(%s, %s, %s)", new Object[]{id, action, failures}));
        }
        boolean valid = true;
        if (action == RangerValidator.Action.UPDATE) {
            if (id == null) {
                ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_EMPTY_SERVICE_DEF_ID;
                failures.add(new ValidationFailureDetailsBuilder().field("id").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(new Object[0])).build());
                valid = false;
            } else if (this.getServiceDef(id) == null) {
                ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_INVALID_SERVICE_DEF_ID;
                failures.add(new ValidationFailureDetailsBuilder().field("id").isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(id)).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.isValidServiceDefId(%s, %s, %s): %s", new Object[]{id, action, failures, valid}));
        }
        return valid;
    }

    boolean isValidServiceDefName(String name, Long id, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerServiceDefValidator.isValidServiceDefName(%s, %s, %s, %s)", new Object[]{name, id, action, failures}));
        }
        boolean valid = true;
        if (StringUtils.isBlank((String)name)) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_INVALID_SERVICE_DEF_NAME;
            failures.add(new ValidationFailureDetailsBuilder().field("name").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(name)).build());
            valid = false;
        } else {
            RangerServiceDef otherServiceDef = this.getServiceDef(name);
            if (otherServiceDef != null && action == RangerValidator.Action.CREATE) {
                ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_SERVICE_DEF_NAME_CONFICT;
                failures.add(new ValidationFailureDetailsBuilder().field("name").isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(name)).build());
                valid = false;
            } else if (otherServiceDef != null && !Objects.equals(id, otherServiceDef.getId())) {
                ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_ID_NAME_CONFLICT;
                failures.add(new ValidationFailureDetailsBuilder().field("id/name").isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(name, otherServiceDef.getId())).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.isValidServiceDefName(%s, %s, %s, %s): %s", new Object[]{name, id, action, failures, valid}));
        }
        return valid;
    }

    boolean isValidAccessTypes(Long serviceDefId, List<RangerServiceDef.RangerAccessTypeDef> accessTypeDefs, List<ValidationFailureDetails> failures, RangerValidator.Action action) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerServiceDefValidator.isValidAccessTypes(%s, %s)", accessTypeDefs, failures));
        }
        boolean valid = true;
        if (CollectionUtils.isEmpty(accessTypeDefs)) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().field("access types").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage("access types")).build());
            valid = false;
        } else {
            ValidationErrorCode error;
            HashMap<Long, String> existingAccessTypeIDNameMap = new HashMap<Long, String>();
            if (action == RangerValidator.Action.UPDATE) {
                List<RangerServiceDef.RangerAccessTypeDef> existingAccessTypes = this.getServiceDef(serviceDefId).getAccessTypes();
                for (RangerServiceDef.RangerAccessTypeDef existingAccessType : existingAccessTypes) {
                    existingAccessTypeIDNameMap.put(existingAccessType.getItemId(), existingAccessType.getName());
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("accessType names from db = " + existingAccessTypeIDNameMap.values()));
            }
            ArrayList<RangerServiceDef.RangerAccessTypeDef> defsWithImpliedGrants = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
            HashSet<String> accessNames = new HashSet<String>();
            HashSet<Long> ids = new HashSet<Long>();
            for (RangerServiceDef.RangerAccessTypeDef def : accessTypeDefs) {
                String name = def.getName();
                Long itemId = def.getItemId();
                valid = this.isUnique(name, accessNames, "access type name", "access types", failures) && valid;
                boolean bl = valid = this.isUnique(def.getItemId(), ids, "access type itemId", "access types", failures) && valid;
                if (action == RangerValidator.Action.UPDATE && existingAccessTypeIDNameMap.get(itemId) != null && !((String)existingAccessTypeIDNameMap.get(itemId)).equals(name)) {
                    error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_SERVICE_DEF_NAME_CONFICT;
                    failures.add(new ValidationFailureDetailsBuilder().field("access type name").isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(String.format("changing %s[%s] in %s is not supported", "access type name", name, "access types")).build());
                    valid = false;
                }
                if (!CollectionUtils.isNotEmpty(def.getImpliedGrants())) continue;
                defsWithImpliedGrants.add(def);
            }
            for (RangerServiceDef.RangerAccessTypeDef def : defsWithImpliedGrants) {
                String name;
                Collection<String> impliedGrants = this.getImpliedGrants(def);
                Sets.SetView unknownAccessTypes = Sets.difference((Set)Sets.newHashSet(impliedGrants), accessNames);
                if (!unknownAccessTypes.isEmpty()) {
                    error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_IMPLIED_GRANT_UNKNOWN_ACCESS_TYPE;
                    failures.add(new ValidationFailureDetailsBuilder().field("implied grants").subField((String)unknownAccessTypes.iterator().next()).isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(impliedGrants, unknownAccessTypes)).build());
                    valid = false;
                }
                if (!impliedGrants.contains(name = def.getName())) continue;
                ValidationErrorCode error2 = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_IMPLIED_GRANT_IMPLIES_ITSELF;
                failures.add(new ValidationFailureDetailsBuilder().field("implied grants").subField(name).isSemanticallyIncorrect().errorCode(error2.getErrorCode()).becauseOf(error2.getMessage(impliedGrants, name)).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.isValidAccessTypes(%s, %s): %s", accessTypeDefs, failures, valid));
        }
        return valid;
    }

    boolean isValidPolicyConditions(Long serviceDefId, List<RangerServiceDef.RangerPolicyConditionDef> policyConditions, List<ValidationFailureDetails> failures, RangerValidator.Action action) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerServiceDefValidator.isValidPolicyConditions(%s, %s)", policyConditions, failures));
        }
        boolean valid = true;
        if (CollectionUtils.isEmpty(policyConditions)) {
            LOG.debug((Object)"Configs collection was null/empty! ok");
        } else {
            HashMap<Long, String> existingPolicyCondIDNameMap = new HashMap<Long, String>();
            if (action == RangerValidator.Action.UPDATE) {
                List<RangerServiceDef.RangerPolicyConditionDef> existingPolicyConditions = this.getServiceDef(serviceDefId).getPolicyConditions();
                for (RangerServiceDef.RangerPolicyConditionDef existingPolicyCondition : existingPolicyConditions) {
                    existingPolicyCondIDNameMap.put(existingPolicyCondition.getItemId(), existingPolicyCondition.getName());
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("policy condition names from db = " + existingPolicyCondIDNameMap.values()));
            }
            HashSet<Long> ids = new HashSet<Long>();
            HashSet<String> names = new HashSet<String>();
            for (RangerServiceDef.RangerPolicyConditionDef conditionDef : policyConditions) {
                ValidationErrorCode error;
                Long itemId = conditionDef.getItemId();
                valid = this.isUnique(itemId, ids, "policy condition def itemId", "policy condition defs", failures) && valid;
                String name = conditionDef.getName();
                boolean bl = valid = this.isUnique(name, names, "policy condition def name", "policy condition defs", failures) && valid;
                if (action == RangerValidator.Action.UPDATE && existingPolicyCondIDNameMap.get(itemId) != null && !((String)existingPolicyCondIDNameMap.get(itemId)).equals(name)) {
                    error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_SERVICE_DEF_NAME_CONFICT;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy condition def name").isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(String.format("changing %s[%s] in %s is not supported", "policy condition def name", name, "policy condition defs")).build());
                    valid = false;
                }
                if (!StringUtils.isBlank((String)conditionDef.getEvaluator())) continue;
                error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_POLICY_CONDITION_NULL_EVALUATOR;
                failures.add(new ValidationFailureDetailsBuilder().field("policy condition def evaluator").subField(name).isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(name)).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.isValidPolicyConditions(%s, %s): %s", policyConditions, failures, valid));
        }
        return valid;
    }

    boolean isValidConfigs(List<RangerServiceDef.RangerServiceConfigDef> configs, List<RangerServiceDef.RangerEnumDef> enumDefs, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerServiceDefValidator.isValidConfigs(%s, %s, %s)", configs, enumDefs, failures));
        }
        boolean valid = true;
        if (CollectionUtils.isEmpty(configs)) {
            LOG.debug((Object)"Configs collection was null/empty! ok");
        } else {
            HashSet<Long> ids = new HashSet<Long>(configs.size());
            HashSet<String> names = new HashSet<String>(configs.size());
            for (RangerServiceDef.RangerServiceConfigDef aConfig : configs) {
                valid = this.isUnique(aConfig.getItemId(), ids, "config def itemId", "config defs", failures) && valid;
                String configName = aConfig.getName();
                valid = this.isUnique(configName, names, "config def name", "config defs", failures) && valid;
                String type = aConfig.getType();
                boolean bl = valid = this.isValidConfigType(type, configName, failures) && valid;
                if (!"enum".equals(type)) continue;
                valid = this.isValidConfigOfEnumType(aConfig, enumDefs, failures) && valid;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.isValidConfigs(%s, %s, %s): %s", configs, enumDefs, failures, valid));
        }
        return valid;
    }

    boolean isValidConfigOfEnumType(RangerServiceDef.RangerServiceConfigDef configDef, List<RangerServiceDef.RangerEnumDef> enumDefs, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerServiceDefValidator.isValidConfigOfEnumType(%s, %s, %s)", configDef, enumDefs, failures));
        }
        boolean valid = true;
        if (!"enum".equals(configDef.getType())) {
            LOG.debug((Object)"ConfigDef wasn't of enum type!");
        } else {
            Map<String, RangerServiceDef.RangerEnumDef> enumDefsMap = this.getEnumDefMap(enumDefs);
            Set<String> enumTypes = enumDefsMap.keySet();
            String subType = configDef.getSubType();
            String configName = configDef.getName();
            if (!enumTypes.contains(subType)) {
                ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_CONFIG_DEF_UNKNOWN_ENUM;
                failures.add(new ValidationFailureDetailsBuilder().field("config def subtype").subField(configName).isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(subType, configName, enumTypes)).build());
                valid = false;
            } else {
                RangerServiceDef.RangerEnumDef enumDef;
                Set<String> enumValues;
                String defaultValue = configDef.getDefaultValue();
                if (StringUtils.isNotBlank((String)defaultValue) && !(enumValues = this.getEnumValues(enumDef = enumDefsMap.get(subType))).contains(defaultValue)) {
                    ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_CONFIG_DEF_UNKNOWN_ENUM_VALUE;
                    failures.add(new ValidationFailureDetailsBuilder().field("config def default value").subField(configName).isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(defaultValue, configName, enumValues, subType)).build());
                    valid = false;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.isValidConfigOfEnumType(%s, %s, %s): %s", configDef, enumDefs, failures, valid));
        }
        return valid;
    }

    boolean isValidConfigType(String type, String configName, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerServiceDefValidator.isValidConfigType(%s, %s, %s)", type, configName, failures));
        }
        boolean valid = true;
        ImmutableSet validTypes = ImmutableSet.of((Object)"bool", (Object)"enum", (Object)"int", (Object)"string", (Object)"password", (Object)"path", (Object[])new String[0]);
        if (StringUtils.isBlank((String)type)) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_CONFIG_DEF_MISSING_TYPE;
            failures.add(new ValidationFailureDetailsBuilder().field("config def type").subField(configName).isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(configName)).build());
            valid = false;
        } else if (!validTypes.contains(type)) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_CONFIG_DEF_INVALID_TYPE;
            failures.add(new ValidationFailureDetailsBuilder().field("config def type").subField(configName).isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(type, configName, validTypes)).build());
            valid = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.isValidConfigType(%s, %s, %s): %s", type, configName, failures, valid));
        }
        return valid;
    }

    public boolean isValidResources(RangerServiceDef serviceDef, List<ValidationFailureDetails> failures, RangerValidator.Action action) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerServiceDefValidator.isValidResources(%s, %s)", serviceDef, failures));
        }
        boolean valid = true;
        List<RangerServiceDef.RangerResourceDef> resources = serviceDef.getResources();
        if (CollectionUtils.isEmpty(resources)) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().field("resources").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage("resources")).build());
            valid = false;
        } else {
            HashMap<Long, String> existingResourceIDNameMap = new HashMap<Long, String>();
            if (action == RangerValidator.Action.UPDATE) {
                List<RangerServiceDef.RangerResourceDef> existingResources = this.getServiceDef(serviceDef.getId()).getResources();
                for (RangerServiceDef.RangerResourceDef existingResource : existingResources) {
                    existingResourceIDNameMap.put(existingResource.getItemId(), existingResource.getName());
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("resource names from db = " + existingResourceIDNameMap.values()));
            }
            HashSet<String> names = new HashSet<String>(resources.size());
            HashSet<Long> ids = new HashSet<Long>(resources.size());
            for (RangerServiceDef.RangerResourceDef resource : resources) {
                valid = this.isValidResourceName(resource.getName(), "resource type name", failures) && valid;
                String name = resource.getName();
                Long itemId = resource.getItemId();
                valid = this.isUnique(name, names, "resource name", "resources", failures) && valid;
                boolean bl = valid = this.isUnique(itemId, ids, "resource itemId", "resources", failures) && valid;
                if (action != RangerValidator.Action.UPDATE || existingResourceIDNameMap.get(itemId) == null || ((String)existingResourceIDNameMap.get(itemId)).equals(name)) continue;
                ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_SERVICE_DEF_NAME_CONFICT;
                failures.add(new ValidationFailureDetailsBuilder().field("resource name").isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(String.format("changing %s[%s] in %s is not supported", "resource name", name, "resources")).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.isValidResources(%s, %s): %s", serviceDef, failures, valid));
        }
        return valid;
    }

    boolean isValidResourceGraph(RangerServiceDef serviceDef, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerServiceDefValidator.isValidResourceGraph(%s, %s)", serviceDef, failures));
        }
        boolean valid = true;
        RangerServiceDefHelper defHelper = this._factory.createServiceDefHelper(serviceDef, false);
        if (!defHelper.isResourceGraphValid()) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_RESOURCE_GRAPH_INVALID;
            failures.add(new ValidationFailureDetailsBuilder().field("resource graph").isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(new Object[0])).build());
            valid = false;
        }
        for (Object policyType : (ValidationErrorCode)RangerPolicy.POLICY_TYPES) {
            Set<List<RangerServiceDef.RangerResourceDef>> hierarchies = defHelper.getResourceHierarchies((int)policyType);
            block1: for (List<RangerServiceDef.RangerResourceDef> aHierarchy : hierarchies) {
                HashSet<Integer> levels = new HashSet<Integer>(aHierarchy.size());
                for (RangerServiceDef.RangerResourceDef resourceDef : aHierarchy) {
                    valid = this.isUnique(resourceDef.getLevel(), levels, "resource level", "resources", failures) && valid;
                }
                int lastResourceLevel = Integer.MIN_VALUE;
                for (RangerServiceDef.RangerResourceDef rangerResourceDef : aHierarchy) {
                    Integer resourceDefLevel = rangerResourceDef.getLevel();
                    if (resourceDefLevel == null || resourceDefLevel < lastResourceLevel) {
                        ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_INVALID_SERVICE_RESOURCE_LEVELS;
                        failures.add(new ValidationFailureDetailsBuilder().field("resource level").subField(String.valueOf(resourceDefLevel)).isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(new Object[0])).build());
                        valid = false;
                        continue block1;
                    }
                    lastResourceLevel = rangerResourceDef.getLevel();
                }
            }
        }
        List<RangerServiceDef.RangerResourceDef> resources = serviceDef.getResources();
        ArrayList<String> resourceNames = new ArrayList<String>(resources.size());
        for (RangerServiceDef.RangerResourceDef resourceDef : resources) {
            resourceNames.add(resourceDef.getName());
        }
        for (String resourceName : resourceNames) {
            for (int policyType : RangerPolicy.POLICY_TYPES) {
                Set<List<RangerServiceDef.RangerResourceDef>> hierarchies = defHelper.getResourceHierarchies(policyType);
                for (List list : hierarchies) {
                    boolean foundOptionalResource = false;
                    for (RangerServiceDef.RangerResourceDef resourceDef : list) {
                        if (!foundOptionalResource) {
                            if (!resourceDef.getName().equalsIgnoreCase(resourceName) || Boolean.TRUE.equals(resourceDef.getMandatory())) continue;
                            foundOptionalResource = true;
                            continue;
                        }
                        if (!Boolean.TRUE.equals(resourceDef.getMandatory())) continue;
                        valid = false;
                        ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_INVALID_MANADORY_VALUE_FOR_SERVICE_RESOURCE;
                        failures.add(new ValidationFailureDetailsBuilder().field(resourceDef.getName()).isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(resourceDef.getName(), resourceName)).build());
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.isValidResourceGraph(%s, %s): %s", serviceDef, failures, valid));
        }
        return valid;
    }

    boolean isValidEnums(List<RangerServiceDef.RangerEnumDef> enumDefs, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerServiceDefValidator.isValidEnums(%s, %s)", enumDefs, failures));
        }
        boolean valid = true;
        if (CollectionUtils.isEmpty(enumDefs)) {
            LOG.debug((Object)"enum def collection passed in was null/empty. Ok.");
        } else {
            HashSet<String> names = new HashSet<String>();
            HashSet<Long> ids = new HashSet<Long>();
            for (RangerServiceDef.RangerEnumDef enumDef : enumDefs) {
                if (enumDef == null) {
                    ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_ENUM_DEF_NULL_OBJECT;
                    failures.add(new ValidationFailureDetailsBuilder().field("enum def").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(new Object[0])).build());
                    valid = false;
                    continue;
                }
                String enumName = enumDef.getName();
                valid = this.isUnique(enumName, names, "enum def name", "enum defs", failures) && valid;
                boolean bl = valid = this.isUnique(enumDef.getItemId(), ids, "enum def itemId", "enum defs", failures) && valid;
                if (CollectionUtils.isEmpty(enumDef.getElements())) {
                    ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_ENUM_DEF_NO_VALUES;
                    failures.add(new ValidationFailureDetailsBuilder().field("enum values").subField(enumName).isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(enumName)).build());
                    valid = false;
                    continue;
                }
                valid = this.isValidEnumElements(enumDef.getElements(), failures, enumName) && valid;
                int defaultIndex = this.getEnumDefaultIndex(enumDef);
                if (defaultIndex >= 0 && defaultIndex < enumDef.getElements().size()) continue;
                ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_ENUM_DEF_INVALID_DEFAULT_INDEX;
                failures.add(new ValidationFailureDetailsBuilder().field("enum default index").subField(enumName).isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(defaultIndex, enumName)).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.isValidEnums(%s, %s): %s", enumDefs, failures, valid));
        }
        return valid;
    }

    boolean isValidEnumElements(List<RangerServiceDef.RangerEnumElementDef> enumElementsDefs, List<ValidationFailureDetails> failures, String enumName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerServiceDefValidator.isValidEnumElements(%s, %s)", enumElementsDefs, failures));
        }
        boolean valid = true;
        if (CollectionUtils.isEmpty(enumElementsDefs)) {
            LOG.debug((Object)"Enum elements list passed in was null/empty!");
        } else {
            HashSet<String> elementNames = new HashSet<String>();
            HashSet<Long> ids = new HashSet<Long>();
            for (RangerServiceDef.RangerEnumElementDef elementDef : enumElementsDefs) {
                if (elementDef == null) {
                    ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_ENUM_DEF_NULL_ENUM_ELEMENT;
                    failures.add(new ValidationFailureDetailsBuilder().field("enum element").subField(enumName).isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(enumName)).build());
                    valid = false;
                    continue;
                }
                valid = this.isUnique(elementDef.getName(), enumName, elementNames, "enum element name", "enum elements", failures) && valid;
                valid = this.isUnique(elementDef.getItemId(), enumName, ids, "enum element itemId", "enum elements", failures) && valid;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.isValidEnumElements(%s, %s): %s", enumElementsDefs, failures, valid));
        }
        return valid;
    }

    boolean isValidDataMaskTypes(Long serviceDefId, List<RangerServiceDef.RangerDataMaskTypeDef> dataMaskTypes, List<ValidationFailureDetails> failures, RangerValidator.Action action) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerServiceDefValidator.isValidDataMaskTypes(%s, %s)", dataMaskTypes, failures));
        }
        boolean valid = true;
        if (CollectionUtils.isEmpty(dataMaskTypes)) {
            LOG.debug((Object)"Configs collection was null/empty! ok");
        } else {
            HashMap<Long, String> existingDataMaskTypeIDNameMap = new HashMap<Long, String>();
            if (action == RangerValidator.Action.UPDATE) {
                List<RangerServiceDef.RangerDataMaskTypeDef> existingDataMaskTypes = this.getServiceDef(serviceDefId).getDataMaskDef().getMaskTypes();
                for (RangerServiceDef.RangerDataMaskTypeDef existingDataMaskType : existingDataMaskTypes) {
                    existingDataMaskTypeIDNameMap.put(existingDataMaskType.getItemId(), existingDataMaskType.getName());
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("data mask type names from db = " + existingDataMaskTypeIDNameMap.values()));
            }
            HashSet<Long> ids = new HashSet<Long>();
            HashSet<String> names = new HashSet<String>();
            for (RangerServiceDef.RangerDataMaskTypeDef dataMaskType : dataMaskTypes) {
                String name = dataMaskType.getName();
                Long itemId = dataMaskType.getItemId();
                valid = this.isUnique(itemId, ids, "data mask type def itemId", "data mask type defs", failures) && valid;
                boolean bl = valid = this.isUnique(name, names, "data mask type def name", "data mask type defs", failures) && valid;
                if (action != RangerValidator.Action.UPDATE || existingDataMaskTypeIDNameMap.get(itemId) == null || ((String)existingDataMaskTypeIDNameMap.get(itemId)).equals(name)) continue;
                ValidationErrorCode error = ValidationErrorCode.SERVICE_DEF_VALIDATION_ERR_SERVICE_DEF_NAME_CONFICT;
                failures.add(new ValidationFailureDetailsBuilder().field("data mask type def name").isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(String.format("changing %s[%s] in %s is not supported", "data mask type def name", name, "data mask type defs")).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerServiceDefValidator.isValidDataMaskTypes(%s, %s): %s", dataMaskTypes, failures, valid));
        }
        return valid;
    }
}

