/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.service.RangerBasePlugin;

public abstract class RangerAbstractContextEnricher
implements RangerContextEnricher {
    private static final Log LOG = LogFactory.getLog(RangerAbstractContextEnricher.class);
    protected RangerServiceDef.RangerContextEnricherDef enricherDef;
    protected String serviceName;
    protected String appId;
    protected RangerServiceDef serviceDef;

    @Override
    public void setEnricherDef(RangerServiceDef.RangerContextEnricherDef enricherDef) {
        this.enricherDef = enricherDef;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public void setServiceDef(RangerServiceDef serviceDef) {
        this.serviceDef = serviceDef;
    }

    @Override
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public void init() {
        RangerAuthContext currentAuthContext;
        Map<String, RangerBasePlugin> servicePluginMap;
        RangerBasePlugin plugin;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAbstractContextEnricher.init(" + this.enricherDef + ")"));
        }
        RangerBasePlugin rangerBasePlugin = plugin = (servicePluginMap = RangerBasePlugin.getServicePluginMap()) != null ? servicePluginMap.get(this.getServiceName()) : null;
        if (plugin != null && (currentAuthContext = plugin.getCurrentRangerAuthContext()) != null) {
            currentAuthContext.addOrReplaceRequestContextEnricher(this, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAbstractContextEnricher.init(" + this.enricherDef + ")"));
        }
    }

    @Override
    public void enrich(RangerAccessRequest request, Object dataStore) {
        this.enrich(request);
    }

    @Override
    public boolean preCleanup() {
        RangerAuthContext currentAuthContext;
        Map<String, RangerBasePlugin> servicePluginMap;
        RangerBasePlugin plugin;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAbstractContextEnricher.preCleanup(" + this.enricherDef + ")"));
        }
        RangerBasePlugin rangerBasePlugin = plugin = (servicePluginMap = RangerBasePlugin.getServicePluginMap()) != null ? servicePluginMap.get(this.getServiceName()) : null;
        if (plugin != null && (currentAuthContext = plugin.getCurrentRangerAuthContext()) != null) {
            currentAuthContext.cleanupRequestContextEnricher(this);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAbstractContextEnricher.preCleanup(" + this.enricherDef + ")"));
        }
        return true;
    }

    @Override
    public void cleanup() {
        this.preCleanup();
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String getName() {
        return this.enricherDef == null ? null : this.enricherDef.getName();
    }

    public RangerServiceDef.RangerContextEnricherDef getEnricherDef() {
        return this.enricherDef;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getOption(String name) {
        Map<String, String> options;
        String ret = null;
        Map<String, String> map = options = this.enricherDef != null ? this.enricherDef.getEnricherOptions() : null;
        if (options != null && name != null) {
            ret = options.get(name);
        }
        return ret;
    }

    public String getOption(String name, String defaultValue) {
        String ret = defaultValue;
        String val = this.getOption(name);
        if (val != null) {
            ret = val;
        }
        return ret;
    }

    public boolean getBooleanOption(String name, boolean defaultValue) {
        boolean ret = defaultValue;
        String val = this.getOption(name);
        if (val != null) {
            ret = Boolean.parseBoolean(val);
        }
        return ret;
    }

    public char getCharOption(String name, char defaultValue) {
        char ret = defaultValue;
        String val = this.getOption(name);
        if (!StringUtils.isEmpty((String)val)) {
            ret = val.charAt(0);
        }
        return ret;
    }

    public long getLongOption(String name, long defaultValue) {
        long ret = defaultValue;
        String val = this.getOption(name);
        if (val != null) {
            ret = Long.parseLong(val);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties readProperties(String fileName) {
        Properties ret = null;
        InputStream inStr = null;
        URL fileURL = null;
        File f = new File(fileName);
        if (f.exists() && f.isFile() && f.canRead()) {
            try {
                inStr = new FileInputStream(f);
                fileURL = f.toURI().toURL();
            }
            catch (FileNotFoundException exception) {
                LOG.error((Object)("Error processing input file:" + fileName + " or no privilege for reading file " + fileName), (Throwable)exception);
            }
            catch (MalformedURLException malformedException) {
                LOG.error((Object)("Error processing input file:" + fileName + " cannot be converted to URL " + fileName), (Throwable)malformedException);
            }
        } else {
            fileURL = this.getClass().getResource(fileName);
            if (fileURL == null && !fileName.startsWith("/")) {
                fileURL = this.getClass().getResource("/" + fileName);
            }
            if (fileURL == null && (fileURL = ClassLoader.getSystemClassLoader().getResource(fileName)) == null && !fileName.startsWith("/")) {
                fileURL = ClassLoader.getSystemClassLoader().getResource("/" + fileName);
            }
        }
        if (fileURL != null) {
            try {
                inStr = fileURL.openStream();
                Properties prop = new Properties();
                prop.load(inStr);
                ret = prop;
            }
            catch (Exception excp) {
                LOG.error((Object)("failed to load properties from file '" + fileName + "'"), (Throwable)excp);
            }
            finally {
                if (inStr != null) {
                    try {
                        inStr.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return ret;
    }
}

