/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;

public class RangerContextAttributeValueInCondition
extends RangerAbstractConditionEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerContextAttributeValueInCondition.class);
    protected String attributeName;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerContextAttributeValueInCondition.init(" + this.condition + ")"));
        }
        super.init();
        Map<String, String> evalOptions = this.conditionDef.getEvaluatorOptions();
        if (MapUtils.isNotEmpty(evalOptions)) {
            this.attributeName = evalOptions.get("attributeName");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerContextAttributeValueInCondition.init(" + this.condition + ")"));
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        Object val;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerContextAttributeValueInCondition.isMatched(" + this.condition + ")"));
        }
        boolean ret = true;
        if (this.attributeName != null && this.condition != null && CollectionUtils.isNotEmpty(this.condition.getValues()) && (val = request.getContext().get(this.attributeName)) != null) {
            ret = this.condition.getValues().contains(val);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerContextAttributeValueInCondition.isMatched(" + this.condition + "): " + ret));
        }
        return ret;
    }
}

