/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.queue.AuditQueue;

public class AuditSummaryQueue
extends AuditQueue
implements Runnable {
    private static final Log logger = LogFactory.getLog(AuditSummaryQueue.class);
    public static final String PROP_SUMMARY_INTERVAL = "summary.interval.ms";
    LinkedBlockingQueue<AuditEventBase> queue = new LinkedBlockingQueue();
    Thread consumerThread = null;
    static int threadCount = 0;
    static final String DEFAULT_NAME = "summary";
    private static final int MAX_DRAIN = 100000;
    private int maxSummaryIntervalMs = 5000;
    HashMap<String, AuditSummary> summaryMap = new HashMap();

    public AuditSummaryQueue(AuditHandler consumer) {
        super(consumer);
        this.setName(DEFAULT_NAME);
    }

    @Override
    public void init(Properties props, String propPrefix) {
        super.init(props, propPrefix);
        this.maxSummaryIntervalMs = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_SUMMARY_INTERVAL, this.maxSummaryIntervalMs);
        logger.info((Object)("maxSummaryInterval=" + this.maxSummaryIntervalMs + ", name=" + this.getName()));
    }

    @Override
    public boolean log(AuditEventBase event) {
        if (this.queue.size() >= this.getMaxQueueSize()) {
            return false;
        }
        this.queue.add(event);
        return true;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        AuditEventBase event;
        boolean ret = true;
        Iterator<AuditEventBase> iterator = events.iterator();
        while (iterator.hasNext() && (ret = this.log(event = iterator.next()))) {
        }
        return ret;
    }

    @Override
    public void start() {
        if (this.consumer != null) {
            this.consumer.start();
        }
        this.consumerThread = new Thread((Runnable)this, this.getClass().getName() + threadCount++);
        this.consumerThread.setDaemon(true);
        this.consumerThread.start();
    }

    @Override
    public void stop() {
        logger.info((Object)("Stop called. name=" + this.getName()));
        this.setDrain(true);
        try {
            if (this.consumerThread != null) {
                logger.info((Object)("Interrupting consumerThread. name=" + this.getName() + ", consumer=" + (this.consumer == null ? null : this.consumer.getName())));
                this.consumerThread.interrupt();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.consumerThread = null;
    }

    @Override
    public void run() {
        try {
            MDC.clear();
            this.runLogAudit();
        }
        catch (Throwable t) {
            logger.fatal((Object)("Exited thread without abnormaly. queue=" + this.getName()), t);
        }
    }

    public void runLogAudit() {
        long lastDispatchTime = System.currentTimeMillis();
        while (true) {
            long nextDispatchDuration = lastDispatchTime - System.currentTimeMillis() + (long)this.maxSummaryIntervalMs;
            ArrayList<AuditEventBase> eventList = new ArrayList<AuditEventBase>();
            try {
                AuditEventBase event = null;
                event = !this.isDrain() && nextDispatchDuration > 0L ? this.queue.poll(nextDispatchDuration, TimeUnit.MILLISECONDS) : this.queue.poll();
                if (event != null) {
                    eventList.add(event);
                    this.queue.drainTo(eventList, 99999);
                } else {
                    nextDispatchDuration = lastDispatchTime - System.currentTimeMillis() + (long)this.maxSummaryIntervalMs;
                    lastDispatchTime = System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                logger.info((Object)"Caught exception in consumer thread. Shutdown might be in progress");
            }
            catch (Throwable t) {
                logger.error((Object)"Caught error during processing request.", t);
            }
            for (AuditEventBase auditEventBase : eventList) {
                String key = auditEventBase.getEventKey();
                AuditSummary auditSummary = this.summaryMap.get(key);
                if (auditSummary == null) {
                    auditSummary = new AuditSummary();
                    auditSummary.event = auditEventBase;
                    auditSummary.startTime = auditEventBase.getEventTime();
                    auditSummary.endTime = auditEventBase.getEventTime();
                    auditSummary.count = 1;
                    this.summaryMap.put(key, auditSummary);
                    continue;
                }
                auditSummary.endTime = auditEventBase.getEventTime();
                ++auditSummary.count;
            }
            if (this.isDrain() || nextDispatchDuration <= 0L) {
                lastDispatchTime = System.currentTimeMillis();
                for (Map.Entry entry : this.summaryMap.entrySet()) {
                    AuditSummary auditSummary = (AuditSummary)entry.getValue();
                    auditSummary.event.setEventCount(auditSummary.count);
                    long timeDiff = auditSummary.endTime.getTime() - auditSummary.startTime.getTime();
                    timeDiff = timeDiff > 0L ? timeDiff : 1L;
                    auditSummary.event.setEventDurationMS(timeDiff);
                    boolean ret = this.consumer.log(auditSummary.event);
                    if (ret) continue;
                    this.logFailedEvent(auditSummary.event);
                }
                this.summaryMap.clear();
            }
            if (!this.isDrain()) continue;
            if (this.summaryMap.isEmpty() && this.queue.isEmpty()) break;
            if (!this.isDrainMaxTimeElapsed()) continue;
            logger.warn((Object)("Exiting polling loop because max time allowed reached. name=" + this.getName() + ", waited for " + (this.stopTime - System.currentTimeMillis()) + " ms"));
        }
        logger.info((Object)("Exiting polling loop. name=" + this.getName()));
        try {
            logger.info((Object)("Calling to stop consumer. name=" + this.getName() + ", consumer.name=" + this.consumer.getName()));
            this.consumer.stop();
        }
        catch (Throwable t) {
            logger.error((Object)"Error while calling stop on consumer.", t);
        }
        logger.info((Object)("Exiting consumerThread.run() method. name=" + this.getName()));
    }

    class AuditSummary {
        Date startTime = null;
        Date endTime = null;
        int count = 0;
        AuditEventBase event;

        AuditSummary() {
        }
    }
}

