/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;

public class Log4jAuditProvider
extends AuditDestination {
    private static final Log LOG = LogFactory.getLog(Log4jAuditProvider.class);
    private static final Log AUDITLOG = LogFactory.getLog((String)("xaaudit." + Log4jAuditProvider.class.getName()));
    public static final String AUDIT_LOG4J_IS_ASYNC_PROP = "xasecure.audit.log4j.is.async";
    public static final String AUDIT_LOG4J_MAX_QUEUE_SIZE_PROP = "xasecure.audit.log4j.async.max.queue.size";
    public static final String AUDIT_LOG4J_MAX_FLUSH_INTERVAL_PROP = "xasecure.audit.log4j.async.max.flush.interval.ms";

    public Log4jAuditProvider() {
        LOG.info((Object)"Log4jAuditProvider: creating..");
    }

    @Override
    public void init(Properties props) {
        LOG.info((Object)"Log4jAuditProvider.init()");
        super.init(props);
    }

    @Override
    public boolean log(AuditEventBase event) {
        if (!AUDITLOG.isInfoEnabled()) {
            return true;
        }
        if (event != null) {
            String eventStr = MiscUtil.stringify(event);
            AUDITLOG.info((Object)eventStr);
        }
        return true;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        for (AuditEventBase event : events) {
            this.log(event);
        }
        return true;
    }

    @Override
    public boolean logJSON(String event) {
        AuditEventBase eventObj = MiscUtil.fromJson(event, AuthzAuditEvent.class);
        return this.log(eventObj);
    }

    @Override
    public boolean logJSON(Collection<String> events) {
        for (String event : events) {
            this.logJSON(event);
        }
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

