/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;

@Entity
@Table(name="xa_access_audit")
public class AuthzAuditEventDbObj
implements Serializable {
    private static final Log LOG = LogFactory.getLog(AuthzAuditEventDbObj.class);
    private static final long serialVersionUID = 1L;
    static int MaxValueLengthAccessType = 255;
    static int MaxValueLengthAclEnforcer = 255;
    static int MaxValueLengthAgentId = 255;
    static int MaxValueLengthClientIp = 255;
    static int MaxValueLengthClientType = 255;
    static int MaxValueLengthRepoName = 255;
    static int MaxValueLengthResultReason = 255;
    static int MaxValueLengthSessionId = 255;
    static int MaxValueLengthRequestUser = 255;
    static int MaxValueLengthAction = 2000;
    static int MaxValueLengthRequestData = 4000;
    static int MaxValueLengthResourcePath = 4000;
    static int MaxValueLengthResourceType = 255;
    private long auditId;
    private int repositoryType;
    private String repositoryName;
    private String user;
    private Date timeStamp;
    private String accessType;
    private String resourcePath;
    private String resourceType;
    private String action;
    private int accessResult;
    private String agentId;
    private long policyId;
    private String resultReason;
    private String aclEnforcer;
    private String sessionId;
    private String clientType;
    private String clientIP;
    private String requestData;
    private long seqNum;
    private long eventCount;
    private long eventDurationMS;
    private String tags;
    static final String TruncationMarker = "...";
    static final int TruncationMarkerLength = "...".length();

    public static void init(Properties props) {
        LOG.info((Object)"AuthzAuditEventDbObj.init()");
        String AUDIT_DB_MAX_COLUMN_VALUE = "xasecure.audit.destination.db.max.column.length";
        MaxValueLengthAccessType = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.access_type", MaxValueLengthAccessType);
        AuthzAuditEventDbObj.logMaxColumnValue("access_type", MaxValueLengthAccessType);
        MaxValueLengthAclEnforcer = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.acl_enforcer", MaxValueLengthAclEnforcer);
        AuthzAuditEventDbObj.logMaxColumnValue("acl_enforcer", MaxValueLengthAclEnforcer);
        MaxValueLengthAction = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.action", MaxValueLengthAction);
        AuthzAuditEventDbObj.logMaxColumnValue("action", MaxValueLengthAction);
        MaxValueLengthAgentId = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.agent_id", MaxValueLengthAgentId);
        AuthzAuditEventDbObj.logMaxColumnValue("agent_id", MaxValueLengthAgentId);
        MaxValueLengthClientIp = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.client_id", MaxValueLengthClientIp);
        AuthzAuditEventDbObj.logMaxColumnValue("client_id", MaxValueLengthClientIp);
        MaxValueLengthClientType = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.client_type", MaxValueLengthClientType);
        AuthzAuditEventDbObj.logMaxColumnValue("client_type", MaxValueLengthClientType);
        MaxValueLengthRepoName = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.repo_name", MaxValueLengthRepoName);
        AuthzAuditEventDbObj.logMaxColumnValue("repo_name", MaxValueLengthRepoName);
        MaxValueLengthResultReason = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.result_reason", MaxValueLengthResultReason);
        AuthzAuditEventDbObj.logMaxColumnValue("result_reason", MaxValueLengthResultReason);
        MaxValueLengthSessionId = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.session_id", MaxValueLengthSessionId);
        AuthzAuditEventDbObj.logMaxColumnValue("session_id", MaxValueLengthSessionId);
        MaxValueLengthRequestUser = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.request_user", MaxValueLengthRequestUser);
        AuthzAuditEventDbObj.logMaxColumnValue("request_user", MaxValueLengthRequestUser);
        MaxValueLengthRequestData = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.request_data", MaxValueLengthRequestData);
        AuthzAuditEventDbObj.logMaxColumnValue("request_data", MaxValueLengthRequestData);
        MaxValueLengthResourcePath = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.resource_path", MaxValueLengthResourcePath);
        AuthzAuditEventDbObj.logMaxColumnValue("resource_path", MaxValueLengthResourcePath);
        MaxValueLengthResourceType = MiscUtil.getIntProperty(props, "xasecure.audit.destination.db.max.column.length.resource_type", MaxValueLengthResourceType);
        AuthzAuditEventDbObj.logMaxColumnValue("resource_type", MaxValueLengthResourceType);
    }

    public static void logMaxColumnValue(String columnName, int configuredMaxValueLength) {
        LOG.info((Object)("Setting max column value for column[" + columnName + "] to [" + configuredMaxValueLength + "]."));
        if (configuredMaxValueLength == 0) {
            LOG.info((Object)("Max length of column[" + columnName + "] was 0! Column will NOT be emitted in the audit."));
        } else if (configuredMaxValueLength < 0) {
            LOG.info((Object)("Max length of column[" + columnName + "] was less than 0! Column value will never be truncated."));
        }
    }

    public AuthzAuditEventDbObj() {
    }

    public AuthzAuditEventDbObj(AuthzAuditEvent event) {
        Date utcDate = null;
        utcDate = event.getEventTime() != null ? MiscUtil.getUTCDateForLocalDate(event.getEventTime()) : MiscUtil.getUTCDate();
        this.repositoryType = event.getRepositoryType();
        this.repositoryName = event.getRepositoryName();
        this.user = event.getUser();
        this.timeStamp = utcDate;
        this.accessType = event.getAccessType();
        this.resourcePath = event.getResourcePath();
        this.resourceType = event.getResourceType();
        this.action = event.getAction();
        this.accessResult = event.getAccessResult();
        this.agentId = event.getAgentId();
        this.policyId = event.getPolicyId();
        this.resultReason = event.getResultReason();
        this.aclEnforcer = event.getAclEnforcer();
        this.sessionId = event.getSessionId();
        this.clientType = event.getClientType();
        this.clientIP = event.getClientIP();
        this.requestData = event.getRequestData();
        this.seqNum = event.getSeqNum();
        this.eventCount = event.getEventCount();
        this.eventDurationMS = event.getEventDurationMS();
        this.tags = StringUtils.join(event.getTags(), (String)", ");
    }

    @Id
    @SequenceGenerator(name="XA_ACCESS_AUDIT_SEQ", sequenceName="XA_ACCESS_AUDIT_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="XA_ACCESS_AUDIT_SEQ")
    @Column(name="id", unique=true, nullable=false)
    public long getAuditId() {
        return this.auditId;
    }

    public void setAuditId(long auditId) {
        this.auditId = auditId;
    }

    @Column(name="repo_type")
    public int getRepositoryType() {
        return this.repositoryType;
    }

    public void setRepositoryType(int repositoryType) {
        this.repositoryType = repositoryType;
    }

    @Column(name="repo_name")
    public String getRepositoryName() {
        return this.truncate(this.repositoryName, MaxValueLengthRepoName, "repo_name");
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Column(name="request_user")
    public String getUser() {
        return this.truncate(this.user, MaxValueLengthRequestUser, "request_user");
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="event_time")
    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Column(name="access_type")
    public String getAccessType() {
        return this.truncate(this.accessType, MaxValueLengthAccessType, "access_type");
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    @Column(name="resource_path")
    public String getResourcePath() {
        return this.truncate(this.resourcePath, MaxValueLengthResourcePath, "resource_path");
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Column(name="resource_type")
    public String getResourceType() {
        return this.truncate(this.resourceType, MaxValueLengthResourceType, "resource_type");
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @Column(name="action")
    public String getAction() {
        return this.truncate(this.action, MaxValueLengthAction, "action");
    }

    public void setAction(String action) {
        this.action = action;
    }

    @Column(name="access_result")
    public int getAccessResult() {
        return this.accessResult;
    }

    public void setAccessResult(int accessResult) {
        this.accessResult = accessResult;
    }

    @Column(name="agent_id")
    public String getAgentId() {
        return this.truncate(this.agentId, MaxValueLengthAgentId, "agent_id");
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Column(name="policy_id")
    public long getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(long policyId) {
        this.policyId = policyId;
    }

    @Column(name="result_reason")
    public String getResultReason() {
        return this.truncate(this.resultReason, MaxValueLengthResultReason, "result_reason");
    }

    public void setResultReason(String resultReason) {
        this.resultReason = resultReason;
    }

    @Column(name="acl_enforcer")
    public String getAclEnforcer() {
        return this.truncate(this.aclEnforcer, MaxValueLengthAclEnforcer, "acl_enforcer");
    }

    public void setAclEnforcer(String aclEnforcer) {
        this.aclEnforcer = aclEnforcer;
    }

    @Column(name="session_id")
    public String getSessionId() {
        return this.truncate(this.sessionId, MaxValueLengthSessionId, "session_id");
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Column(name="client_type")
    public String getClientType() {
        return this.truncate(this.clientType, MaxValueLengthClientType, "client_type");
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    @Column(name="client_ip")
    public String getClientIP() {
        return this.truncate(this.clientIP, MaxValueLengthClientIp, "client_ip");
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    @Column(name="request_data")
    public String getRequestData() {
        return this.truncate(this.requestData, MaxValueLengthRequestData, "request_data");
    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    @Column(name="seq_num")
    public long getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(long seqNum) {
        this.seqNum = seqNum;
    }

    @Column(name="event_count")
    public long getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(long eventCount) {
        this.eventCount = eventCount;
    }

    @Column(name="event_dur_ms")
    public long getEventDurationMS() {
        return this.eventDurationMS;
    }

    public void setEventDurationMS(long eventDurationMS) {
        this.eventDurationMS = eventDurationMS;
    }

    @Column(name="tags")
    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    protected String truncate(String value, int limit, String columnName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> getTrunctedValue(%s, %d, %s)", value, limit, columnName));
        }
        String result = value;
        if (value != null) {
            if (limit < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Truncation is suppressed for column[%s]: old value [%s], new value[%s]", columnName, value, result));
                }
            } else if (limit == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Column[%s] is to be excluded from audit: old value [%s], new value[%s]", columnName, value, result));
                }
                result = null;
            } else if (value.length() > limit) {
                if (limit <= TruncationMarkerLength) {
                    result = value.substring(0, limit);
                } else {
                    StringBuilder sb = new StringBuilder(value.substring(0, limit - TruncationMarkerLength));
                    sb.append(TruncationMarker);
                    result = sb.toString();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Truncating value for column[%s] to [%d] characters: old value [%s], new value[%s]", columnName, limit, value, result));
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== getTrunctedValue(%s, %d, %s): %s", value, limit, columnName, result));
        }
        return result;
    }
}

