/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import java.lang.reflect.Field;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.InMemoryJAASConfiguration;
import org.apache.ranger.audit.utils.SolrAppUtil;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.Krb5HttpClientBuilder;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;

public class SolrAuditDestination
extends AuditDestination {
    private static final Log LOG = LogFactory.getLog(SolrAuditDestination.class);
    public static final String PROP_SOLR_URLS = "urls";
    public static final String PROP_SOLR_ZK = "zookeepers";
    public static final String PROP_SOLR_COLLECTION = "collection";
    public static final String PROP_SOLR_FORCE_USE_INMEMORY_JAAS_CONFIG = "force.use.inmemory.jaas.config";
    public static final String DEFAULT_COLLECTION_NAME = "ranger_audits";
    public static final String PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    private volatile SolrClient solrClient = null;

    @Override
    public void init(Properties props, String propPrefix) {
        LOG.info((Object)"init() called");
        super.init(props, propPrefix);
        this.init();
        this.connect();
    }

    @Override
    public void stop() {
        super.stop();
        this.logStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void connect() {
        SolrClient me = this.solrClient;
        if (me != null) return;
        Class<SolrAuditDestination> clazz = SolrAuditDestination.class;
        synchronized (SolrAuditDestination.class) {
            String collectionName;
            me = this.solrClient;
            if (this.solrClient != null) return;
            String urls = MiscUtil.getStringProperty(this.props, this.propPrefix + "." + PROP_SOLR_URLS);
            if (urls != null) {
                urls = urls.trim();
            }
            if (urls != null && urls.equalsIgnoreCase("NONE")) {
                urls = null;
            }
            List<Object> solrURLs = new ArrayList();
            String zkHosts = null;
            solrURLs = MiscUtil.toArray(urls, ",");
            zkHosts = MiscUtil.getStringProperty(this.props, this.propPrefix + "." + PROP_SOLR_ZK);
            if (zkHosts != null && zkHosts.equalsIgnoreCase("NONE")) {
                zkHosts = null;
            }
            if ((collectionName = MiscUtil.getStringProperty(this.props, this.propPrefix + "." + PROP_SOLR_COLLECTION)) == null || collectionName.equalsIgnoreCase("none")) {
                collectionName = DEFAULT_COLLECTION_NAME;
            }
            LOG.info((Object)("Solr zkHosts=" + zkHosts + ", solrURLs=" + urls + ", collectionName=" + collectionName));
            if (zkHosts != null && !zkHosts.isEmpty()) {
                LOG.info((Object)("Connecting to solr cloud using zkHosts=" + zkHosts));
                try {
                    Krb5HttpClientBuilder krbBuild = new Krb5HttpClientBuilder();
                    SolrHttpClientBuilder kb = krbBuild.getBuilder();
                    HttpClientUtil.setHttpClientBuilder((SolrHttpClientBuilder)kb);
                    final ArrayList<String> zkhosts = new ArrayList<String>(Arrays.asList(zkHosts.split(",")));
                    CloudSolrClient solrCloudClient = MiscUtil.executePrivilegedAction(new PrivilegedExceptionAction<CloudSolrClient>(){

                        @Override
                        public CloudSolrClient run() throws Exception {
                            CloudSolrClient solrCloudClient = new CloudSolrClient.Builder(zkhosts, Optional.empty()).build();
                            return solrCloudClient;
                        }
                    });
                    solrCloudClient.setDefaultCollection(collectionName);
                    me = this.solrClient = solrCloudClient;
                }
                catch (Throwable t) {
                    LOG.fatal((Object)("Can't connect to Solr server. ZooKeepers=" + zkHosts), t);
                }
                finally {
                    this.resetInitializerInSOLR();
                }
            } else {
                if (solrURLs == null || solrURLs.isEmpty()) return;
                try {
                    LOG.info((Object)("Connecting to Solr using URLs=" + solrURLs));
                    Krb5HttpClientBuilder krbBuild = new Krb5HttpClientBuilder();
                    SolrHttpClientBuilder kb = krbBuild.getBuilder();
                    HttpClientUtil.setHttpClientBuilder((SolrHttpClientBuilder)kb);
                    final List<Object> solrUrls = solrURLs;
                    LBHttpSolrClient lbSolrClient = MiscUtil.executePrivilegedAction(new PrivilegedExceptionAction<LBHttpSolrClient>(){

                        @Override
                        public LBHttpSolrClient run() throws Exception {
                            LBHttpSolrClient.Builder builder = new LBHttpSolrClient.Builder();
                            builder.withBaseSolrUrl((String)solrUrls.get(0));
                            builder.withConnectionTimeout(1000);
                            LBHttpSolrClient lbSolrClient = builder.build();
                            return lbSolrClient;
                        }
                    });
                    for (int i = 1; i < solrURLs.size(); ++i) {
                        lbSolrClient.addSolrServer((String)solrURLs.get(i));
                    }
                    me = this.solrClient = lbSolrClient;
                }
                catch (Throwable t) {
                    LOG.fatal((Object)("Can't connect to Solr server. URL=" + solrURLs), t);
                }
                finally {
                    this.resetInitializerInSOLR();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void resetInitializerInSOLR() {
        String solrJassConfigEnd;
        Configuration solrConfig = Configuration.getConfiguration();
        String solrConfigClassName = solrConfig.getClass().getName();
        if (solrConfigClassName.endsWith(solrJassConfigEnd = "SolrJaasConfiguration")) {
            try {
                Field f = solrConfig.getClass().getDeclaredField("initiateAppNames");
                if (f != null) {
                    f.setAccessible(true);
                    HashSet val = new HashSet();
                    f.set(solrConfig, val);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"resetInitializerInSOLR: successfully reset the initiateAppNames");
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("resetInitializerInSOLR: not applying on class [" + solrConfigClassName + "] as it does not have initiateAppNames variable name."));
                }
            }
            catch (Throwable t) {
                this.logError("resetInitializerInSOLR: Unable to reset SOLRCONFIG.initiateAppNames to be empty", t);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("resetInitializerInSOLR: not applying on class [" + solrConfigClassName + "] as it does not endwith [" + solrJassConfigEnd + "]"));
        }
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        boolean ret;
        block8: {
            ret = false;
            try {
                this.logStatusIfRequired();
                this.addTotalCount(events.size());
                if (this.solrClient == null) {
                    this.connect();
                    if (this.solrClient == null) {
                        this.addDeferredCount(events.size());
                        return ret;
                    }
                }
                ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
                for (AuditEventBase event : events) {
                    AuthzAuditEvent authzEvent = (AuthzAuditEvent)event;
                    SolrInputDocument document = this.toSolrDoc(authzEvent);
                    docs.add(document);
                }
                try {
                    UpdateResponse response = SolrAppUtil.addDocsToSolr(this.solrClient, docs);
                    if (response.getStatus() != 0) {
                        this.addFailedCount(events.size());
                        this.logFailedEvent(events, response.toString());
                        break block8;
                    }
                    this.addSuccessCount(events.size());
                    ret = true;
                }
                catch (SolrException ex) {
                    this.addFailedCount(events.size());
                    this.logFailedEvent(events, (Throwable)ex);
                }
            }
            catch (Throwable t) {
                this.addDeferredCount(events.size());
                this.logError("Error sending message to Solr", t);
            }
        }
        return ret;
    }

    @Override
    public void flush() {
    }

    SolrInputDocument toSolrDoc(AuthzAuditEvent auditEvent) {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.addField("id", (Object)auditEvent.getEventId());
        doc.addField("access", (Object)auditEvent.getAccessType());
        doc.addField("enforcer", (Object)auditEvent.getAclEnforcer());
        doc.addField("agent", (Object)auditEvent.getAgentId());
        doc.addField("repo", (Object)auditEvent.getRepositoryName());
        doc.addField("sess", (Object)auditEvent.getSessionId());
        doc.addField("reqUser", (Object)auditEvent.getUser());
        doc.addField("reqData", (Object)auditEvent.getRequestData());
        doc.addField("resource", (Object)auditEvent.getResourcePath());
        doc.addField("cliIP", (Object)auditEvent.getClientIP());
        doc.addField("logType", (Object)auditEvent.getLogType());
        doc.addField("result", (Object)auditEvent.getAccessResult());
        doc.addField("policy", (Object)auditEvent.getPolicyId());
        doc.addField("repoType", (Object)auditEvent.getRepositoryType());
        doc.addField("resType", (Object)auditEvent.getResourceType());
        doc.addField("reason", (Object)auditEvent.getResultReason());
        doc.addField("action", (Object)auditEvent.getAction());
        doc.addField("evtTime", (Object)auditEvent.getEventTime());
        doc.addField("seq_num", (Object)auditEvent.getSeqNum());
        doc.setField("event_count", (Object)auditEvent.getEventCount());
        doc.setField("event_dur_ms", (Object)auditEvent.getEventDurationMS());
        doc.setField("tags", auditEvent.getTags());
        doc.setField("cluster", (Object)auditEvent.getClusterName());
        doc.setField("zoneName", (Object)auditEvent.getZoneName());
        doc.setField("agentHost", (Object)auditEvent.getAgentHostname());
        doc.setField("policyVersion", (Object)auditEvent.getPolicyVersion());
        return doc;
    }

    public boolean isAsync() {
        return true;
    }

    private void init() {
        LOG.info((Object)"==>SolrAuditDestination.init()");
        try {
            String confFileName = System.getProperty(PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG);
            LOG.info((Object)("In solrAuditDestination.init() : JAAS Configuration set as [" + confFileName + "]"));
            if (System.getProperty(PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG) == null) {
                if (MiscUtil.getBooleanProperty(this.props, this.propPrefix + "." + PROP_SOLR_FORCE_USE_INMEMORY_JAAS_CONFIG, false)) {
                    System.setProperty(PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG, "/dev/null");
                } else {
                    LOG.warn((Object)"No Client JAAS config present in solr audit config. Ranger Audit to Kerberized Solr will fail...");
                }
            }
            LOG.info((Object)"Loading SolrClient JAAS config from Ranger audit config if present...");
            InMemoryJAASConfiguration.init(this.props);
        }
        catch (Exception e) {
            LOG.error((Object)"ERROR: Unable to load SolrClient JAAS config from Audit config file. Audit to Kerberized Solr will fail...", (Throwable)e);
        }
        finally {
            String confFileName = System.getProperty(PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG);
            LOG.info((Object)("In solrAuditDestination.init() (finally) : JAAS Configuration set as [" + confFileName + "]"));
        }
        LOG.info((Object)"<==SolrAuditDestination.init()");
    }
}

