/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.messaging.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyPrint {
    private PyPrint() {
    }

    public static String pprint(Object obj) {
        if (obj instanceof Map) {
            return PyPrint.pprint_map((Map)obj);
        }
        if (obj instanceof List) {
            return PyPrint.pprint_list((List)obj);
        }
        if (obj instanceof String) {
            return PyPrint.pprint_string((String)obj);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? "True" : "False";
        }
        if (obj == null) {
            return "None";
        }
        return obj.toString();
    }

    private static String indent(String st) {
        return "  " + st.replace("\n", "\n  ");
    }

    private static String pprint_map(Map<Object, Object> map) {
        ArrayList<String> items = new ArrayList<String>();
        for (Map.Entry<Object, Object> me : map.entrySet()) {
            items.add(String.format("%s: %s", PyPrint.pprint(me.getKey()), PyPrint.pprint(me.getValue())));
        }
        Collections.sort(items);
        return PyPrint.pprint_items("{", items, "}");
    }

    private static String pprint_list(List list) {
        ArrayList<String> items = new ArrayList<String>();
        for (Object o : list) {
            items.add(PyPrint.pprint(o));
        }
        return PyPrint.pprint_items("[", items, "]");
    }

    private static String pprint_items(String start, List<String> items, String end) {
        StringBuilder result = new StringBuilder();
        for (String item : items) {
            if (result.length() > 0) {
                result.append(",\n");
            }
            result.append(PyPrint.indent(item));
        }
        if (result.length() > 0) {
            return String.format("%s\n%s\n%s", start, result, end);
        }
        return String.format("%s%s", start, end);
    }

    private static String pprint_string(String st) {
        StringBuilder result = new StringBuilder();
        result.append('\'');
        block4: for (int i = 0; i < st.length(); ++i) {
            char c = st.charAt(i);
            switch (c) {
                case '\'': {
                    result.append("\\'");
                    continue block4;
                }
                case '\n': {
                    result.append("\\n");
                    continue block4;
                }
                default: {
                    if (c >= '\u0080') {
                        result.append(String.format("\\u%04x", c));
                        continue block4;
                    }
                    result.append(c);
                }
            }
        }
        result.append('\'');
        return result.toString();
    }
}

