/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.TestStringBody;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class TestStringBodyImpl
extends AMQMethodBody_8_0
implements TestStringBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new TestStringBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 20;
    private final AMQShortString _string1;
    private final byte[] _string2;
    private final short _operation;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public TestStringBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._string1 = this.readAMQShortString(buffer);
        this._string2 = this.readBytes(buffer);
        this._operation = this.readUnsignedByte(buffer);
    }

    public TestStringBodyImpl(AMQShortString string1, byte[] string2, short operation) {
        this._string1 = string1;
        this._string2 = string2;
        this._operation = operation;
    }

    public int getClazz() {
        return 120;
    }

    public int getMethod() {
        return 20;
    }

    public final AMQShortString getString1() {
        return this._string1;
    }

    public final byte[] getString2() {
        return this._string2;
    }

    public final short getOperation() {
        return this._operation;
    }

    protected int getBodySize() {
        int size = 1;
        size += this.getSizeOf(this._string1);
        return size += this.getSizeOf(this._string2);
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._string1);
        this.writeBytes(buffer, this._string2);
        this.writeUnsignedByte(buffer, this._operation);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchTestString(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[TestStringBodyImpl: ");
        buf.append("string1=");
        buf.append(this.getString1());
        buf.append(", ");
        buf.append("string2=");
        buf.append(this.getString2() == null ? "null" : Arrays.toString(this.getString2()));
        buf.append(", ");
        buf.append("operation=");
        buf.append(this.getOperation());
        buf.append("]");
        return buf.toString();
    }
}

