/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_91;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ExchangeBoundBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_91.AMQMethodBody_0_91;
import org.apache.qpid.framing.amqp_0_91.MethodDispatcher_0_91;

public class ExchangeBoundBodyImpl
extends AMQMethodBody_0_91
implements ExchangeBoundBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new ExchangeBoundBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 40;
    public static final int METHOD_ID = 22;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final AMQShortString _queue;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ExchangeBoundBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._exchange = this.readAMQShortString(buffer);
        this._routingKey = this.readAMQShortString(buffer);
        this._queue = this.readAMQShortString(buffer);
    }

    public ExchangeBoundBodyImpl(AMQShortString exchange, AMQShortString routingKey, AMQShortString queue) {
        this._exchange = exchange;
        this._routingKey = routingKey;
        this._queue = queue;
    }

    public int getClazz() {
        return 40;
    }

    public int getMethod() {
        return 22;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    protected int getBodySize() {
        int size = 0;
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._routingKey);
        return size += this.getSizeOf(this._queue);
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeAMQShortString(buffer, this._queue);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchExchangeBound(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ExchangeBoundBodyImpl: ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append("]");
        return buf.toString();
    }
}

