/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FilePublishBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class FilePublishBodyImpl
extends AMQMethodBody_0_9
implements FilePublishBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new FilePublishBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 70;
    public static final int METHOD_ID = 60;
    private final int _ticket;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final byte _bitfield0;
    private final AMQShortString _identifier;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public FilePublishBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._ticket = this.readUnsignedShort(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._routingKey = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
        this._identifier = this.readAMQShortString(buffer);
    }

    public FilePublishBodyImpl(int ticket, AMQShortString exchange, AMQShortString routingKey, boolean mandatory, boolean immediate, AMQShortString identifier) {
        this._ticket = ticket;
        this._exchange = exchange;
        this._routingKey = routingKey;
        byte bitfield0 = 0;
        if (mandatory) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (immediate) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        this._bitfield0 = bitfield0;
        this._identifier = identifier;
    }

    public int getClazz() {
        return 70;
    }

    public int getMethod() {
        return 60;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    public final boolean getMandatory() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getImmediate() {
        return (this._bitfield0 & 2) != 0;
    }

    public final AMQShortString getIdentifier() {
        return this._identifier;
    }

    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._routingKey);
        return size += this.getSizeOf(this._identifier);
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeAMQShortString(buffer, this._identifier);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchFilePublish(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[FilePublishBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("mandatory=");
        buf.append(this.getMandatory());
        buf.append(", ");
        buf.append("immediate=");
        buf.append(this.getImmediate());
        buf.append(", ");
        buf.append("identifier=");
        buf.append(this.getIdentifier());
        buf.append("]");
        return buf.toString();
    }
}

