/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQProtocolVersionException;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderPropertiesFactory;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;

public class ContentHeaderBody
implements AMQBody {
    public static final byte TYPE = 2;
    private int classId;
    private int weight;
    private long bodySize;
    private ContentHeaderProperties properties;

    public ContentHeaderBody() {
    }

    public ContentHeaderBody(DataInput buffer, long size) throws AMQFrameDecodingException, IOException {
        this.classId = buffer.readUnsignedShort();
        this.weight = buffer.readUnsignedShort();
        this.bodySize = buffer.readLong();
        int propertyFlags = buffer.readUnsignedShort();
        ContentHeaderPropertiesFactory factory = ContentHeaderPropertiesFactory.getInstance();
        this.properties = factory.createContentHeaderProperties(this.classId, propertyFlags, buffer, (int)size - 14);
    }

    public ContentHeaderBody(ContentHeaderProperties props, int classId) {
        this.properties = props;
        this.classId = classId;
    }

    public ContentHeaderBody(int classId, int weight, ContentHeaderProperties props, long bodySize) {
        this(props, classId);
        this.weight = weight;
        this.bodySize = bodySize;
    }

    public byte getFrameType() {
        return 2;
    }

    public static ContentHeaderBody createFromBuffer(DataInputStream buffer, long size) throws AMQFrameDecodingException, AMQProtocolVersionException, IOException {
        ContentHeaderBody body = new ContentHeaderBody(buffer, size);
        return body;
    }

    public int getSize() {
        return 14 + this.properties.getPropertyListSize();
    }

    public void writePayload(DataOutput buffer) throws IOException {
        EncodingUtils.writeUnsignedShort(buffer, this.classId);
        EncodingUtils.writeUnsignedShort(buffer, this.weight);
        buffer.writeLong(this.bodySize);
        EncodingUtils.writeUnsignedShort(buffer, this.properties.getPropertyFlags());
        this.properties.writePropertyListPayload(buffer);
    }

    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws AMQException {
        session.contentHeaderReceived(channelId, this);
    }

    public static AMQFrame createAMQFrame(int channelId, int classId, int weight, BasicContentHeaderProperties properties, long bodySize) {
        return new AMQFrame(channelId, new ContentHeaderBody(classId, weight, properties, bodySize));
    }

    public static AMQFrame createAMQFrame(int channelId, ContentHeaderBody body) {
        return new AMQFrame(channelId, body);
    }

    public ContentHeaderProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ContentHeaderProperties props) {
        this.properties = props;
    }

    public String toString() {
        return "ContentHeaderBody{classId=" + this.classId + ", weight=" + this.weight + ", bodySize=" + this.bodySize + ", properties=" + this.properties + '}';
    }

    public int getClassId() {
        return this.classId;
    }

    public int getWeight() {
        return this.weight;
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public void setBodySize(long bodySize) {
        this.bodySize = bodySize;
    }
}

