/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.util;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.qpid.util.UUIDGen;

public final class NameUUIDGen
implements UUIDGen {
    private static final int WIDTH = 8;
    private final byte[] seed;
    private final ByteBuffer seedBuf;
    private long counter;

    public NameUUIDGen() {
        String namespace = UUID.randomUUID().toString();
        this.seed = new byte[namespace.length() + 8];
        for (int i = 8; i < this.seed.length; ++i) {
            this.seed[i] = (byte)namespace.charAt(i - 8);
        }
        this.seedBuf = ByteBuffer.wrap(this.seed);
        this.counter = 0L;
    }

    public UUID generate() {
        this.seedBuf.putLong(0, this.counter++);
        return UUID.nameUUIDFromBytes(this.seed);
    }
}

