/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.mina;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.TransportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaSender
implements Sender<java.nio.ByteBuffer> {
    private static final int TIMEOUT = 120000;
    private final IoSession session;
    private WriteFuture lastWrite = null;

    public MinaSender(IoSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(java.nio.ByteBuffer buf) {
        if (this.session.isClosing()) {
            throw new TransportException("attempted to write to a closed socket");
        }
        MinaSender minaSender = this;
        synchronized (minaSender) {
            this.lastWrite = this.session.write((Object)ByteBuffer.wrap((java.nio.ByteBuffer)buf));
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        MinaSender minaSender = this;
        synchronized (minaSender) {
            if (this.lastWrite != null) {
                this.lastWrite.join();
            }
        }
        CloseFuture closed = this.session.close();
        closed.join();
    }

    @Override
    public void setIdleTimeout(int i) {
    }

    public long getIdleTimeout() {
        return 0L;
    }
}

