/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionClose;
import org.apache.qpid.transport.ConnectionCloseOk;
import org.apache.qpid.transport.ConnectionException;
import org.apache.qpid.transport.ConnectionHeartbeat;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ProtocolDelegate;
import org.apache.qpid.transport.ProtocolError;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionDetach;
import org.apache.qpid.transport.SessionDetachCode;
import org.apache.qpid.transport.SessionDetached;
import org.apache.qpid.transport.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionDelegate
extends MethodDelegate<Connection>
implements ProtocolDelegate<Connection> {
    private static final Logger log = Logger.get(ConnectionDelegate.class);

    @Override
    public void control(Connection conn, Method method) {
        method.dispatch(conn, this);
    }

    @Override
    public void command(Connection conn, Method method) {
        method.dispatch(conn, this);
    }

    @Override
    public void error(Connection conn, ProtocolError error) {
        conn.exception(new ConnectionException(error.getMessage()));
    }

    @Override
    public void handle(Connection conn, Method method) {
        conn.dispatch(method);
    }

    @Override
    public void connectionHeartbeat(Connection conn, ConnectionHeartbeat hearbeat) {
    }

    @Override
    public void connectionClose(Connection conn, ConnectionClose close) {
        conn.connectionCloseOk(new Option[0]);
        conn.getSender().close();
        conn.closeCode(close);
        conn.setState(Connection.State.CLOSE_RCVD);
    }

    @Override
    public void connectionCloseOk(Connection conn, ConnectionCloseOk ok) {
        conn.getSender().close();
    }

    @Override
    public void sessionDetach(Connection conn, SessionDetach dtc) {
        Session ssn = conn.getSession(dtc.getChannel());
        ssn.sessionDetached(dtc.getName(), SessionDetachCode.NORMAL, new Option[0]);
        conn.unmap(ssn);
        ssn.closed();
    }

    @Override
    public void sessionDetached(Connection conn, SessionDetached dtc) {
        Session ssn = conn.getSession(dtc.getChannel());
        if (ssn != null) {
            conn.unmap(ssn);
            ssn.closed();
        }
    }
}

