/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protocol;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.framing.AMQShortString;

public final class AMQConstant {
    private static Map<Integer, AMQConstant> _codeMap = new HashMap<Integer, AMQConstant>();
    public static final AMQConstant REPLY_SUCCESS = new AMQConstant(200, "reply success", true);
    public static final AMQConstant FRAME_END = new AMQConstant(206, "frame end", true);
    public static final AMQConstant NOT_DELIVERED = new AMQConstant(310, "not delivered", true);
    public static final AMQConstant MESSAGE_TOO_LARGE = new AMQConstant(311, "message too large", true);
    public static final AMQConstant NO_ROUTE = new AMQConstant(312, "no route", true);
    public static final AMQConstant NO_CONSUMERS = new AMQConstant(313, "no consumers", true);
    public static final AMQConstant CONTEXT_IN_USE = new AMQConstant(320, "context in use", true);
    public static final AMQConstant INVALID_PATH = new AMQConstant(402, "invalid path", true);
    public static final AMQConstant ACCESS_REFUSED = new AMQConstant(403, "access refused", true);
    public static final AMQConstant NOT_FOUND = new AMQConstant(404, "not found", true);
    public static final AMQConstant ALREADY_EXISTS = new AMQConstant(405, "Already exists", true);
    public static final AMQConstant IN_USE = new AMQConstant(406, "In use", true);
    public static final AMQConstant INVALID_ROUTING_KEY = new AMQConstant(407, "routing key invalid", true);
    public static final AMQConstant REQUEST_TIMEOUT = new AMQConstant(408, "Request Timeout", true);
    public static final AMQConstant INVALID_ARGUMENT = new AMQConstant(409, "argument invalid", true);
    public static final AMQConstant FRAME_ERROR = new AMQConstant(501, "frame error", true);
    public static final AMQConstant SYNTAX_ERROR = new AMQConstant(502, "syntax error", true);
    public static final AMQConstant COMMAND_INVALID = new AMQConstant(503, "command invalid", true);
    public static final AMQConstant CHANNEL_ERROR = new AMQConstant(504, "channel error", true);
    public static final AMQConstant RESOURCE_ERROR = new AMQConstant(506, "resource error", true);
    public static final AMQConstant NOT_ALLOWED = new AMQConstant(530, "not allowed", true);
    public static final AMQConstant NOT_IMPLEMENTED = new AMQConstant(540, "not implemented", true);
    public static final AMQConstant INTERNAL_ERROR = new AMQConstant(541, "internal error", true);
    public static final AMQConstant FRAME_MIN_SIZE = new AMQConstant(4096, "frame min size", true);
    public static final AMQConstant UNSUPPORTED_BROKER_PROTOCOL_ERROR = new AMQConstant(542, "broker unsupported protocol", true);
    public static final AMQConstant UNSUPPORTED_CLIENT_PROTOCOL_ERROR = new AMQConstant(543, "client unsupported protocol", true);
    private int _code;
    private AMQShortString _name;

    private AMQConstant(int code, String name, boolean map) {
        this._code = code;
        this._name = new AMQShortString(name);
        if (map) {
            _codeMap.put(code, this);
        }
    }

    public static AMQConstant getConstant(int code) {
        AMQConstant c = _codeMap.get(code);
        if (c == null) {
            c = new AMQConstant(code, "unknown code", false);
        }
        return c;
    }

    public int getCode() {
        return this._code;
    }

    public AMQShortString getName() {
        return this._name;
    }

    public String toString() {
        return this._code + ": " + this._name;
    }
}

