/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.abstraction.AbstractMethodConverter;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.framing.abstraction.MessagePublishInfoImpl;
import org.apache.qpid.framing.abstraction.ProtocolVersionMethodConverter;
import org.apache.qpid.framing.amqp_8_0.BasicPublishBodyImpl;

public class MethodConverter_8_0
extends AbstractMethodConverter
implements ProtocolVersionMethodConverter {
    private int _basicPublishClassId;
    private int _basicPublishMethodId;

    public MethodConverter_8_0() {
        super((byte)8, (byte)0);
    }

    public AMQBody convertToBody(ContentChunk contentChunk) {
        return new ContentBody(contentChunk.getData());
    }

    public ContentChunk convertToContentChunk(AMQBody body) {
        final ContentBody contentBodyChunk = (ContentBody)body;
        return new ContentChunk(){

            public int getSize() {
                return contentBodyChunk.getSize();
            }

            public ByteBuffer getData() {
                return contentBodyChunk.payload;
            }

            public void reduceToFit() {
                contentBodyChunk.reduceBufferToFit();
            }
        };
    }

    public void configure() {
        this._basicPublishClassId = 60;
        this._basicPublishMethodId = 40;
    }

    public AMQBody convertToBody(java.nio.ByteBuffer buf) {
        return new ContentBody(ByteBuffer.wrap((java.nio.ByteBuffer)buf));
    }

    public MessagePublishInfo convertToInfo(AMQMethodBody methodBody) {
        BasicPublishBody publishBody = (BasicPublishBody)methodBody;
        AMQShortString exchange = publishBody.getExchange();
        AMQShortString routingKey = publishBody.getRoutingKey();
        return new MessagePublishInfoImpl(exchange == null ? null : exchange.intern(), publishBody.getImmediate(), publishBody.getMandatory(), routingKey == null ? null : routingKey.intern());
    }

    public AMQMethodBody convertToBody(MessagePublishInfo info) {
        return new BasicPublishBodyImpl(0, info.getExchange(), info.getRoutingKey(), info.isMandatory(), info.isImmediate());
    }
}

