/*
 * Decompiled with CFR 0.152.
 */
package org.apache.configuration;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyNameResolver {
    private static Map<Class<?>, Accessor> accessors = new HashMap();
    protected Map<String, QpidProperty> properties;

    public Integer getIntegerValue(String propName) {
        return this.properties.get(propName).get(Integer.class);
    }

    public Long getLongValue(String propName) {
        return this.properties.get(propName).get(Long.class);
    }

    public String getStringValue(String propName) {
        return this.properties.get(propName).get(String.class);
    }

    public Boolean getBooleanValue(String propName) {
        return this.properties.get(propName).get(Boolean.class);
    }

    public <T> T get(String propName, Class<T> klass) {
        return this.properties.get(propName).get(klass);
    }

    static {
        accessors.put(Boolean.class, new BooleanAccessor());
        accessors.put(Integer.class, new IntegerAccessor());
        accessors.put(String.class, new StringAccessor());
        accessors.put(Long.class, new LongAccessor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QpidProperty {
        private Object defValue;
        private String[] names;

        QpidProperty(Object defValue, String ... names) {
            this.defValue = defValue;
            this.names = names;
        }

        <T> T get(Class<T> klass) {
            Accessor acc = (Accessor)accessors.get(klass);
            for (String name : this.names) {
                Object obj = acc.get(name);
                if (obj == null) continue;
                return klass.cast(obj);
            }
            return klass.cast(this.defValue);
        }
    }

    private static class StringAccessor
    implements Accessor {
        private StringAccessor() {
        }

        public String get(String name) {
            return System.getProperty(name);
        }
    }

    private static class LongAccessor
    implements Accessor {
        private LongAccessor() {
        }

        public Long get(String name) {
            return Long.getLong(name);
        }
    }

    private static class IntegerAccessor
    implements Accessor {
        private IntegerAccessor() {
        }

        public Integer get(String name) {
            return Integer.getInteger(name);
        }
    }

    private static class BooleanAccessor
    implements Accessor {
        private BooleanAccessor() {
        }

        public Boolean get(String name) {
            return Boolean.getBoolean(name);
        }
    }

    public static interface Accessor {
        public Object get(String var1);
    }
}

