/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.security.oauth2;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class OAuth2SaslClient
implements SaslClient {
    public static final String MECHANISM = "XOAUTH2";
    private final CallbackHandler _callbackHandler;
    private boolean _isComplete = false;

    public OAuth2SaslClient(CallbackHandler callbackHandler) {
        this._callbackHandler = callbackHandler;
    }

    @Override
    public String getMechanismName() {
        return MECHANISM;
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (this._isComplete) {
            return new byte[0];
        }
        PasswordCallback callback = new PasswordCallback("promptunused", false);
        Callback[] callbacks = new Callback[]{callback};
        try {
            this._callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Unsupported callback", e);
        }
        catch (IOException e) {
            throw new SaslException("Failed to execute callback", e);
        }
        String accessToken = new String(callback.getPassword());
        if (accessToken == null || accessToken.length() == 0) {
            throw new SaslException("OAuth2SaslClient requires that the OAuth2 access token is supplied via the connection's password");
        }
        byte[] response = String.format("auth=Bearer %s\u0001\u0001", accessToken).getBytes();
        this._isComplete = true;
        return response;
    }

    @Override
    public boolean isComplete() {
        return this._isComplete;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new SaslException();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new SaslException();
    }

    @Override
    public void dispose() throws SaslException {
    }
}

