/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.TemporaryQueue;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.TemporaryDestination;
import org.apache.qpid.framing.AMQShortString;

final class AMQTemporaryQueue
extends AMQQueue
implements TemporaryQueue,
TemporaryDestination {
    private final AMQSession _session;
    private boolean _deleted;

    public AMQTemporaryQueue(AMQSession session) {
        super(session.getTemporaryQueueExchangeName(), new AMQShortString("TempQueue" + UUID.randomUUID()), true);
        this._session = session;
    }

    public synchronized void delete() throws JMSException {
        if (this._session.hasConsumer(this)) {
            throw new JMSException("Temporary Queue has consumers so cannot be deleted");
        }
        this._deleted = true;
    }

    public AMQSession getSession() {
        return this._session;
    }

    public boolean isDeleted() {
        return this._deleted;
    }
}

