/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import org.apache.qpid.server.security.access.config.LegacyOperation;

public enum ObjectType {
    ALL,
    VIRTUALHOSTNODE(LegacyOperation.ALL, LegacyOperation.CREATE, LegacyOperation.DELETE, LegacyOperation.UPDATE, LegacyOperation.INVOKE),
    VIRTUALHOST(LegacyOperation.ALL, LegacyOperation.ACCESS, LegacyOperation.CREATE, LegacyOperation.DELETE, LegacyOperation.UPDATE, LegacyOperation.ACCESS_LOGS, LegacyOperation.INVOKE),
    MANAGEMENT(LegacyOperation.ALL, LegacyOperation.ACCESS),
    QUEUE(LegacyOperation.ALL, LegacyOperation.CREATE, LegacyOperation.DELETE, LegacyOperation.PURGE, LegacyOperation.CONSUME, LegacyOperation.UPDATE, LegacyOperation.INVOKE),
    EXCHANGE(LegacyOperation.ALL, LegacyOperation.ACCESS, LegacyOperation.CREATE, LegacyOperation.DELETE, LegacyOperation.BIND, LegacyOperation.UNBIND, LegacyOperation.PUBLISH, LegacyOperation.UPDATE, LegacyOperation.INVOKE),
    METHOD(LegacyOperation.ALL, LegacyOperation.ACCESS, LegacyOperation.UPDATE),
    USER(LegacyOperation.ALL, LegacyOperation.CREATE, LegacyOperation.DELETE, LegacyOperation.UPDATE, LegacyOperation.INVOKE),
    GROUP(LegacyOperation.ALL, LegacyOperation.CREATE, LegacyOperation.DELETE, LegacyOperation.UPDATE, LegacyOperation.INVOKE),
    BROKER(LegacyOperation.ALL, LegacyOperation.CONFIGURE, LegacyOperation.ACCESS_LOGS, LegacyOperation.SHUTDOWN, LegacyOperation.INVOKE);

    private final EnumSet<LegacyOperation> _operations;
    private final String _description;

    private ObjectType(LegacyOperation ... rest) {
        this._operations = EnumSet.of(LegacyOperation.ALL, rest);
        this._description = this.description();
    }

    private ObjectType() {
        this._operations = EnumSet.allOf(LegacyOperation.class);
        this._description = this.description();
    }

    private String description() {
        String name = this.name();
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1).toLowerCase(Locale.ENGLISH);
    }

    public Set<LegacyOperation> getOperations() {
        return Collections.unmodifiableSet(this._operations);
    }

    public boolean isSupported(LegacyOperation operation) {
        return this._operations.contains((Object)operation);
    }

    public String toString() {
        return this._description;
    }
}

